/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WizardDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(WizardDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int WIZARD_DIALOG_WIDTH = 585;
    private static final int WIZARD_DIALOG_HEIGHT = 400;
    private List<JLabel> stepLabels;
    private Card currentCard;
    private Box navigationBar;
    private JPanel contentPane;
    private ImagePanel stepPane;

    public WizardDialog(List<String> stepNames) {
        this.init(stepNames, new String[0]);
    }

    public WizardDialog(Dialog dialog, List<String> stepNames) {
        super(dialog, true);
        this.init(stepNames, new String[0]);
    }

    public WizardDialog(Frame frame, List<String> stepNames, String ... visibleStepName) {
        super(frame, true);
        this.init(stepNames, visibleStepName);
    }

    public void setFirstCard(Card firstCard) {
        this.setCurrentCard(firstCard);
    }

    public void setImage(ImageIcon bgImage) {
    }

    private void init(List<String> stepNames, String ... visibleStepName) {
        this.stepLabels = new ArrayList<JLabel>(0);
        if (null != stepNames) {
            JLabel label = null;
            FontMetrics fm = null;
            for (String stepName : stepNames) {
                label = new JLabel();
                fm = IsmPlafUtils.getFontMetrics(label, null, IsmFontFactory.getDialogPlain());
                label.setText(UCD.wrapTextWithHTML(fm, stepName, 120));
                this.stepLabels.add(label);
            }
        }
        this.contentPane = new JPanel(new BorderLayout());
        this.navigationBar = Box.createHorizontalBox();
        Box southBox = Box.createVerticalBox();
        southBox.add(new JSeparator());
        southBox.add(Box.createVerticalStrut(12));
        southBox.add(this.navigationBar);
        JPanel pane = new JPanel(new BorderLayout());
        this.getContentPane().add(pane);
        this.initStepPane(pane, visibleStepName);
        pane.add((Component)this.stepPane, "West");
        pane.add((Component)this.contentPane, "Center");
        pane.add((Component)southBox, "South");
        pane.setBorder(new EmptyBorder(0, 0, 12, 0));
        pane.setPreferredSize(new Dimension(585, 400));
        this.setDefaultCloseOperation(2);
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setResizable(false);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    private void initStepPane(JPanel pane, String[] visibleStepName) {
        this.stepPane = new ImagePanel(ResourceManager.getImage("wizard_step_bg.png"), ImagePanel.ExtendOrient.VERTICAL_BOTTOM_TO_TOP);
        this.stepPane.setBackground(new Color(14479615));
        pane.setBackground(new Color(13688042));
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            this.stepPane = new ImagePanel(ResourceManager.getImage("wizard_step_bg_armor.png"), ImagePanel.ExtendOrient.VERTICAL_BOTTOM_TO_TOP);
            this.stepPane.setBackground(new Color(0xEBEBEB));
            pane.setBackground(new Color(0xD9D9D9));
        } else if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            this.stepPane = new ImagePanel(ResourceManager.getImage("wizard_step_bg_armor.png"), ImagePanel.ExtendOrient.VERTICAL_BOTTOM_TO_TOP);
            this.stepPane.setBackground(new Color(0xFFFFFF));
            pane.setBackground(new Color(0xFFFFFF));
        }
        this.stepPane.setLayout(new BoxLayout(this.stepPane, 1));
        this.stepPane.add(Box.createRigidArea(new Dimension(155, 16)));
        this.stepPane.setAlignmentX(0.0f);
        Box row = null;
        for (JLabel label : this.stepLabels) {
            row = Box.createHorizontalBox();
            if (visibleStepName != null) {
                for (String tmpName : visibleStepName) {
                    if (!label.getText().contains(tmpName)) continue;
                    label.setVisible(false);
                    break;
                }
            }
            if (!label.isVisible()) continue;
            row.add(Box.createRigidArea(new Dimension(16, 0)));
            row.add(label);
            row.add(Box.createHorizontalGlue());
            this.stepPane.add(row);
            this.stepPane.add(Box.createVerticalStrut(8));
        }
        this.stepPane.add(Box.createVerticalGlue());
    }

    private void setCurrentCard(Card card) {
        if (null != card) {
            this.currentCard = card;
            this.contentPane.removeAll();
            this.contentPane.add(card);
            card.requestFocus();
            this.initNavigationHandle();
            this.updateNavigationBar();
            this.navigationBar.repaint();
            this.updateStepPane();
            this.setTitle(card.getTitle());
            this.contentPane.revalidate();
            this.contentPane.repaint();
            this.repaint();
        }
    }

    private void updateStepPane() {
        int currentStep = this.currentCard.getStep();
        if (0 <= currentStep && currentStep < this.stepLabels.size()) {
            JLabel stepLabel = null;
            for (int i = 0; i < this.stepLabels.size(); ++i) {
                stepLabel = this.stepLabels.get(i);
                stepLabel.setIcon(null);
                if (i == currentStep) {
                    stepLabel.setForeground(Color.BLACK);
                    stepLabel.setIcon(UIManager.getIcon("IsmTreeUI.arrowIcon"));
                    stepLabel.setHorizontalTextPosition(2);
                    continue;
                }
                stepLabel.setForeground(Color.GRAY);
            }
        }
    }

    private void initNavigationHandle() {
        if (!this.currentCard.actionInjected) {
            Map naviButtons = this.currentCard.navigationButtons;
            if (naviButtons.containsKey((Object)Navigation.Previous)) {
                JButton previousButton = (JButton)naviButtons.get((Object)Navigation.Previous);
                previousButton.addActionListener(new PreviousBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.Next)) {
                JButton nextButton = (JButton)naviButtons.get((Object)Navigation.Next);
                nextButton.addActionListener(new NexBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.Complete)) {
                JButton completeButton = (JButton)naviButtons.get((Object)Navigation.Complete);
                completeButton.addActionListener(new CompleteBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.Cancel)) {
                JButton cancelButton = (JButton)naviButtons.get((Object)Navigation.Cancel);
                cancelButton.addActionListener(new CancelBtnAction());
            }
            this.getRootPane().getActionMap().remove("ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", new EscBtnAction());
            this.currentCard.actionInjected = true;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201 && !this.currentCard.isValid(Navigation.Cancel)) {
            return;
        }
        if (windowEvent.getID() == 201 && !this.currentCard.doEscTaskResult()) {
            return;
        }
        super.processWindowEvent(windowEvent);
    }

    @Override
    public void dispose() {
        try {
            if (null != this.currentCard) {
                this.currentCard.doCancelTask();
            }
        }
        catch (Exception ex) {
            LOGGER.error("", (Throwable)ex);
        }
        super.dispose();
    }

    private void updateNavigationBar() {
        JButton button;
        Map naviButtons = this.currentCard.navigationButtons;
        this.navigationBar.removeAll();
        this.navigationBar.add(Box.createHorizontalGlue());
        if (naviButtons.containsKey((Object)Navigation.Previous)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Previous));
        }
        if (naviButtons.containsKey((Object)Navigation.Next)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Next));
        }
        if (naviButtons.containsKey((Object)Navigation.Complete)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Complete));
        }
        if (naviButtons.containsKey((Object)Navigation.Cancel)) {
            this.navigationBar.add(Box.createHorizontalStrut(4));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.Cancel));
        }
        this.navigationBar.add(Box.createHorizontalStrut(10));
        JButton helpButton = UCD.createButton(ResourceManager.getString("COMMON.TXT.HELP"), 'H');
        this.navigationBar.add(helpButton);
        HelpManager.getInstance().linkHelp((AbstractButton)helpButton, this.currentCard.getHelpID());
        this.navigationBar.add(Box.createHorizontalStrut(12));
        if (naviButtons.containsKey((Object)Navigation.Next)) {
            button = (JButton)naviButtons.get((Object)Navigation.Next);
            this.getRootPane().setDefaultButton(button);
        }
        if (naviButtons.containsKey((Object)Navigation.Complete)) {
            button = (JButton)naviButtons.get((Object)Navigation.Complete);
            this.getRootPane().setDefaultButton(button);
        }
    }

    public static abstract class Card
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Card previousCard;
        private boolean actionInjected;
        private Map<Navigation, JButton> navigationButtons = new HashMap<Navigation, JButton>(0);

        public Card() {
        }

        public Card(Card previousCard, Navigation ... supportedNavigation) {
            if (IsmPlafUtils.getLAFStyle() != IsmPlafUtils.LAFStyle.armor) {
                this.setBackground(new Color(16054010));
            }
            this.setLayout(new BorderLayout());
            this.previousCard = previousCard;
            HashSet<Navigation> navigationList = new HashSet<Navigation>(0);
            if (null == supportedNavigation || 0 == supportedNavigation.length) {
                navigationList.add(Navigation.Previous);
                navigationList.add(Navigation.Next);
            } else {
                navigationList.addAll(Arrays.asList(supportedNavigation));
            }
            navigationList.add(Navigation.Cancel);
            Navigation tempNav = (Navigation)((Object)navigationList.toArray()[0]);
            for (Navigation navigation : navigationList) {
                if (navigation.toString().length() <= tempNav.toString().length()) continue;
                tempNav = navigation;
            }
            JButton tplBtn = UCD.createButton(tempNav.toString(), tempNav.mnemonic);
            this.navigationButtons.put(tempNav, tplBtn);
            String name = null;
            char mnemonic = '0';
            JButton button = null;
            for (Navigation navigation : navigationList) {
                if (navigation.equals((Object)tempNav)) continue;
                name = navigation.toString();
                mnemonic = navigation.mnemonic;
                button = UCD.createButton(name, tplBtn.getPreferredSize(), mnemonic);
                this.navigationButtons.put(navigation, button);
            }
            this.updateNavigationBar();
        }

        public final void updateNavigationBar() {
            JButton button = null;
            for (Navigation type : this.navigationButtons.keySet()) {
                button = this.navigationButtons.get((Object)type);
                button.setEnabled(this.isValid(type));
            }
        }

        public final Card getPreviousCard() {
            return this.previousCard;
        }

        public abstract String getTitle();

        public abstract int getStep();

        protected abstract Card getNextCard();

        protected abstract boolean isValid(Navigation var1);

        protected abstract boolean process(Navigation var1);

        protected abstract String getHelpID();

        protected void doCancelTask() {
        }

        protected void doPreviousBtnTask() {
        }

        protected boolean doEscTaskResult() {
            return true;
        }

        protected void refreshUI() {
            SwingUtil.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    this.revalidate();
                    this.repaint();
                }
            });
        }
    }

    public static enum Navigation {
        Previous('P'),
        Next('N'),
        Complete('F'),
        Cancel('C');

        private char mnemonic;

        private Navigation(char mnemonic) {
            this.mnemonic = mnemonic;
        }

        public String toString() {
            String prefix = "COMMON.TXT.";
            return ResourceManager.getString(prefix + this.name().toUpperCase(ResourceManager.getLocale()), this.name());
        }
    }

    private final class EscBtnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EscBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!WizardDialog.this.currentCard.isValid(Navigation.Cancel)) {
                return;
            }
            if (!WizardDialog.this.currentCard.doEscTaskResult()) {
                return;
            }
            WizardDialog.this.dispose();
        }
    }

    private final class NexBtnAction
    implements ActionListener {
        private NexBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Card nextCard;
            boolean success = WizardDialog.this.currentCard.process(Navigation.Next);
            if (success && null != (nextCard = WizardDialog.this.currentCard.getNextCard())) {
                WizardDialog.this.setCurrentCard(nextCard);
            }
        }
    }

    private final class CompleteBtnAction
    implements ActionListener {
        private CompleteBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = WizardDialog.this.currentCard.process(Navigation.Complete);
            if (success) {
                WizardDialog.this.dispose();
            }
        }
    }

    private final class CancelBtnAction
    implements ActionListener {
        private CancelBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (WizardDialog.this.currentCard.process(Navigation.Cancel)) {
                WizardDialog.this.dispose();
            }
        }
    }

    private final class PreviousBtnAction
    implements ActionListener {
        private PreviousBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Card previousCard;
            boolean success = WizardDialog.this.currentCard.process(Navigation.Previous);
            if (success && null != (previousCard = WizardDialog.this.currentCard.getPreviousCard())) {
                previousCard.doPreviousBtnTask();
                WizardDialog.this.setCurrentCard(previousCard);
            }
        }
    }
}

