/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.ui.module.command.CommandExcutorObserver;
import com.huawei.ism.ui.templets.wizard.Card;
import com.huawei.ism.ui.templets.wizard.DefaultFinishedCardView;
import com.huawei.ism.ui.templets.wizard.Wizard;
import com.huawei.ism.ui.templets.wizard.WizardModel;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Utils;
import java.util.List;

public class DefaultFinishedCard
extends Card
implements CommandExcutorObserver {
    private DefaultFinishedCardView layout = null;
    private String helpKey;
    private String successResultText = "";
    private String failureResultText = "";

    public DefaultFinishedCard() {
        this(new DefaultFinishedCardView());
    }

    public DefaultFinishedCard(DefaultFinishedCardView view) {
        this.setCardView(view);
    }

    @Override
    protected Wizard.CardHead getCardHead() {
        Wizard.CardHead cardHead = new Wizard.CardHead(ResourceManager.getString("RESULT"), "");
        return cardHead;
    }

    @Override
    protected String getHelpKey() {
        return this.helpKey;
    }

    void setHelpKey(String helpKey) {
        this.helpKey = helpKey;
    }

    @Override
    protected final Card.Step getStep() {
        return FINISH_STEP;
    }

    protected void beforeInitTask() {
    }

    @Override
    protected final boolean doInitTask() {
        this.beforeInitTask();
        List<Command> commandsTemp = this.getCommands();
        if (null == commandsTemp || commandsTemp.isEmpty()) {
            return false;
        }
        this.layout = CommonUtil.convertObject(this.getCardView(), DefaultFinishedCardView.class);
        return true;
    }

    @Override
    protected final void showing() {
        this.getWizard().setButtonEnable(Wizard.EWizardButton.CLOSE, false);
        List<Command> commandsTemp = this.getCommands();
        CommandExcutor.EExecuteMode executeMode = (CommandExcutor.EExecuteMode)((Object)this.getWizard().getModel().getMutualData("CommandExcutorMode"));
        if (null == executeMode) {
            executeMode = CommandExcutor.EExecuteMode.FAILED_CONTINUE;
        }
        AsyncExcutor.execute(null, (CommandExcutorObserver)this, executeMode, commandsTemp.toArray(new Command[commandsTemp.size()]));
    }

    @Override
    protected void doAfterClosing() {
        super.doAfterClosing();
    }

    @Override
    public void fireExcuteFinished() {
        this.getWizard().setButtonEnable(Wizard.EWizardButton.CLOSE, true);
        List<Command> commandList = this.getCommands();
        if (Utils.isNullList(commandList)) {
            return;
        }
        int i = 0;
        CommandExcutor.CommandState commandState = null;
        for (Command command : commandList) {
            commandState = command.getCommandState();
            if (commandState != CommandExcutor.CommandState.FAILED) continue;
            ++i;
        }
        if (i == 0) {
            this.layout.setResultDetailsLabelInfo(this.successResultText);
        } else if (i == commandList.size()) {
            this.layout.setResultDetailsLabelInfo(this.failureResultText);
        } else {
            this.layout.setResultDetailsLabelInfo(ResourceManager.getStringWithParams("wizard.execute.complete.desc", i));
        }
    }

    public void setSuccessResultText(String text) {
        this.successResultText = text;
    }

    public void setFailureResultText(String text) {
        this.failureResultText = text;
    }

    protected List<Command> getCommands() {
        WizardModel wizardModel = this.getWizard().getModel();
        List commandsTemp = (List)wizardModel.getMutualData("CommandListIdentifier");
        return commandsTemp;
    }

    @Override
    public final void fireAddCommand(Command ... commandsTemp) {
        this.layout.addCommands(commandsTemp);
    }

    @Override
    public final void fireStateChanged(Command ... commandsTemp) {
        for (Command command : commandsTemp) {
            this.layout.update(command);
        }
    }
}

