/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.ui.module.perfhis.TimeSeriesChart;
import java.util.Date;
import java.util.List;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.data.time.TimeSeries;

public class PerfStatChartProgressListener
implements ChartProgressListener {
    private TimeSeriesChart chart;

    public PerfStatChartProgressListener(TimeSeriesChart chart) {
        this.chart = chart;
    }

    public void chartProgress(ChartProgressEvent e) {
        long xDuper = this.chart.getAxisX().getMaximumDate().getTime();
        long lastTimePoint = this.getLastTimePoint(this.chart);
        if (lastTimePoint == xDuper) {
            this.chart.getAxisX().setMaximumDate(new Date(lastTimePoint + 1L));
        }
    }

    private long getLastTimePoint(TimeSeriesChart viewPanel) {
        long lastTimePoint = 0L;
        List<TimeSeries> allTimeSeries = viewPanel.getAllSeries();
        for (TimeSeries timeSeries : allTimeSeries) {
            long timePoint;
            if (timeSeries.getItemCount() <= 0 || (timePoint = timeSeries.getTimePeriod(timeSeries.getItemCount() - 1).getLastMillisecond()) <= lastTimePoint) continue;
            lastTimePoint = timePoint;
        }
        return lastTimePoint;
    }
}

