/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TickableTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -6687384485936224486L;
    private Icon nodeIcon;
    private boolean ticked = false;
    private boolean dispalyTickBox = true;
    private boolean hide = false;
    private boolean selectable = true;
    private String name = null;
    private Color color;

    public TickableTreeNode(Object userObject) {
        super(userObject);
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return (TreeNode)this.children.elementAt(this.convertToWholeChildrenIndex(index));
    }

    @Override
    public int getIndex(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.convertToNotHideChildrenIndex(this.children.indexOf(aChild));
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        TickableTreeNode tickableTreeNode = null;
        Object object = null;
        for (int i = 0; i < this.children.size(); ++i) {
            object = this.children.get(i);
            if (object instanceof TickableTreeNode && (tickableTreeNode = (TickableTreeNode)object).isHide()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(this.convertToWholeChildrenIndex(childIndex));
        child.setParent(null);
    }

    private int convertToWholeChildrenIndex(int notHideChildIndex) {
        Object object = null;
        TickableTreeNode tickableTreeNode = null;
        int childrenNum = this.children.size();
        int iterNotHideChildIndex = notHideChildIndex;
        for (int i = 0; i < childrenNum; ++i) {
            object = this.children.get(i);
            if (object instanceof TickableTreeNode && (tickableTreeNode = (TickableTreeNode)object).isHide() || iterNotHideChildIndex-- != 0) continue;
            return i;
        }
        throw new ArrayIndexOutOfBoundsException("invalid index");
    }

    private int convertToNotHideChildrenIndex(int wholeChildrenIndex) {
        int notHideChildIndex = 0;
        Object object = null;
        TickableTreeNode tickableTreeNode = null;
        for (int i = 0; i < wholeChildrenIndex; ++i) {
            object = this.children.get(i);
            if (object instanceof TickableTreeNode && (tickableTreeNode = (TickableTreeNode)object).isHide()) continue;
            ++notHideChildIndex;
        }
        return notHideChildIndex;
    }

    public Icon getNodeIcon() {
        return this.nodeIcon;
    }

    public void setNodeIcon(Icon nodeIcon) {
        this.nodeIcon = nodeIcon;
    }

    public boolean isTicked() {
        return this.ticked;
    }

    public void setTicked(boolean ticked) {
        this.ticked = ticked;
    }

    public void reverseTicked() {
        this.ticked = !this.ticked;
    }

    public boolean isDispalyTickBox() {
        return this.dispalyTickBox;
    }

    public void setDispalyTickBox(boolean dispalyTickBox) {
        this.dispalyTickBox = dispalyTickBox;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String getNodeName() {
        return this.name;
    }

    public void setNodeName(String value) {
        this.name = value;
    }
}

