/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SecurityConfig {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    public static final String CONFIG_FILE_NAME = "securityConfig.xml";
    public static final String SECURITY_CONFIG_NODE = "compatibilityAlgorithmEnabled";
    public static final String PRIVACY_STATEMENT_AGREE_FLAG = "privacyStatementAgreeFlag";
    private static String SECURITY_CONFIG_FILE_PATH = ApplicationContext.getInstance().getCurrWorkPath() + ApplicationContext.getInstance().getUserDataPath() + File.separatorChar + "securityConfig.xml";

    public static String getFilePath() {
        return SECURITY_CONFIG_FILE_PATH;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOnlySecurityAlgorithm() {
        if (LocalHostUtil.isRunInSvp()) {
            return false;
        }
        File file = new File(SecurityConfig.getFilePath());
        try (FileInputStream inputStream = new FileInputStream(file);){
            Document doc = XmlUtils.parseDocument(inputStream, "utf-8");
            boolean bl = !Boolean.parseBoolean(XmlUtils.getChild(doc.getDocumentElement(), SECURITY_CONFIG_NODE).getTextContent());
            return bl;
        }
        catch (FileNotFoundException e) {
            log.error("file {} not found.", (Object)file.getName());
            return true;
        }
        catch (Exception e) {
            log.error("parse security config xml error.", (Throwable)e);
            return true;
        }
    }
}

