/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public class SerialSet<E>
extends AbstractSet<E>
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4253169229264721771L;
    private transient List<E> values = new ArrayList(0);
    private transient Map<E, Integer> valueToIndexMap = new HashMap<E, Integer>(0);

    public SerialSet() {
    }

    public SerialSet(Set<E> srcDatas) {
        this.values = new ArrayList<E>(srcDatas);
        int i = 0;
        for (E e : srcDatas) {
            this.valueToIndexMap.put(e, i);
            ++i;
        }
    }

    public SerialSet(List<E> srcDatas) {
        this.values = new ArrayList<E>(srcDatas);
        int i = 0;
        for (E e : srcDatas) {
            this.valueToIndexMap.put(e, i);
            ++i;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    public E get(int index) {
        return this.values.get(index);
    }

    public E set(int index, E element) {
        this.rangeCheck(index);
        int curIndex = this.indexOf(element);
        if (curIndex >= 0 && curIndex != index) {
            return null;
        }
        E oldValue = this.values.set(index, element);
        this.valueToIndexMap.remove(oldValue);
        this.valueToIndexMap.put(element, index);
        return oldValue;
    }

    public int indexOf(Object obj) {
        Integer index = this.valueToIndexMap.get(obj);
        if (null == index) {
            return -1;
        }
        return index;
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    public boolean add(E elemetn) {
        int index = this.indexOf(elemetn);
        if (index < 0) {
            this.values.add(elemetn);
            this.valueToIndexMap.put(elemetn, this.values.size() - 1);
        } else {
            this.set(index, elemetn);
        }
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        int index = this.indexOf(obj);
        if (index >= 0) {
            this.values.remove(index);
            this.valueToIndexMap.remove(obj);
            for (int i = index; i < this.values.size(); ++i) {
                this.valueToIndexMap.put(this.values.get(i), i);
            }
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] rawArray) {
        return this.values.toArray(rawArray);
    }

    public <T> List<T> toList(T[] a) {
        return new ArrayList<E>(this.values);
    }

    @Override
    public void clear() {
        this.values.clear();
        this.valueToIndexMap.clear();
    }

    @Override
    public String toString() {
        return this.values.toString();
    }

    private void rangeCheck(int index) {
        if (index >= this.size() || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    public SerialSet clone() throws CloneNotSupportedException {
        SerialSet instance = (SerialSet)super.clone();
        instance.values = new ArrayList<E>(this.values);
        instance.valueToIndexMap = new HashMap<E, Integer>(this.valueToIndexMap);
        return instance;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private class Iter
    implements Iterator<E> {
        private E currentValue;
        private Iterator<E> listIter;

        private Iter() {
            this.listIter = SerialSet.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.listIter.hasNext();
        }

        @Override
        public E next() {
            this.currentValue = this.listIter.next();
            return this.currentValue;
        }

        @Override
        public void remove() {
            int index = (Integer)SerialSet.this.valueToIndexMap.get(this.currentValue);
            this.listIter.remove();
            SerialSet.this.valueToIndexMap.remove(this.currentValue);
            for (int i = index; i < SerialSet.this.values.size(); ++i) {
                SerialSet.this.valueToIndexMap.put(SerialSet.this.values.get(i), i);
            }
        }
    }
}

