/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IPAddressField;
import com.huawei.ism.util.Assert;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public final class ValueMonitor
implements Serializable {
    public static final IValueParser<Object, Object> VP_SELF = new IValueParser<Object, Object>(){

        @Override
        public Object valueOf(Object source) {
            return source;
        }
    };
    public static final IValueParser<JTextComponent, String> VP_TEXT_COMPONENT = new IValueParser<JTextComponent, String>(){

        @Override
        public String valueOf(JTextComponent source) {
            return source.getText();
        }
    };
    public static final IValueParser<JToggleButton, Boolean> VP_TOGGLE_BUTTON = new IValueParser<JToggleButton, Boolean>(){

        @Override
        public Boolean valueOf(JToggleButton source) {
            return source.isSelected();
        }
    };
    public static final IValueParser<JComboBox, Integer> VP_COMBOBOX_SELECTED_INDEX = new IValueParser<JComboBox, Integer>(){

        @Override
        public Integer valueOf(JComboBox source) {
            return source.getSelectedIndex();
        }
    };
    public static final IValueParser<JList, List<Object>> VP_LIST_CONTENT = new IValueParser<JList, List<Object>>(){

        @Override
        public List<Object> valueOf(JList source) {
            ListModel model = source.getModel();
            ArrayList<Object> items = new ArrayList<Object>(0);
            for (int i = 0; i < model.getSize(); ++i) {
                items.add(model.getElementAt(i));
            }
            return items;
        }
    };
    public static final IValueParser<JTable, List<TableRow>> VP_TABLE_CONTENT = new IValueParser<JTable, List<TableRow>>(){

        @Override
        public List<TableRow> valueOf(JTable source) {
            TableModel tm = source.getModel();
            if (tm instanceof DefaultTableModel) {
                List<TableRow> tableRows = ((DefaultTableModel)tm).getAllRows();
                Collections.sort(tableRows, new TableRowComparator());
                return tableRows;
            }
            return new ArrayList<TableRow>(0);
        }
    };
    public static final IValueParser<JTable, List<TableRow>> VP_TABLE_SELECTION = new IValueParser<JTable, List<TableRow>>(){

        @Override
        public List<TableRow> valueOf(JTable source) {
            if (!(source instanceof IsmTable)) {
                return new ArrayList<TableRow>(0);
            }
            IsmTable ismTable = (IsmTable)source;
            ArrayList<TableRow> selectedTableRows = new ArrayList<TableRow>(ismTable.getMarkedRows());
            Collections.sort(selectedTableRows, new TableRowComparator());
            return selectedTableRows;
        }
    };
    public static final IValueParser<JSpinner, String> VP_SPINNER_CONTENT = new IValueParser<JSpinner, String>(){

        @Override
        public String valueOf(JSpinner source) {
            if (source.getValue() instanceof Date) {
                Date date = (Date)source.getValue();
                return date.toString();
            }
            return String.valueOf(source.getValue());
        }
    };
    public static final IValueParser<JTable, List<TableRow>> VP_TABLE_CONTENT_COMPOSITOR = new IValueParser<JTable, List<TableRow>>(){

        @Override
        public List<TableRow> valueOf(JTable source) {
            if (!(source instanceof IsmTable)) {
                return new ArrayList<TableRow>(0);
            }
            IsmTable ismTable = (IsmTable)source;
            ArrayList<TableRow> selectedTableRows = new ArrayList<TableRow>(ismTable.getAllRows());
            Collections.sort(selectedTableRows, new TableRowComparator());
            return selectedTableRows;
        }
    };
    public static final IValueParser<IPAddressField, String> VP_IPADDRESSFIELD_COMPOSITOR = new IValueParser<IPAddressField, String>(){

        @Override
        public String valueOf(IPAddressField source) {
            return source.getIPText();
        }
    };
    private static final long serialVersionUID = 1L;
    private Map<Object, List<IValueParser<Object, ?>>> parsers = new HashMap(0);
    private Map<Object, List<Object>> previousValues = new HashMap<Object, List<Object>>(0);

    public <S> void removeAllCheckpoints(S source) {
        if (null == source) {
            return;
        }
        this.previousValues.remove(source);
        this.parsers.remove(source);
    }

    public <S> void removeCheckpoint(S source) {
        if (null == source) {
            return;
        }
        this.previousValues.remove(source);
        this.parsers.remove(source);
    }

    public void removeAllCheckpoints() {
        this.previousValues.clear();
        this.parsers.clear();
    }

    public <S> void addCheckpoint(S source) {
        this.addCheckpoint(source, null);
    }

    public <S> void addCheckpoint(S ... sources) {
        Assert.notNullArray(sources);
        for (S source : sources) {
            this.addCheckpoint(source, null);
        }
    }

    public <S> void addCheckpoint(S source, IValueParser<? super S, ?> parser) {
        IValueParser<S, ?> validParser;
        if (null == source) {
            return;
        }
        IValueParser<S, ?> iValueParser = validParser = null == parser ? this.getDefaultParser(source) : parser;
        if (!this.parsers.containsKey(source)) {
            this.parsers.put(source, new ArrayList(0));
        }
        this.parsers.get(source).add(validParser);
        if (!this.previousValues.containsKey(source)) {
            this.previousValues.put(source, new ArrayList(0));
        }
        this.previousValues.get(source).add(validParser.valueOf(source));
    }

    public void flushValue() {
        List<Object> previousValue = null;
        for (Object source : this.previousValues.keySet()) {
            previousValue = this.previousValues.get(source);
            previousValue.clear();
            previousValue.addAll(this.getCurrentValue(source));
        }
    }

    public <S> void flushValue(S source) {
        List<Object> previousValue = this.previousValues.get(source);
        previousValue.clear();
        previousValue.addAll(this.getCurrentValue(source));
    }

    public boolean isValueChanged() {
        return this.isValueChanged(false);
    }

    public boolean isValueChanged(boolean isCheckDisableComp) {
        boolean isChenged = false;
        List<Object> previousValue = null;
        List<?> currentValue = null;
        for (Object key : this.previousValues.keySet()) {
            if (!isCheckDisableComp && key instanceof Component && !((Component)key).isEnabled() || (previousValue = this.previousValues.get(key)).equals(currentValue = this.getCurrentValue(key))) continue;
            isChenged = true;
            break;
        }
        return isChenged;
    }

    public List<Object> getChangedObject() {
        ArrayList<Object> ret = new ArrayList<Object>(0);
        List<?> currentValue = null;
        List<Object> previousValue = null;
        for (Object key : this.previousValues.keySet()) {
            if (key instanceof Component && !((Component)key).isEnabled() || (previousValue = this.previousValues.get(key)).equals(currentValue = this.getCurrentValue(key))) continue;
            ret.add(key);
        }
        return ret;
    }

    private <S> IValueParser<? super S, ?> getDefaultParser(S source) {
        IValueParser<Object, Object> valueParser = VP_SELF;
        if (source instanceof JTextComponent) {
            valueParser = VP_TEXT_COMPONENT;
        } else if (source instanceof JToggleButton) {
            valueParser = VP_TOGGLE_BUTTON;
        } else if (source instanceof JComboBox) {
            valueParser = VP_COMBOBOX_SELECTED_INDEX;
        } else if (source instanceof JList) {
            valueParser = VP_LIST_CONTENT;
        } else if (source instanceof JTable) {
            valueParser = VP_TABLE_CONTENT;
        } else if (source instanceof JSpinner) {
            valueParser = VP_SPINNER_CONTENT;
        } else if (source instanceof IPAddressField) {
            valueParser = VP_IPADDRESSFIELD_COMPOSITOR;
        }
        return valueParser;
    }

    private List<?> getCurrentValue(Object source) {
        ArrayList currentValue = new ArrayList(0);
        for (IValueParser<Object, ?> parser : this.parsers.get(source)) {
            currentValue.add(parser.valueOf(source));
        }
        return currentValue;
    }

    public static interface IValueParser<S, V>
    extends Serializable {
        public V valueOf(S var1);
    }

    private static final class TableRowComparator
    implements Comparator<TableRow>,
    Serializable {
        private static final long serialVersionUID = -3317285954447160795L;

        private TableRowComparator() {
        }

        @Override
        public int compare(TableRow o1, TableRow o2) {
            if (o1.hashCode() > o2.hashCode()) {
                return 1;
            }
            if (o1.hashCode() < o2.hashCode()) {
                return -1;
            }
            return 0;
        }
    }
}

