/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.psdk.common;

import java.util.Arrays;
import java.util.Optional;

public class ExecuteEnvConstants {

    public static enum ExecuteStep {
        DEFAULT("default"),
        UPG_PRE_CHECK("pre_check"),
        UPG_POST_CHECK("post_check"),
        EXP_EVAL_CHECK("eval_check"),
        EXP_PRE_CHECK("pre_check"),
        EXP_NEW_CHECK("new_cluster_check"),
        EXP_POST_CHECK("post_check"),
        FRU_PRE_CHECK("pre_check"),
        FRU_POST_CHECK("post_check");

        private final String name;

        private ExecuteStep(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ExecuteTool {
        UPGRADE_ARRAY("upgrade_array", "upgrade_array"),
        UPGRADE_EVALUATION("upgrade_eval", "upgrade_eval"),
        UPGRADE_DISK("upgrade_disk", "upgrade_disk"),
        EXPANSION_CTRL("exp_ctrl", "extend_ctrl"),
        EXPANSION_DISK("exp_disk", "extend_disk"),
        EXPANSION_DD("exp_dd", "extend_dd"),
        EXPANSION_LINK("exp_link", "extend_link"),
        EXPANSION_SCM("exp_scm", "extend_scm"),
        INSPECT_DAILY("inspect_daily", "inspect_daily"),
        INSPECT_BUREAU("inspect_bureau", "inspect_bureau");

        private final String name;
        private final String alias;

        private ExecuteTool(String name, String alias) {
            this.name = name;
            this.alias = alias;
        }

        public static Optional<ExecuteTool> findByAlias(String key) {
            return Arrays.stream(ExecuteTool.values()).filter(executeTool -> executeTool.alias.equalsIgnoreCase(key)).findFirst();
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ExecuteScene {
        UPGRADE("upgrade"),
        INSPECT("inspect"),
        EXPANSION("expansion"),
        FRU("fru"),
        CRU("cru");

        private final String name;

        private ExecuteScene(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

