/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.asymmetric;

import com.huawei.encryptbase.asymmetric.AsymmetricKeyAlgorithm;
import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.encryptbase.utils.InputParamValidator;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricKeyConverter {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricKeyConverter.class);
    private static final KeyFactory ECC_KEY_FACTORY;
    private static final KeyFactory RSA_KEY_FACTORY;

    public static PrivateKey convertToPrivateKey(String privateKey, AsymmetricKeyAlgorithm keyAlgorithm) {
        InputParamValidator.checkInputStr(privateKey);
        try {
            return AsymmetricKeyConverter.getKeyFactory(keyAlgorithm).generatePrivate(new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey)));
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Convert To PrivateKey error.", e);
        }
    }

    public static PublicKey convertToPublicKey(String publicKey, AsymmetricKeyAlgorithm keyAlgorithm) {
        InputParamValidator.checkInputStr(publicKey);
        try {
            return AsymmetricKeyConverter.getKeyFactory(keyAlgorithm).generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey)));
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Convert To PublicKey error.", e);
        }
    }

    private static KeyFactory getKeyFactory(AsymmetricKeyAlgorithm keyAlgorithm) {
        if (keyAlgorithm == AsymmetricKeyAlgorithm.EC) {
            return ECC_KEY_FACTORY;
        }
        if (keyAlgorithm == AsymmetricKeyAlgorithm.RSA) {
            return RSA_KEY_FACTORY;
        }
        throw new ProcessEncryptException("KeyFactory not exist for this keyAlgorithm: " + (Object)((Object)keyAlgorithm));
    }

    private AsymmetricKeyConverter() {
    }

    static {
        try {
            ECC_KEY_FACTORY = KeyFactory.getInstance(AsymmetricKeyAlgorithm.EC.getAlgorithm());
            RSA_KEY_FACTORY = KeyFactory.getInstance(AsymmetricKeyAlgorithm.RSA.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessEncryptException("init keyFactory error.", e);
        }
    }
}

