/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.asymmetric;

import com.huawei.encryptbase.asymmetric.AsymmetricKeyAlgorithm;
import com.huawei.encryptbase.asymmetric.AsymmetricKeyConverter;
import com.huawei.encryptbase.asymmetric.AsymmetricSignAlgorithm;
import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.encryptbase.utils.InputParamValidator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsymmetricSignTool {
    private static final Logger log = LoggerFactory.getLogger(AsymmetricSignTool.class);

    private AsymmetricSignTool() {
    }

    public static String getRsaSignature(byte[] content, PrivateKey privateKey) {
        return AsymmetricSignTool.getSignature(content, privateKey, AsymmetricSignAlgorithm.RSA.getAlgorithm());
    }

    public static String getRsaSignature(File content, PrivateKey privateKey) {
        return AsymmetricSignTool.getSignature(content, privateKey, AsymmetricSignAlgorithm.RSA.getAlgorithm());
    }

    public static String getRsaSignature(byte[] content, String privateKey) {
        return AsymmetricSignTool.getRsaSignature(content, AsymmetricKeyConverter.convertToPrivateKey(privateKey, AsymmetricKeyAlgorithm.RSA));
    }

    public static String getRsaSignature(File content, String privateKey) {
        return AsymmetricSignTool.getRsaSignature(content, AsymmetricKeyConverter.convertToPrivateKey(privateKey, AsymmetricKeyAlgorithm.RSA));
    }

    private static void checkSignInputParam(PrivateKey privateKey, String algorithm) {
        InputParamValidator.checkInputPrivateKey(privateKey);
        InputParamValidator.checkInputStr(algorithm);
    }

    private static String getSignature(Object content, PrivateKey privateKey, String algorithm) {
        AsymmetricSignTool.checkSignInputParam(privateKey, algorithm);
        InputParamValidator.checkInputObjectIsByteOrFile(content);
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            AsymmetricSignTool.updateSignData(content, signature);
            byte[] encodeByte = signature.sign();
            return Base64.encodeBase64String((byte[])encodeByte);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Process getSignature error.", e);
        }
    }

    private static void updateSignData(Object content, Signature signature) throws SignatureException, IOException {
        if (content instanceof byte[]) {
            signature.update((byte[])content);
            return;
        }
        try (FileInputStream inputStream = new FileInputStream((File)content);){
            int count;
            byte[] buffers = new byte[1024];
            while ((count = ((InputStream)inputStream).read(buffers)) != -1) {
                signature.update(buffers, 0, count);
            }
        }
    }

    public static boolean verifyRsaSignature(Object content, String signatureData, PublicKey publicKey) {
        return AsymmetricSignTool.verifySignature(content, signatureData, publicKey, AsymmetricSignAlgorithm.RSA.getAlgorithm());
    }

    public static boolean verifyRsaSignature(Object content, String signatureData, String publicKey) {
        return AsymmetricSignTool.verifyRsaSignature(content, signatureData, AsymmetricKeyConverter.convertToPublicKey(publicKey, AsymmetricKeyAlgorithm.RSA));
    }

    public static boolean verifySignature(Object content, String signatureData, PublicKey publicKey, String algorithm) {
        AsymmetricSignTool.checkVerifyInputParam(signatureData, publicKey, algorithm);
        InputParamValidator.checkInputObjectIsByteOrFile(content);
        try {
            byte[] encodeByte = Base64.decodeBase64((String)signatureData);
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            AsymmetricSignTool.updateSignData(content, signature);
            return signature.verify(encodeByte);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("Process verifySignature error.", e);
        }
    }

    private static void checkVerifyInputParam(String signatureData, PublicKey publicKey, String algorithm) {
        InputParamValidator.checkInputPublicKey(publicKey);
        InputParamValidator.checkInputStr(signatureData);
        InputParamValidator.checkInputStr(algorithm);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

