/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.symmetric;

import com.huawei.encryptbase.utils.ConvertUtils;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AesEncryptByCustomisedKeyTool {
    private static final Logger log = LoggerFactory.getLogger(AesEncryptByCustomisedKeyTool.class);
    private static final String SECRET_IV_SPLIT = ",";
    private static final int IV_LENGTH = 16;
    private static final int PADDING_LENGTH = 16;

    private AesEncryptByCustomisedKeyTool() {
    }

    public static byte[] encryptByte(byte[] content, String password) {
        return AesEncryptByCustomisedKeyTool.encryptByte(content, password.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] decryptByte(byte[] content, String password) {
        if (content == null || content.length == 0) {
            return new byte[0];
        }
        byte[] dayiv = new byte[16];
        byte[] tmpContent = new byte[content.length - dayiv.length];
        System.arraycopy(content, 0, tmpContent, 0, tmpContent.length);
        System.arraycopy(content, content.length - dayiv.length, dayiv, 0, dayiv.length);
        try {
            SecretKeySpec key = ConvertUtils.convertToSecretKey(password.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            cipher.init(2, (Key)key, new GCMParameterSpec(128, dayiv));
            return cipher.doFinal(tmpContent);
        }
        catch (Exception e) {
            log.error("decryptByte error.", (Throwable)e);
            return new byte[0];
        }
    }

    public static byte[] encryptByte(byte[] content, byte[] password) {
        if (content == null || content.length == 0) {
            return new byte[0];
        }
        int len = content.length;
        int maxLength = len % 16 == 0 ? len : (len / 16 + 1) * 16;
        byte[] tmpByte = new byte[maxLength];
        System.arraycopy(content, 0, tmpByte, 0, content.length);
        while (len < maxLength) {
            tmpByte[len] = 0;
            ++len;
        }
        try {
            return AesEncryptByCustomisedKeyTool.getNewBytes(password, tmpByte);
        }
        catch (Exception e) {
            log.error("encryptByte error.", (Throwable)e);
            return new byte[0];
        }
    }

    private static byte[] getNewBytes(byte[] password, byte[] tmpByte) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec key = ConvertUtils.convertToSecretKey(password);
        Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
        byte[] dayiv = new byte[16];
        SecureRandom.getInstanceStrong().nextBytes(dayiv);
        cipher.init(1, (Key)key, new GCMParameterSpec(128, dayiv));
        byte[] dofinalByte = cipher.doFinal(tmpByte);
        byte[] newBytes = new byte[dofinalByte.length + dayiv.length];
        System.arraycopy(dofinalByte, 0, newBytes, 0, dofinalByte.length);
        System.arraycopy(dayiv, 0, newBytes, dofinalByte.length, dayiv.length);
        return newBytes;
    }

    public static String encrypt(String content, String password) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        try {
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            int contentLength = contentBytes.length;
            int maxLength = contentLength % 16 == 0 ? contentLength : (contentLength / 16 + 1) * 16;
            StringBuilder sbr = new StringBuilder();
            for (int i = 0; i < maxLength - contentLength; ++i) {
                char cc = '\u0000';
                sbr.append(cc);
            }
            byte[] supplyBytes = sbr.toString().getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = ConvertUtils.convertToSecretKey(password.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            byte[] dayiv = new byte[16];
            SecureRandom.getInstanceStrong().nextBytes(dayiv);
            cipher.init(1, (Key)key, new GCMParameterSpec(128, dayiv));
            return ConvertUtils.asHex(cipher.doFinal(ArrayUtils.addAll((byte[])contentBytes, (byte[])supplyBytes))) + SECRET_IV_SPLIT + Arrays.toString(dayiv);
        }
        catch (Exception e) {
            log.error("encrypt error", (Throwable)e);
            return "";
        }
    }

    public static String decrypt(String content, String password) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        byte[] dayiv = new byte[16];
        String contentTmp = content;
        if (content.contains(SECRET_IV_SPLIT)) {
            dayiv = AesEncryptByCustomisedKeyTool.interceptIvParams(content);
            contentTmp = content.substring(0, content.indexOf(SECRET_IV_SPLIT));
        }
        try {
            SecretKeySpec key = ConvertUtils.convertToSecretKey(password.getBytes(StandardCharsets.UTF_8));
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            cipher.init(2, (Key)key, new GCMParameterSpec(128, dayiv));
            byte[] rsBytes = cipher.doFinal(ConvertUtils.asBin(contentTmp));
            ArrayList<Byte> contentList = new ArrayList<Byte>();
            for (byte rsByte : rsBytes) {
                if (rsByte == 0) continue;
                contentList.add(rsByte);
            }
            byte[] decrypt = new byte[contentList.size()];
            for (int i = 0; i < contentList.size(); ++i) {
                decrypt[i] = (Byte)contentList.get(i);
            }
            return new String(decrypt, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("decrypt error", (Throwable)e);
            return "";
        }
    }

    private static byte[] interceptIvParams(String content) {
        String ivParam = content.substring(content.indexOf(91) + 1, content.indexOf(93));
        String[] ivParams = ivParam.split(SECRET_IV_SPLIT);
        byte[] ret = new byte[ivParams.length];
        for (int i = 0; i < ivParams.length; ++i) {
            byte aByte;
            ret[i] = aByte = Byte.parseByte(ivParams[i].trim());
        }
        return ret;
    }
}

