/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.ExecuteResult;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.SupportVersion;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.RunType;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class OemDataContext
extends AbstractContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(OemDataContext.class);
    private static final OemDataContext INSTANCE = new OemDataContext();
    private static final String SHA_VERIFYFILE_EXTENDNAME = ".sign";
    private List<OemInfo> oemInfos = new ArrayList<OemInfo>();
    private Map<DevNode, List<ExecuteResult>> allDevResult = new HashMap<DevNode, List<ExecuteResult>>();
    private Map<DevNode, RunType> devExeState = new HashMap<DevNode, RunType>();
    private Map<String, String> failePackage = new HashMap<String, String>();
    private OemInfo curOem;
    private CmdType cmdType;
    private boolean isSupport = false;
    private List<String> optionName = new ArrayList<String>();
    private Map<String, List<String>> modelVersion;
    private Map<String, List<String>> modelOemTypes = new HashMap<String, List<String>>();

    public List<String> getOptionName() {
        return this.optionName;
    }

    public static OemDataContext getInstance() {
        return INSTANCE;
    }

    public List<OemInfo> getOemInfos() {
        return this.oemInfos;
    }

    public void setCurOem(OemInfo curOem) {
        this.curOem = curOem;
    }

    public OemInfo getCurOem() {
        return this.curOem;
    }

    public void setFailePackage(Map<String, String> failePackage) {
        this.failePackage = failePackage;
    }

    public Map<String, String> getFailePackage() {
        return this.failePackage;
    }

    public OemInfo loadOemInfo() {
        String pkgPath = this.getPkgPath();
        OemServiceImpl oemserviceImpl = new OemServiceImpl();
        return oemserviceImpl.loadPkg(new File(pkgPath));
    }

    private String getPkgPath() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        StringBuilder packPathSb = new StringBuilder().append(workPath).append(File.separator).append("packages").append(File.separator).append("products").append(File.separator);
        if (OemDataContext.getInstance().isUnifiedVer()) {
            packPathSb.append("unified").append(File.separator);
        } else if (OemDataContext.getInstance().isMassVer()) {
            packPathSb.append("mass").append(File.separator);
        }
        packPathSb.append(this.curOem.getPackName());
        return packPathSb.toString();
    }

    public Map<String, SupportVersion> getAllSupportVer() {
        HashMap<String, SupportVersion> allPackSupport = new HashMap<String, SupportVersion>();
        for (OemInfo curInfo : this.oemInfos) {
            List<SupportVersion> curSupports = curInfo.getSupportVers();
            for (SupportVersion product : curSupports) {
                this.addSupport(product, allPackSupport);
            }
        }
        return allPackSupport;
    }

    private void addSupport(SupportVersion product, Map<String, SupportVersion> allPackSupport) {
        String model = product.getModel();
        SupportVersion existVersion = allPackSupport.get(model);
        if (null != existVersion) {
            String curVersion;
            String existVerStr = existVersion.getVersion();
            if (!existVerStr.contains(curVersion = product.getVersion())) {
                String version = existVerStr + "," + curVersion;
                existVersion.setVersion(version);
            }
        } else {
            allPackSupport.put(model, product);
        }
    }

    public Map<String, SupportVersion> getSelectSupportVer(OemInfo selectOem) {
        HashMap<String, SupportVersion> allPackSupport = new HashMap<String, SupportVersion>();
        String oemVerson = selectOem.toString();
        for (OemInfo curInfo : this.oemInfos) {
            String curVerson = curInfo.toString();
            if (!curVerson.equals(oemVerson)) continue;
            List<SupportVersion> curSupports = curInfo.getSupportVers();
            for (SupportVersion product : curSupports) {
                String model = product.getModel();
                allPackSupport.put(model, product);
            }
        }
        return allPackSupport;
    }

    public List<DeviceType> getSupportTypes() {
        ArrayList<DeviceType> supports = new ArrayList<DeviceType>();
        List<OemInfo> allOemInfo = OemDataContext.getInstance().getOemInfos();
        for (OemInfo oemInfo : allOemInfo) {
            List<SupportVersion> products = oemInfo.getSupportVers();
            for (SupportVersion product : products) {
                String[] vers;
                String versionStr = product.getVersion();
                if (StringUtils.isNULLStr(versionStr) || (vers = versionStr.split(",")).length == 0) continue;
                this.checkSupportVersion(supports, vers);
            }
        }
        return supports;
    }

    private void checkSupportVersion(List<DeviceType> supports, String[] vers) {
        for (String ver : vers) {
            DeviceType deviceType = DeviceType.valueOf(ver.trim());
            if (supports.contains(deviceType)) continue;
            supports.add(deviceType);
        }
    }

    public boolean isSupportDev(DevNode node) {
        List<OemInfo> allOemInfo = OemDataContext.getInstance().getOemInfos();
        for (OemInfo oemInfo : allOemInfo) {
            List<SupportVersion> supportVersions = oemInfo.getSupportVers();
            for (SupportVersion supportVersion : supportVersions) {
                String[] vers;
                String versionStr = supportVersion.getVersion();
                String model = supportVersion.getModel();
                if (StringUtils.isNULLStr(versionStr) || (vers = versionStr.split(",")).length == 0 || !this.checkContainsCurDev(node, vers, model)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkContainsCurDev(DevNode node, String[] vers, String model) {
        String dev = (node.getDeviceType() + " " + node.getProductVersion()).trim();
        for (String ver : vers) {
            String curDev = (model + " " + ver).trim();
            if (!Products.contains(dev, curDev)) continue;
            return true;
        }
        return false;
    }

    public OemInfo getOemInfoByDev(String productVersion, DeviceType deviceType) {
        List<OemInfo> allOemInfo = OemDataContext.getInstance().getOemInfos();
        for (OemInfo oemInfo : allOemInfo) {
            List<SupportVersion> curSupportVers = oemInfo.getSupportVers();
            for (SupportVersion productVer : curSupportVers) {
                if (!this.checkSameOem(productVersion, deviceType, productVer)) continue;
                return oemInfo;
            }
        }
        return null;
    }

    private boolean checkSameOem(String productVersion, DeviceType deviceType, SupportVersion productVer) {
        String[] versionArr;
        String versions = productVer.getVersion();
        String model = productVer.getModel();
        for (String curVer : versionArr = versions.split(",")) {
            if (!OemDataContext.startsWith(productVersion, curVer = curVer.trim()) || !deviceType.equals(DeviceType.valueOf(model))) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(String productVersion, String curVer) {
        if (productVersion.contains("Kunpeng") && curVer.contains("Kunpeng")) {
            return productVersion.replace("Kunpeng", "").trim().startsWith(curVer.replace("Kunpeng", "").trim());
        }
        if (productVersion.contains("Kunpeng") && !curVer.contains("Kunpeng") || !productVersion.contains("Kunpeng") && curVer.contains("Kunpeng")) {
            return false;
        }
        return productVersion.trim().startsWith(curVer.trim());
    }

    public OemInfo getOemInfoByOemVer(String version) {
        for (OemInfo oemInfo : this.oemInfos) {
            if ((StringUtils.isNULLStr(oemInfo.getVersion()) || !oemInfo.getVersion().equals(version)) && !oemInfo.getPackName().equals(version)) continue;
            return oemInfo;
        }
        return null;
    }

    public OemInfo getOemInfoByVerClone(String version) {
        for (OemInfo oemInfo : this.oemInfos) {
            if (!oemInfo.getPackName().equals(version)) continue;
            try {
                return oemInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("getOemInfoByVerClone: clone failed", (Throwable)e);
            }
        }
        return null;
    }

    public Map<DevNode, List<ExecuteResult>> getAllDevResult() {
        return this.allDevResult;
    }

    public void addNewResult(DevNode devNode, String description) {
        List<ExecuteResult> curResults = this.allDevResult.get(devNode);
        if (null == curResults) {
            curResults = new ArrayList<ExecuteResult>();
        }
        ExecuteResult result = new ExecuteResult();
        result.setDescription(description);
        result.setDevNode(devNode);
        curResults.add(result);
        this.allDevResult.put(devNode, curResults);
    }

    public List<ExecuteResult> getDevExeResults(DevNode devNode) {
        return this.allDevResult.get(devNode);
    }

    public void setLastResult(DevNode devNode, boolean isScuess, String detail) {
        List<ExecuteResult> devAllResult = this.allDevResult.get(devNode);
        if (devAllResult == null || devAllResult.isEmpty()) {
            return;
        }
        ExecuteResult result = devAllResult.get(devAllResult.size() - 1);
        result.setResult(isScuess);
        if (!StringUtils.isNULLStr(detail)) {
            result.setDetail(detail);
        }
    }

    public void clearAllDevResult() {
        this.allDevResult.clear();
    }

    public void setDevRunState(DevNode devNode, RunType runType) {
        this.devExeState.put(devNode, runType);
    }

    public RunType getDevRunState(DevNode devNode) {
        return this.devExeState.get(devNode);
    }

    public void removeDevRunState(DevNode devNode) {
        this.devExeState.remove(devNode);
    }

    public ExecuteResult getDevLastResult(DevNode devNode) {
        ExecuteResult result = null;
        List<ExecuteResult> devExeResult = this.allDevResult.get(devNode);
        int no = 0;
        int size = devExeResult.size();
        if (size > no) {
            result = devExeResult.get(devExeResult.size() - 1);
        }
        return result;
    }

    public void clearDevExeResult(DevNode devNode) {
        if (null != this.allDevResult.get(devNode)) {
            this.allDevResult.remove(devNode);
        }
    }

    public boolean isExecutingOem() {
        return !this.getExecutingDevNode().isEmpty();
    }

    public List<DevNode> getExecutingDevNode() {
        return this.devExeState.keySet().stream().filter(curDevNode -> RunType.RUNING.equals((Object)this.devExeState.get(curDevNode))).collect(Collectors.toList());
    }

    public List<DevNode> getAllDevNode() {
        return DefaultNodeProviderImpl.getInstance().getNodeList();
    }

    public static String getFirstPk() {
        return "d11fbfdbed99d76714fbb49d5806ba37,";
    }

    public static boolean excuteVerify(File verifySrcFile) {
        try {
            return SHAAndRSAVerifyUtils.getInstance().excuteVerify(verifySrcFile);
        }
        catch (Exception e) {
            LOGGER.error("excuteVerify error: ", (Throwable)e);
            return false;
        }
    }

    public boolean checkFilepath(Window parent, String path) {
        String formatPath = path.replace("/", "\\");
        String actualPath = path;
        if (!new File(formatPath).isDirectory()) {
            int lastIndex;
            String fileName = formatPath.substring(formatPath.lastIndexOf("\\") + 1);
            int fristIndex = fileName.indexOf(".");
            if (fristIndex != (lastIndex = fileName.lastIndexOf("."))) {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"oem.tool.check.not.effective.filepath"));
                return false;
            }
            actualPath = actualPath.substring(0, actualPath.lastIndexOf("."));
        }
        if (StringUtils.hasMatchStr(actualPath = actualPath.replaceAll("\\\\", "").replaceAll("/", "").replaceAll(":", ""), "([^\\w\\s]+)|(\\s{2,})")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString((String)"oem.tool.check.not.effective.filepath"));
            return false;
        }
        return true;
    }

    public boolean isUnifiedVer() {
        String oemVer = System.getProperty("oemVer");
        return StringUtils.isNULLStr(oemVer) || "unified".equals(oemVer);
    }

    public boolean isMassVer() {
        String oemVer = System.getProperty("oemVer");
        return "mass".equals(oemVer);
    }

    public boolean isExitTool(Window window) {
        return this.confirmClose(ResourceUtil.getString((String)"oem.mass.wizard.exit"), window);
    }

    public boolean confirmClose(String tip, Window window) {
        return DialogUtils.showYesNoDialog((Window)window, (String)tip).getValue() == 0;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public boolean isSupport() {
        return this.isSupport;
    }

    public void setSupport(boolean issupport) {
        this.isSupport = issupport;
    }

    public Map<String, List<String>> getModelVersion() {
        if (this.modelVersion == null) {
            this.modelVersion = new HashMap<String, List<String>>();
            this.oemInfos.stream().forEach(this::initModelVersion);
        }
        return this.modelVersion;
    }

    private void initModelVersion(OemInfo oemInfo) {
        oemInfo.getSupportVers().forEach(this::initModelVersionMap);
    }

    private void initModelVersionMap(SupportVersion supportVersion) {
        String model = supportVersion.getModel();
        if (!this.modelVersion.containsKey(model)) {
            this.modelVersion.put(model, new ArrayList());
        }
        this.modelVersion.get(model).addAll(supportVersion.getShowVersion());
        Collections.sort(this.modelVersion.get(model));
    }

    public synchronized Map<String, List<String>> getModelOemType() {
        if (this.modelOemTypes.isEmpty()) {
            this.oemInfos.forEach(this::initModelOemType);
        }
        return this.modelOemTypes;
    }

    private void initModelOemType(OemInfo oemInfo) {
        oemInfo.getSupportVers().forEach(this::initModelOemTypeMap);
    }

    private void initModelOemTypeMap(SupportVersion supportVersion) {
        String model = supportVersion.getModel();
        if (!this.modelOemTypes.containsKey(model)) {
            this.modelOemTypes.put(model, new ArrayList());
        }
        if (this.modelOemTypes.get(model).contains("Default")) {
            return;
        }
        this.modelOemTypes.get(model).addAll(supportVersion.getOemTypes());
    }
}

