/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.service.VersionHanler;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public final class OemUIContext {
    public static final ImageIcon SUCCESS_IMAGE = ResourceUtil.getImage((String)"success.png");
    public static final ImageIcon TIPS_IMAGE = ResourceUtil.getImage((String)"tips.png");
    public static final ImageIcon FAILED_IMAGE = ResourceUtil.getImage((String)"failed.png");
    public static final ImageIcon PROCESSING_IMAGE = ResourceUtil.getImage((String)"loading.gif");
    private static final OemUIContext INSTANCE = new OemUIContext();
    private OemMainFrame mainFrame = null;
    private JDialog createInfoDialog = null;
    private VersionHanler verService = null;

    private OemUIContext() {
    }

    public static OemUIContext getInstance() {
        return INSTANCE;
    }

    public void setMainDialog(OemMainFrame frame) {
        this.mainFrame = frame;
        PROCESSING_IMAGE.setImageObserver((ImageObserver)((Object)this.mainFrame));
    }

    public OemMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setCreateInfoDialog(JDialog createInfoDialog) {
        this.createInfoDialog = createInfoDialog;
    }

    public JDialog getCreateInfoDialog() {
        return this.createInfoDialog;
    }

    public void setVerService(VersionHanler verService) {
        this.verService = verService;
    }

    public VersionHanler getVerService() {
        return this.verService;
    }

    public void uiCallBack(DevNode devNode) {
        if (null != this.mainFrame && null != devNode) {
            this.mainFrame.executCallback(devNode);
        }
    }

    public void callBackOemPath(String oemPath) {
        if (!StringUtils.isNULLStr(oemPath)) {
            this.mainFrame.refleshOemPath(oemPath);
        }
    }

    public void reSelectOem() {
        this.verService.refreshSelectOem();
    }
}

