/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.conf;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.conf.IOemInfoParser;
import com.huawei.ism.tool.oem.conf.ResourceParser;
import com.huawei.ism.tool.oem.entity.CliItem;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.FileType;
import com.huawei.ism.tool.oem.utils.ModeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComputeStorageOemInfoParser
implements IOemInfoParser {
    private static final Logger log = LoggerFactory.getLogger(ComputeStorageOemInfoParser.class);
    private static final String PATH = "path";
    private static final String CLI = "cli";
    private static final String FILENAME = "file";
    private static final String INFONAME = "info";
    private static final String OXM_ITEM = "item";
    private static final String OEMCONFIG = "oemConfig.xml";
    private static final String RESOURCE_PACK = "res";
    private static final String DEFAULT_FILE_FOLDER = "devfiles";
    private static final String RULE_START_QUTE = "RULE(";
    private static final String OEM_FCV = "oem_FCV";
    private static final String OEM_FC = "oem_FC";
    private static final String OEM_STORAGE = "oem_Storage";
    private static final long DEFAULT_TIME_OUT = TimeUnit.MINUTES.toMillis(20L);
    private final String packPath;
    private OemInfo oemInfo;
    private Element root = null;

    public ComputeStorageOemInfoParser(String packPath, OemInfo oemInfo) {
        this.packPath = packPath;
        this.oemInfo = oemInfo;
    }

    @Override
    public boolean parse() {
        String xmlPath = this.packPath + File.separator + OEMCONFIG;
        File config = new File(xmlPath);
        if (!config.exists()) {
            log.warn("The file {} does not exist.", (Object)config.getName());
            return false;
        }
        if (!OemDataContext.excuteVerify(config)) {
            this.saveErrMsg();
            return false;
        }
        try (FileInputStream input = new FileInputStream(config);){
            Document document = XmlUtils.parseDocument(input);
            this.root = document.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            log.error("can not find oemConfig xml {}.", (Object)config.getName());
            return false;
        }
        catch (IOException e) {
            log.error("Failed to read the file.", (Throwable)e);
            return false;
        }
        this.parseComputeStorageXml();
        return true;
    }

    private void saveErrMsg() {
        OemDataContext dataContext = OemDataContext.getInstance();
        Map<String, String> failedPackages = dataContext.getFailePackage();
        String errorMes = ResourceUtil.getString((String)"oem.tool.parse.signer.error.check");
        failedPackages.put(this.oemInfo.getPackName(), errorMes);
    }

    private void parseComputeStorageXml() {
        this.parseOemFcv();
        this.parseOemFc();
        this.parseOemStorage();
    }

    private void parseOemStorage() {
        Element storageNode = XmlUtils.getChild(this.root, OEM_STORAGE);
        if (storageNode == null) {
            return;
        }
        this.parsePath(storageNode, this.oemInfo);
        this.parseCli(storageNode);
        this.parseFile(storageNode, this.oemInfo);
    }

    private void parseOemFc() {
        Element fcNode = XmlUtils.getChild(this.root, OEM_FC);
        if (fcNode == null) {
            return;
        }
        OemInfo fcOemInfo = new OemInfo();
        this.parsePath(fcNode, fcOemInfo);
        this.parseFile(fcNode, fcOemInfo);
        this.oemInfo.setFcOemInfo(fcOemInfo);
    }

    private void parseOemFcv() {
        Element fcvNode = XmlUtils.getChild(this.root, OEM_FCV);
        if (fcvNode == null) {
            return;
        }
        OemInfo fcvOemInfo = new OemInfo();
        this.parsePath(fcvNode, fcvOemInfo);
        this.parseFile(fcvNode, fcvOemInfo);
        this.oemInfo.setFcvOemInfo(fcvOemInfo);
    }

    private void parsePath(Element root, OemInfo oemInfo) {
        Element pathNode = XmlUtils.getChild(root, PATH);
        if (pathNode == null) {
            return;
        }
        String path = pathNode.getAttribute(PATH);
        oemInfo.setDevPath(path);
    }

    private void parseCli(Element root) {
        Collection<Element> cliNodes = XmlUtils.getChildren(root, CLI);
        Map<CmdType, List<CliItem>> cliMap = this.oemInfo.getCliMap();
        for (Element cliNode : cliNodes) {
            CliItem item = new CliItem();
            item.setCmd(cliNode.getAttribute("cmd"));
            CmdType cmdType = CmdType.getCmdType(cliNode.getAttribute("type"));
            item.setCmdType(cmdType);
            item.setModeType(ModeType.getModeType(cliNode.getAttribute("model")));
            item.setTimeout(this.readTimeout(cliNode.getAttribute("timeout")));
            item.setSuccJudge(cliNode.getAttribute("succJudge"));
            item.setScript(this.getScriptPath(cliNode.getAttribute("script")));
            ResourceParser resource = this.oemInfo.getResourceBundle();
            item.setPreTip(resource.getString(cliNode.getAttribute("preTip")));
            item.setAfterTip(resource.getString(cliNode.getAttribute("afterTip")));
            item.setFailedMsg(resource.getString(cliNode.getAttribute("failedMsg")));
            if (ObjectUtils.allNotNull((Object[])new Object[]{cmdType, cliMap.get((Object)cmdType)})) {
                cliMap.get((Object)cmdType).add(item);
                continue;
            }
            if (!ObjectUtils.isNotEmpty((Object)((Object)cmdType))) continue;
            ArrayList<CliItem> list = new ArrayList<CliItem>();
            list.add(item);
            cliMap.put(cmdType, list);
        }
    }

    private void parseFile(Element root, OemInfo oemInfo) {
        List<FileItem> infoList = oemInfo.getInfoList();
        Collection<Element> fileNodes = XmlUtils.getChildren(root, FILENAME);
        for (Element fileNode : fileNodes) {
            FileItem item = new FileItem();
            String type = fileNode.getAttribute("type");
            item.setFileType(FileType.valueOf(type));
            item.setFileName(fileNode.getAttribute("name"));
            item.setFolder(fileNode.getAttribute("folder"));
            item.setItemId(fileNode.getAttribute("id"));
            if (FileType.TEXT.name().equals(type.toUpperCase(Locale.ENGLISH))) {
                this.parseFileText(fileNode, item);
            } else {
                ResourceParser resource = this.oemInfo.getResourceBundle();
                item.setDesc(resource.getString(fileNode.getAttribute("desc")));
                item.setTips(resource.getString(fileNode.getAttribute("tips")));
                item.setFilePath(this.getDevFileFolderPath(fileNode.getAttribute("default")));
                item.setVisible(this.readFileVisible(fileNode.getAttribute("visible")));
                item.setValidaty(fileNode.getAttribute("validaty"));
                item.setRequired(fileNode.getAttribute("required"));
                item.setRecheck(fileNode.getAttribute("recheck"));
            }
            infoList.add(item);
        }
    }

    private void handleSelectAttribute(Map<String, String> data, String source, ResourceParser resource) {
        String[] selectSet;
        boolean havePrint = false;
        if (source == null) {
            log.error("there is not correct format for select. null");
            return;
        }
        for (String attribute : selectSet = source.split("\\s+")) {
            String[] tempString = attribute.split(":");
            if (tempString.length != 2 && !havePrint) {
                log.error("there is not correct format for select. length is not ." + data);
                havePrint = true;
                continue;
            }
            data.put(resource.getString(tempString[0]), resource.getString(tempString[1]));
        }
    }

    private void parseFileText(Element node, FileItem item) {
        List<InfoItem> txtInfos = item.getTxtInfos();
        Collection<Element> textInfoNodes = XmlUtils.getChildren(node, INFONAME);
        for (Element textInfoNode : textInfoNodes) {
            InfoItem infoItem = new InfoItem();
            ResourceParser resource = this.oemInfo.getResourceBundle();
            String type = textInfoNode.getAttribute("type");
            if (Objects.equals((Object)FileType.getFileType(type), (Object)FileType.JSONTEXT)) {
                Collection<Element> oxmItemNodes = XmlUtils.getChildren(textInfoNode, OXM_ITEM);
                List<InfoItem> oxmItems = oxmItemNodes.stream().map(oxmItemNode -> this.parseOxmItem((Element)oxmItemNode, resource)).collect(Collectors.toList());
                infoItem.setOxmItems(oxmItems);
            }
            infoItem.setFileType(FileType.getFileType(type));
            infoItem.setTips(resource.getString(textInfoNode.getAttribute("tips")));
            infoItem.setKey(textInfoNode.getAttribute("key"));
            infoItem.setDesc(resource.getString(textInfoNode.getAttribute("desc")));
            infoItem.setDefValue(resource.getString(textInfoNode.getAttribute("default")));
            infoItem.setVisible(this.readVisible(textInfoNode.getAttribute("visible")));
            infoItem.setRequired(textInfoNode.getAttribute("required"));
            infoItem.setItemId(textInfoNode.getAttribute("id"));
            infoItem.setQuote(textInfoNode.getAttribute("quote"));
            infoItem.setRecheck(textInfoNode.getAttribute("recheck"));
            infoItem.setChecktext(this.readVisible(textInfoNode.getAttribute("checktext")));
            infoItem.setFcNode(this.readVisible(textInfoNode.getAttribute("fcnode")));
            if (Objects.equals((Object)FileType.getFileType(type), (Object)FileType.SELECT)) {
                this.handleSelectAttribute(infoItem.getSelectSet(), textInfoNode.getAttribute("select"), resource);
            }
            this.parseValidaty(infoItem, textInfoNode.getAttribute("validaty"));
            txtInfos.add(infoItem);
        }
    }

    private InfoItem parseOxmItem(Element oxmItemNode, ResourceParser resource) {
        InfoItem oxmItem = new InfoItem();
        oxmItem.setFileType(FileType.getFileType(oxmItemNode.getAttribute("type")));
        oxmItem.setTips(resource.getString(oxmItemNode.getAttribute("tips")));
        oxmItem.setKey(oxmItemNode.getAttribute("key"));
        oxmItem.setDesc(resource.getString(oxmItemNode.getAttribute("desc")));
        oxmItem.setDefValue(oxmItemNode.getAttribute("default"));
        oxmItem.setVisible(this.readVisible(oxmItemNode.getAttribute("visible")));
        oxmItem.setRequired(oxmItemNode.getAttribute("required"));
        oxmItem.setItemId(oxmItemNode.getAttribute("id"));
        oxmItem.setQuote(oxmItemNode.getAttribute("quote"));
        oxmItem.setRecheck(oxmItemNode.getAttribute("recheck"));
        this.parseValidaty(oxmItem, oxmItemNode.getAttribute("validaty"));
        return oxmItem;
    }

    private void parseValidaty(InfoItem infoItem, String validaty) {
        String regAndError = this.handleQuotefVal(validaty, RULE_START_QUTE, ")");
        if (StringUtils.isNULLStr(regAndError)) {
            return;
        }
        int lastSplit = regAndError.lastIndexOf(",");
        if (lastSplit == -1) {
            return;
        }
        String regStr = regAndError.substring(0, lastSplit).trim();
        String error = regAndError.substring(lastSplit + 1).trim();
        infoItem.setValidaty(this.handleQuotefVal(regStr, "'", "'"));
        ResourceParser resource = this.oemInfo.getResourceBundle();
        String errorInfo = resource.getString(this.handleQuotefVal(error, "'", "'"));
        infoItem.setRemind(errorInfo);
    }

    private String handleQuotefVal(String text, String startQuote, String endQuote) {
        if (StringUtils.isNULLStr(text) || !text.startsWith(startQuote) || !text.endsWith(endQuote)) {
            return "";
        }
        return text.substring(text.indexOf(startQuote) + startQuote.length(), text.lastIndexOf(endQuote));
    }

    private String getDevFileFolderPath(String defValue) {
        if (StringUtils.isNULLStr(defValue)) {
            return "";
        }
        return this.packPath + File.separator + RESOURCE_PACK + File.separator + DEFAULT_FILE_FOLDER + File.separator + defValue;
    }

    private String getScriptPath(String scriptName) {
        if (StringUtils.isNULLStr(scriptName)) {
            return "";
        }
        return this.packPath + File.separator + scriptName;
    }

    private int readTimeout(String timeout) {
        if (StringUtils.isNULLStr(timeout)) {
            return (int)DEFAULT_TIME_OUT;
        }
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            log.error("number format exception", (Throwable)e);
            return (int)DEFAULT_TIME_OUT;
        }
    }

    private boolean readVisible(String visible) {
        return Boolean.parseBoolean(visible);
    }

    private boolean readFileVisible(String visible) {
        if (StringUtils.isNULLStr(visible)) {
            return true;
        }
        return Boolean.parseBoolean(visible);
    }
}

