/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.conf;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.conf.IOemInfoParser;
import com.huawei.ism.tool.oem.conf.ResourceParser;
import com.huawei.ism.tool.oem.entity.CliItem;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.FileList;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.entity.IsmPackage;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.FileType;
import com.huawei.ism.tool.oem.utils.ModeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OemInfoParser
implements IOemInfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(OemInfoParser.class);
    public static final String NOT_SHOW_MARK = "%NOT_SHOW%";
    private static final String PATH = "path";
    private static final String ISM_INFO_NODE = "isminfo";
    private static final String OME_NINE_NODE = "oemnine";
    private static final String CLI = "cli";
    private static final String FILENAME = "file";
    private static final String INFONAME = "info";
    private static final String OXM_ITEM = "item";
    private static final String FILELISTNODE = "filelist";
    private static final String OEMCONFIG = "oemConfig.xml";
    private static final String RESOURCE_PACK = "res";
    private static final String DEFAULT_FILE_FOLDER = "devfiles";
    private static final String RULE_START_QUTE = "RULE(";
    private static final int DEFAULT_TIME_OUT = 1200000;
    private String packPath = null;
    private OemInfo oemInfo = null;
    private Element root = null;

    public OemInfoParser(String packPath, OemInfo oemInfo) {
        this.packPath = packPath;
        this.oemInfo = oemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean parse() {
        FileInputStream input;
        File config;
        block8: {
            String xmlPath = this.packPath + File.separator + OEMCONFIG;
            config = new File(xmlPath);
            if (!config.exists()) {
                LOGGER.warn("oemConfig config error!");
                return false;
            }
            input = null;
            if (OemDataContext.excuteVerify(config)) break block8;
            OemDataContext dataContext = OemDataContext.getInstance();
            Map<String, String> failedPackages = dataContext.getFailePackage();
            String errorMes = ResourceUtil.getString((String)"oem.tool.parse.signer.error.check");
            failedPackages.put(this.oemInfo.getPackName(), errorMes);
            boolean bl = false;
            StreamUtils.closeStream(null, input);
            return bl;
        }
        try {
            input = new FileInputStream(config);
            Document document = XmlUtils.parseDocument(input);
            this.root = document.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("can not find oemConfig xml {}.", (Object)config.getName());
            boolean bl = false;
            StreamUtils.closeStream(null, input);
            return bl;
        }
        catch (Exception e2) {
            LOGGER.error("can not find oemConfig xml.", (Throwable)e2);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, input);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, input);
            return bl;
        }
        StreamUtils.closeStream(null, input);
        this.parseExamine();
        this.parsePath();
        this.parseCli();
        this.parseFile();
        this.parseFileList();
        this.parseIsmInfo();
        this.parseOemNine();
        return true;
    }

    private void parseExamine() {
        String checkfilename = this.root.getAttribute("checkfilename");
        String algorithm = this.root.getAttribute("algorithm");
        if (!StringUtils.isNULLStr(checkfilename)) {
            this.oemInfo.setCheckfilename(checkfilename);
        }
        if (!StringUtils.isNULLStr(algorithm)) {
            this.oemInfo.setAlgorithm(algorithm);
        }
    }

    private void parsePath() {
        Element pathNode = XmlUtils.getChild(this.root, PATH);
        if (null == pathNode) {
            return;
        }
        String path = pathNode.getAttribute(PATH);
        this.oemInfo.setDevPath(path);
    }

    private void parseCli() {
        Collection<Element> cliNodes = XmlUtils.getChildren(this.root, CLI);
        Map<CmdType, List<CliItem>> cliMap = this.oemInfo.getCliMap();
        for (Element cliNode : cliNodes) {
            CliItem item = new CliItem();
            ResourceParser resource = this.oemInfo.getResourceBundle();
            String cmd = cliNode.getAttribute("cmd");
            String type = cliNode.getAttribute("type");
            String modeType = cliNode.getAttribute("model");
            String timeout = cliNode.getAttribute("timeout");
            String succJudge = cliNode.getAttribute("succJudge");
            String script = cliNode.getAttribute("script");
            String preTip = cliNode.getAttribute("preTip");
            String afterTip = cliNode.getAttribute("afterTip");
            String failedMsg = cliNode.getAttribute("failedMsg");
            CmdType cmdType = CmdType.getCmdType(type);
            item.setCmd(cmd);
            item.setCmdType(cmdType);
            item.setModeType(ModeType.getModeType(modeType));
            item.setTimeout(this.redaTimeout(timeout));
            item.setSuccJudge(succJudge);
            item.setScript(this.getScriptPath(script));
            item.setPreTip(resource.getString(preTip));
            item.setAfterTip(resource.getString(afterTip));
            item.setFailedMsg(resource.getString(failedMsg));
            if (null != cmdType && null != cliMap.get((Object)cmdType)) {
                cliMap.get((Object)cmdType).add(item);
                continue;
            }
            if (null == cmdType) continue;
            ArrayList<CliItem> list = new ArrayList<CliItem>();
            list.add(item);
            cliMap.put(cmdType, list);
        }
    }

    private void parseFile() {
        List<FileItem> infoList = this.oemInfo.getInfoList();
        Collection<Element> fileNodes = XmlUtils.getChildren(this.root, FILENAME);
        for (Element fileNode : fileNodes) {
            String type = fileNode.getAttribute("type");
            String name = fileNode.getAttribute("name");
            String folder = fileNode.getAttribute("folder");
            String itemId = fileNode.getAttribute("id");
            FileItem item = new FileItem();
            item.setFileType(FileType.valueOf(type));
            item.setFileName(name);
            item.setFolder(folder);
            item.setItemId(itemId);
            if (FileType.TEXT.name().equals(type.toUpperCase(Locale.ENGLISH))) {
                this.parseFileText(fileNode, item);
            } else {
                String desc = fileNode.getAttribute("desc");
                String tips = fileNode.getAttribute("tips");
                String validaty = fileNode.getAttribute("validaty");
                String defValue = fileNode.getAttribute("default");
                String visible = fileNode.getAttribute("visible");
                String required = fileNode.getAttribute("required");
                String recheck = fileNode.getAttribute("recheck");
                ResourceParser resource = this.oemInfo.getResourceBundle();
                item.setDesc(resource.getString(desc));
                item.setTips(resource.getString(tips));
                item.setFilePath(this.getDevFileFolderPath(defValue));
                item.setVisible(this.readFileVisible(visible));
                item.setValidaty(validaty);
                item.setRequired(required);
                item.setRecheck(recheck);
            }
            infoList.add(item);
        }
    }

    private void parseFileList() {
        List<FileList> allFileList = this.oemInfo.getAllFileList();
        Collection<Element> fileListNodes = XmlUtils.getChildren(this.root, FILELISTNODE);
        for (Element fileListNode : fileListNodes) {
            String type = fileListNode.getAttribute("type").toUpperCase(Locale.ENGLISH);
            String name = fileListNode.getAttribute("name");
            String folder = fileListNode.getAttribute("folder");
            FileList fileList = new FileList();
            fileList.setFileType(FileType.valueOf(type));
            fileList.setFileName(name);
            fileList.setFolder(folder);
            this.parseEmbeddeFile(fileListNode, fileList);
            allFileList.add(fileList);
        }
    }

    private void parseIsmInfo() {
        Element pathNode = XmlUtils.getChild(this.root, ISM_INFO_NODE);
        if (null == pathNode) {
            return;
        }
        IsmPackage ismPackage = new IsmPackage();
        String upPath = pathNode.getAttribute("up_path");
        String loadNotice = pathNode.getAttribute("load_notice");
        String loadDel = pathNode.getAttribute("load_del");
        ismPackage.setUpPath(upPath);
        ismPackage.setLoadNotice(loadNotice);
        ismPackage.setLoadDelNotice(loadDel);
        this.oemInfo.setIsmPackage(ismPackage);
    }

    private void parseOemNine() {
        Element pathNode = XmlUtils.getChild(this.root, OME_NINE_NODE);
        if (null == pathNode) {
            return;
        }
        OemMassCompress oemNineCompress = new OemMassCompress();
        String productVer = pathNode.getAttribute("product_version_path");
        String scriptName = pathNode.getAttribute("compress_script_name");
        String method = pathNode.getAttribute("compress_script_method");
        oemNineCompress.setProductVerPath(productVer);
        oemNineCompress.setScriptPath(this.getScriptPath(scriptName));
        if (!StringUtils.isNULLStr(method)) {
            oemNineCompress.setMethod(method);
        } else {
            oemNineCompress.setMethod("execute");
        }
        this.oemInfo.setOemNineCompress(oemNineCompress);
    }

    private void parseEmbeddeFile(Element rootNode, FileList fileList) {
        List<FileItem> childItemList = fileList.getChildItem();
        Collection<Element> fileNodes = XmlUtils.getChildren(rootNode, FILENAME);
        for (Element fileNode : fileNodes) {
            String type = fileNode.getAttribute("type").toUpperCase(Locale.ENGLISH);
            String name = fileNode.getAttribute("name");
            String folder = fileNode.getAttribute("folder");
            String itemId = fileNode.getAttribute("id");
            FileItem childitem = new FileItem();
            childitem.setFileType(FileType.valueOf(type));
            childitem.setFileName(name);
            childitem.setFolder(folder);
            childitem.setItemId(itemId);
            if (FileType.TEXT.name().equals(type.toUpperCase(Locale.ENGLISH))) {
                this.parseFileText(fileNode, childitem);
            } else {
                String desc = fileNode.getAttribute("desc");
                String tips = fileNode.getAttribute("tips");
                String validaty = fileNode.getAttribute("validaty");
                String defValue = fileNode.getAttribute("default");
                String visible = fileNode.getAttribute("visible");
                String required = fileNode.getAttribute("required");
                String recheck = fileNode.getAttribute("recheck");
                ResourceParser resource = this.oemInfo.getResourceBundle();
                childitem.setDesc(resource.getString(desc));
                childitem.setTips(resource.getString(tips));
                childitem.setFilePath(this.getDevFileFolderPath(defValue));
                childitem.setVisible(this.readFileVisible(visible));
                childitem.setValidaty(validaty);
                childitem.setRequired(required);
                childitem.setRecheck(recheck);
            }
            childItemList.add(childitem);
        }
    }

    private void handleSelectAttribute(Map<String, String> data, String source, ResourceParser resource) {
        String[] selectSet;
        boolean havePrint = false;
        if (source == null) {
            LOGGER.error("there is not correct format for select. null");
            return;
        }
        for (String s : selectSet = source.split("\\s+")) {
            String[] tempString = s.split(":");
            if (tempString.length != 2 && !havePrint) {
                LOGGER.error("there is not correct format for select. length is not . {}", data);
                havePrint = true;
                continue;
            }
            data.put(resource.getString(tempString[0]), resource.getString(tempString[1]));
        }
    }

    private void handleBindAttribute(Map<String, List<String>> data, String source, ResourceParser resource) {
        String[] bindSet;
        if (source == null) {
            return;
        }
        for (String s : bindSet = source.split("\\s+")) {
            String[] bindString = s.split(":");
            if (bindString.length != 2) {
                LOGGER.error("there is not correct format for bind.");
                continue;
            }
            String[] supportString = bindString[1].split(",");
            List supportList = Arrays.stream(supportString).map(resource::getString).collect(Collectors.toList());
            data.put(resource.getString(bindString[0]), supportList);
        }
    }

    private void parseFileText(Element node, FileItem item) {
        List<InfoItem> txtInfos = item.getTxtInfos();
        Collection<Element> textInfoNodes = XmlUtils.getChildren(node, INFONAME);
        for (Element textInfoNode : textInfoNodes) {
            String type = textInfoNode.getAttribute("type");
            String key = textInfoNode.getAttribute("key");
            String desc = textInfoNode.getAttribute("desc");
            String defValue = textInfoNode.getAttribute("default");
            String visible = textInfoNode.getAttribute("visible");
            String validaty = textInfoNode.getAttribute("validaty");
            String recheck = textInfoNode.getAttribute("recheck");
            String itemId = textInfoNode.getAttribute("id");
            String quote = textInfoNode.getAttribute("quote");
            String required = textInfoNode.getAttribute("required");
            String tipsKey = textInfoNode.getAttribute("tips");
            String checktext = textInfoNode.getAttribute("checktext");
            String bindKey = textInfoNode.getAttribute("bindKey");
            InfoItem infoItem = new InfoItem();
            ResourceParser resource = this.oemInfo.getResourceBundle();
            if (Objects.equals((Object)FileType.getFileType(type), (Object)FileType.JSONTEXT)) {
                ArrayList<InfoItem> oxmItems = new ArrayList<InfoItem>();
                Collection<Element> oxmItemNodes = XmlUtils.getChildren(textInfoNode, OXM_ITEM);
                oxmItemNodes.forEach(oxmItemNode -> this.parseOxmItem((Element)oxmItemNode, (List<InfoItem>)oxmItems, resource));
                infoItem.setOxmItems(oxmItems);
            }
            infoItem.setTips(resource.getString(tipsKey));
            infoItem.setBindKey(bindKey);
            infoItem.setFileType(FileType.getFileType(type));
            infoItem.setKey(key);
            infoItem.setDesc(resource.getString(desc));
            infoItem.setDefValue(resource.getString(defValue));
            infoItem.setVisible(this.readVisible(visible));
            infoItem.setRequired(required);
            infoItem.setItemId(itemId);
            infoItem.setQuote(quote);
            infoItem.setRecheck(recheck);
            infoItem.setChecktext(this.readVisible(checktext));
            if (Objects.equals((Object)FileType.getFileType(type), (Object)FileType.SELECT)) {
                this.handleSelectAttribute(infoItem.getSelectSet(), textInfoNode.getAttribute("select"), resource);
            }
            if (!Objects.equals(infoItem.getBindKey(), "")) {
                this.handleBindAttribute(infoItem.getBindMap(), textInfoNode.getAttribute("bindMap"), resource);
            }
            this.parseValidaty(infoItem, validaty);
            txtInfos.add(infoItem);
        }
    }

    private void parseOxmItem(Element oxmItemNode, List<InfoItem> oxmItems, ResourceParser resource) {
        String type = oxmItemNode.getAttribute("type");
        String key = oxmItemNode.getAttribute("key");
        String desc = oxmItemNode.getAttribute("desc");
        String defValue = oxmItemNode.getAttribute("default");
        String visible = oxmItemNode.getAttribute("visible");
        String validaty = oxmItemNode.getAttribute("validaty");
        String recheck = oxmItemNode.getAttribute("recheck");
        String itemId = oxmItemNode.getAttribute("id");
        String quote = oxmItemNode.getAttribute("quote");
        String required = oxmItemNode.getAttribute("required");
        String tipsKey = oxmItemNode.getAttribute("tips");
        InfoItem oxmItem = new InfoItem();
        oxmItem.setFileType(FileType.getFileType(type));
        oxmItem.setTips(resource.getString(tipsKey));
        oxmItem.setKey(key);
        oxmItem.setDesc(resource.getString(desc));
        oxmItem.setDefValue(defValue);
        oxmItem.setVisible(this.readVisible(visible));
        oxmItem.setRequired(required);
        oxmItem.setItemId(itemId);
        oxmItem.setQuote(quote);
        oxmItem.setRecheck(recheck);
        this.parseValidaty(oxmItem, validaty);
        oxmItems.add(oxmItem);
    }

    private void parseValidaty(InfoItem infoItem, String validaty) {
        String regAndError = this.handleQuotefVal(validaty, RULE_START_QUTE, ")");
        if (StringUtils.isNULLStr(regAndError)) {
            return;
        }
        int lastSplit = regAndError.lastIndexOf(",");
        if (lastSplit == -1) {
            return;
        }
        String regStr = regAndError.substring(0, lastSplit).trim();
        String error = regAndError.substring(lastSplit + 1).trim();
        infoItem.setValidaty(this.handleQuotefVal(regStr, "'", "'"));
        ResourceParser resource = this.oemInfo.getResourceBundle();
        String errorInfo = resource.getString(this.handleQuotefVal(error, "'", "'"));
        infoItem.setRemind(errorInfo);
    }

    private String handleQuotefVal(String text, String startQuote, String endQuote) {
        if (StringUtils.isNULLStr(text) || !text.startsWith(startQuote) || !text.endsWith(endQuote)) {
            return null;
        }
        return text.substring(text.indexOf(startQuote) + startQuote.length(), text.lastIndexOf(endQuote));
    }

    private String getDevFileFolderPath(String defValue) {
        if (StringUtils.isNULLStr(defValue)) {
            return "";
        }
        return this.packPath + File.separator + RESOURCE_PACK + File.separator + DEFAULT_FILE_FOLDER + File.separator + defValue;
    }

    private String getScriptPath(String scriptName) {
        if (StringUtils.isNULLStr(scriptName)) {
            return "";
        }
        return this.packPath + File.separator + scriptName;
    }

    private int redaTimeout(String timeout) {
        if (null == timeout || "".equals(timeout)) {
            return 1200000;
        }
        try {
            return Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            return 1200000;
        }
    }

    private boolean readVisible(String visible) {
        return Boolean.parseBoolean(visible);
    }

    private boolean readFileVisible(String visible) {
        if (StringUtils.isNULLStr(visible)) {
            return true;
        }
        return Boolean.parseBoolean(visible);
    }
}

