/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.conf;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceParser.class);
    private static final String RESOURCE_PACK = "res";
    private static final String RESOURCE_NAME = "resource";
    private static final String RESOURCE_FALL_NAME = "properties";
    private static final String FILE_SPLIT = ".";
    private static final String FILE_UNDERLINE = "_";
    private File packFile;
    private ResourceBundle bundle;

    public ResourceParser(File packFile) {
        this.packFile = packFile;
        this.readProperties();
    }

    public void readProperties() {
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        String currentLanguage = null == loc ? ApplicationContext.getInstance().getCurrentLanguage().getLanguage() : loc.getLanguage();
        String filePath = this.packFile + File.separator + RESOURCE_PACK + File.separator + RESOURCE_NAME + FILE_UNDERLINE + currentLanguage + FILE_SPLIT + RESOURCE_FALL_NAME;
        File propertiesFile = new File(filePath);
        try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]));){
            this.bundle = new PropertyResourceBundle(input);
        }
        catch (Exception e) {
            LOGGER.error("parse resource bundle error", (Throwable)e);
        }
    }

    public String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (Exception e) {
            return "";
        }
    }
}

