/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.conf;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.SupportVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SupportParser.class);
    private static final String NODE_PRODUCT = "product";
    private static final String NODE_PRODUCT_NAME = "productname";
    private static final String NODE_PRODUCT_TYPE = "supporttypes";
    private static final String NODE_OEM_TYPE = "oemtypes";
    private String path;
    private OemInfo oemInfo;
    private Element root;

    public SupportParser(String path, OemInfo oemInfo) {
        this.path = path;
        this.oemInfo = oemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseProduct() {
        File productFile = new File(this.path);
        if (!productFile.exists()) {
            String parentName = productFile.getParentFile().getName();
            LOGGER.info("package's name is {} does not contain data!", (Object)parentName);
            return false;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(productFile);
            Document document = XmlUtils.parseDocument(input);
            this.root = document.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("parse products xml {} error.", (Object)productFile.getName());
        }
        finally {
            StreamUtils.closeStream(null, input);
        }
        if (!this.checkStorage()) {
            return false;
        }
        this.parse();
        return true;
    }

    private boolean checkStorage() {
        String storage = this.root.getAttribute("storage");
        OemDataContext context = OemDataContext.getInstance();
        if (StringUtils.isNULLStr((String)storage) && context.isUnifiedVer()) {
            return true;
        }
        return "mass".equals(storage) && context.isMassVer();
    }

    private void parse() {
        String pakVersion = this.root.getAttribute("version");
        if (!StringUtils.isNULLStr((String)pakVersion)) {
            this.oemInfo.setVersion(pakVersion);
        }
        Collection<Element> products = XmlUtils.getChildren(this.root, NODE_PRODUCT);
        List<SupportVersion> supportVers = this.oemInfo.getSupportVers();
        String productVersion = ResourceUtil.getString((String)"oem.tool.info.button.desc2.default");
        for (Element product : products) {
            Element oemTypes;
            Element versionNode;
            SupportVersion curSupportVer = new SupportVersion();
            Element modelNode = XmlUtils.getChild(product, NODE_PRODUCT_NAME);
            if (modelNode != null) {
                curSupportVer.setModel(modelNode.getTextContent());
            }
            if ((versionNode = XmlUtils.getChild(product, NODE_PRODUCT_TYPE)) != null) {
                curSupportVer.setVersion(productVersion + "," + versionNode.getTextContent());
            }
            if ((oemTypes = XmlUtils.getChild(product, NODE_OEM_TYPE)) != null) {
                curSupportVer.setOemTypes("Default," + oemTypes.getTextContent());
            } else {
                curSupportVer.setOemTypes("Default");
            }
            supportVers.add(curSupportVer);
        }
    }
}

