/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.entity;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.service.impl.ComputeNodeSettingService;
import com.huawei.ism.tool.oem.utils.NodesUtil;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.tool.oem.utils.RunType;
import com.huawei.ism.tool.protocol.factory.ConnectorFactory;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.Utils;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class ComputeStorageUtils {
    private static final Logger log = LoggerFactory.getLogger(ComputeStorageUtils.class);
    public static final String UN_ZIP_TEMP = String.join((CharSequence)File.separator, ApplicationContext.getInstance().getWorkPath(), "temp", "importOem");
    private static final String FC = "fc";
    private static final String FCV = "fcv";
    private static final int UPLOAD_RETRY_TIMES = 3;
    private DevNode devnode;
    private OemInfo oemInfo;

    public ComputeStorageUtils(DevNode node, OemInfo oemInfo) {
        this.devnode = node;
        this.oemInfo = oemInfo;
    }

    public static boolean isOnlyOemStorageScene(List<DevNode> selectNodes, JFrame frame) {
        if (!ComputeStorageUtils.isOnlyOemStorageDev(selectNodes)) {
            log.info("Compute storage is not a oem storage node scenario.");
            return true;
        }
        return ComputeStorageUtils.isOnlyStoragePackage(frame);
    }

    private static boolean isOnlyOemStorageDev(List<DevNode> selectNodes) {
        return selectNodes.stream().allMatch(devNode -> ComputeStorageUtils.isOnlyStorageNode(ComputeNodeSettingService.getInstance().getOsmNodesByIp(devNode.getIp()), ComputeNodeSettingService.getInstance().getFcNodesByIp(devNode.getIp())));
    }

    private static boolean isOnlyStoragePackage(JFrame frame) {
        File sourFile = new File(OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP);
        Object[] allFiles = sourFile.listFiles();
        if (Utils.isNullArray((Object[])allFiles)) {
            log.error("The sourFile is null.");
            return false;
        }
        File file = new File(String.join((CharSequence)File.separator, OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP, "Storage_OEM.tgz"));
        if (allFiles.length == 1 && file.exists()) {
            return ComputeStorageUtils.isClickOk(ResourceUtil.getStringWithParams((String)"oem.tool.import.oem.package.onlyStorage", (Object[])new Object[0]), frame);
        }
        DialogUtils.showErrorDialog((Window)frame, (String)ResourceUtil.getStringWithParams((String)"oem.tool.import.oem.package.error", (Object[])new Object[0]));
        log.error("There are other files in the folder. {}", (Object)Arrays.toString(Arrays.stream(allFiles).map(File::getName).toArray()));
        return false;
    }

    public static boolean isOnlyStorageNode(List<MultiRouteNode> osmNodes, List<MultiRouteNode> fcNodes) {
        return osmNodes.isEmpty() && fcNodes.isEmpty();
    }

    public static boolean isClickOk(String promptInfo, Window frame) {
        WarningDialog warningDialog = DialogUtils.showYesNoDialog((Window)frame, (String)promptInfo);
        return warningDialog.getValue() == 0;
    }

    public static boolean isRightOemTgz(Frame parent, File curFile) {
        FileAssistant.clearDir(UN_ZIP_TEMP);
        try {
            FileAssistant.deCopmressAllZipFile(UN_ZIP_TEMP, curFile.getCanonicalPath());
        }
        catch (IOException e) {
            log.error("deCompress file failed!", (Throwable)e);
            return false;
        }
        File sourFile = new File(UN_ZIP_TEMP);
        Object[] allFiles = sourFile.listFiles();
        if (Utils.isNullArray((Object[])allFiles)) {
            log.error("The allFiles is null.");
            return false;
        }
        String fileName = ((File)allFiles[0]).getName().replace(".tar", ".tgz");
        if (fileName.equals(curFile.getName())) {
            return true;
        }
        DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getStringWithParams((String)"oem.tool.decompress.tgz.error", (Object[])new Object[]{fileName}));
        return false;
    }

    public boolean doUpLoadOemPackToNode(String nodeName, MultiRouteNode nodeInfo) {
        OemUIContext uiContext;
        OemDataContext dataContext;
        block7: {
            dataContext = OemDataContext.getInstance();
            uiContext = OemUIContext.getInstance();
            dataContext.addNewResult(this.devnode, ResourceUtil.getStringWithParams((String)"oem.tool.execute.import.upload.node", (Object[])new Object[]{nodeInfo.getHost()}));
            uiContext.uiCallBack(this.devnode);
            OemInfo nodeOemInfo = this.getNodeOemInfo(nodeName);
            try {
                for (int times = 0; times < 3; ++times) {
                    if (nodeName.equals(FCV) && this.doUpLoadOemPackToFcv(nodeInfo, dataContext, uiContext, nodeOemInfo)) {
                        return true;
                    }
                    if (nodeName.equals(FC) && this.doUpLoadOemPackToFc(nodeInfo, dataContext, uiContext, nodeOemInfo)) {
                        return true;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.error("Thread sleep error.", (Throwable)e);
                    }
                }
            }
            catch (ToolException e) {
                if (StringUtils.isNULLStr(e.getErrorId()) || "--".equals(ResourceUtil.getString((String)e.getErrorId()))) break block7;
                this.saveErrMsg(dataContext, uiContext, ResourceUtil.getString((String)e.getErrorId()));
                return false;
            }
        }
        this.saveErrMsg(dataContext, uiContext, ResourceUtil.getString((String)"oem.tool.execute.import.error"));
        return false;
    }

    private boolean doUpLoadOemPackToFc(MultiRouteNode nodeInfo, OemDataContext dataContext, OemUIContext uiContext, OemInfo nodeOemInfo) throws ToolException {
        DevNode dev = this.getNewDevNode(nodeInfo);
        try {
            SftpConnector sftpCon = ConnectorFactory.getInstance().createSftpConnector(dev, true);
            sftpCon.putFile(this.getLocalPath(FC), nodeOemInfo.getDevPath(), null);
            if (Products.compareVersion(dev.getProductVersion(), "6.1.6RC1") >= 0) {
                this.moveFcOemPackage(nodeInfo);
            }
            dataContext.setLastResult(this.devnode, true, "");
            uiContext.uiCallBack(this.devnode);
            return true;
        }
        catch (ToolException e) {
            log.error("The SSH connection operation of [{}] is abnormal.", (Object)dev.getIp(), (Object)e);
            throw e;
        }
        catch (IsmException e) {
            log.error("{} put file failed.", (Object)dev.getIp(), (Object)e);
        }
        catch (Exception e) {
            log.error("do upload oem package to fc nodes failed.", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFcOemPackage(MultiRouteNode nodeInfo) throws ToolException {
        log.info("start move fc Oem package");
        String sha256Value = SHA256Check.getInstance().getHash(this.getLocalPath(FC));
        DevNode deviceNode = NodesUtil.createDeviceNode(nodeInfo);
        ICliConnection sshConnection = null;
        try {
            sshConnection = SshConnectionManager.getSshConnection(deviceNode);
            sshConnection.execCmd(String.join((CharSequence)" ", "mv", "/home/GalaX8800/FC_OEM.zip", "/home/FC_OEM_Temp.zip"));
            String sha256Result = sshConnection.execCmd(String.join((CharSequence)" ", "sha256sum", "/home/FC_OEM_Temp.zip"));
            if (!sha256Result.toLowerCase(Locale.ROOT).contains(sha256Value.toLowerCase(Locale.ROOT))) {
                sshConnection.execCmd(String.join((CharSequence)" ", "rm -f", "/home/FC_OEM_Temp.zip"));
                log.error("{} FC oem package integrity check failed.", (Object)nodeInfo.getHost());
                throw new ToolException("oem.package.integrity.check.error");
            }
            sshConnection.execCmd(String.join((CharSequence)" ", "mv", "/home/FC_OEM_Temp.zip", "/home/FC_OEM.zip"));
        }
        finally {
            SshConnectionManager.releaseConnection(deviceNode);
        }
        log.info("move fc Oem package finish");
    }

    private boolean doUpLoadOemPackToFcv(MultiRouteNode nodeInfo, OemDataContext dataContext, OemUIContext uiContext, OemInfo nodeOemInfo) {
        try {
            SftpConnector sftpCon = ConnectorFactory.getInstance().createSftpConnector(this.getNewDevNode(nodeInfo), true);
            sftpCon.putFile(this.getLocalPath(FCV), nodeOemInfo.getDevPath(), null);
            dataContext.setLastResult(this.devnode, true, "");
            uiContext.uiCallBack(this.devnode);
            return true;
        }
        catch (IsmException e) {
            log.error("{} put file failed.", (Object)nodeInfo.getHost(), (Object)e);
        }
        catch (Exception e) {
            log.error("do upload oem package to fcv nodes failed.", (Throwable)e);
        }
        return false;
    }

    private String getLocalPath(String nodeName) {
        String fileName = nodeName.equals(FC) ? "FC_OEM.zip" : "FCV_OEM.tgz";
        return String.join((CharSequence)File.separator, OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP, fileName);
    }

    private DevNode getNewDevNode(MultiRouteNode nodeInfo) {
        DevNode newDev = new DevNode();
        try {
            newDev = (DevNode)this.devnode.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("clone devNode failed.", (Throwable)e);
        }
        newDev.setIp(nodeInfo.getHost());
        newDev.setLoginUser(new User(nodeInfo.getUname(), nodeInfo.getPwd()));
        return newDev;
    }

    private OemInfo getNodeOemInfo(String nodeName) {
        return nodeName.equals(FC) ? this.oemInfo.getFcOemInfo() : this.oemInfo.getFcvOemInfo();
    }

    private void saveErrMsg(OemDataContext dataContext, OemUIContext uiContext, String errorMessage) {
        dataContext.setLastResult(this.devnode, false, errorMessage);
        dataContext.setDevRunState(this.devnode, RunType.FAILED);
        uiContext.uiCallBack(this.devnode);
    }

    public static boolean checkDirAndCompressOemPackage() {
        FileAssistant.clearDir(OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP);
        File sourFile = new File(UN_ZIP_TEMP);
        File[] allFiles = sourFile.listFiles();
        if (allFiles == null) {
            return false;
        }
        boolean isComputeStorageOemPackage = ComputeStorageUtils.isComputeStorageOemPackage(allFiles);
        if (isComputeStorageOemPackage) {
            FileUtils.copyDir((String)UN_ZIP_TEMP, (String)OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP);
        }
        return ComputeStorageUtils.isNotTgz(allFiles) || isComputeStorageOemPackage && ComputeStorageUtils.decompressFiles(allFiles);
    }

    private static boolean isComputeStorageOemPackage(File[] allFiles) {
        return Arrays.stream(allFiles).allMatch(file -> OemConstants.COMPUTE_STORAGE_OEM_PACKAGE_NAMES.contains(file.getName()));
    }

    private static boolean decompressFiles(File[] allFiles) {
        for (File file : allFiles) {
            try {
                if (file.getName().equals("FC_OEM.zip")) {
                    FileAssistant.deCopmressTotalZipFile(UN_ZIP_TEMP + File.separator + "FC_OEM", file.getCanonicalPath());
                    continue;
                }
                if (FileAssistant.deCompressTgz(UN_ZIP_TEMP + File.separator + ComputeStorageUtils.getFileName(file), file.getCanonicalPath())) continue;
                return false;
            }
            catch (IOException e) {
                log.error("file get canonical path failed.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static String getFileName(File file) throws IOException {
        return file.getName().split("\\.")[0];
    }

    private static boolean isNotTgz(File[] allFiles) {
        return Arrays.stream(allFiles).noneMatch(ComputeStorageUtils::isContainsTgz);
    }

    private static boolean isContainsTgz(File file) {
        try {
            return file.getCanonicalPath().contains("tgz");
        }
        catch (IOException e) {
            log.error("get canonical path failed. ", (Throwable)e);
            return false;
        }
    }

    public static void decompressComputeStorageOemPackage(String curFilePath) {
        if (!curFilePath.endsWith(".tgz")) {
            return;
        }
        FileAssistant.clearDir(UN_ZIP_TEMP);
        if (!FileAssistant.deCompressTgz(UN_ZIP_TEMP, curFilePath)) {
            log.warn("decompress Oem package failed!");
        }
    }
}

