/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.entity;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SupportVersion {
    private static final String VERSION_SPLIT = ",";
    private static final String SHOW_VERSION_SPLIT = ":";
    private static final String LATER_DESC = ResourceUtil.getString((String)"oem.version.orlater");
    private static final String VERSION_DEFAULT = ResourceUtil.getString((String)"oem.tool.info.button.desc2.default");
    private static final String LATER_KEY = "+";
    private String model;
    private String version;
    private String oemTypes;

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List<String> getSupportLogicVersion() {
        return Arrays.stream(this.version.split(VERSION_SPLIT)).map(versionConf -> this.splitAndGetTarget((String)versionConf, SHOW_VERSION_SPLIT, 0)).collect(Collectors.toList());
    }

    public List<String> getShowVersion() {
        return Arrays.stream(this.version.split(VERSION_SPLIT)).map(versionConf -> this.splitAndGetTarget((String)versionConf, SHOW_VERSION_SPLIT, 1)).map(this::getShowVerRes).collect(Collectors.toList());
    }

    public List<String> getOemTypes() {
        return Arrays.asList(this.oemTypes.split(VERSION_SPLIT));
    }

    private String getShowVerRes(String showVer) {
        if (showVer.endsWith(LATER_KEY)) {
            return showVer.replace(LATER_KEY, LATER_DESC);
        }
        return showVer;
    }

    private String splitAndGetTarget(String src, String regex, int index) {
        String[] arr = src.split(regex);
        if (arr.length > index) {
            return arr[index];
        }
        return src;
    }

    public String getVerIndexKey(String ver) {
        return this.model + "-" + ver;
    }

    public String getVersion() {
        return String.join((CharSequence)VERSION_SPLIT, this.getSupportLogicVersion());
    }

    public String getSupportShowVersion() {
        return this.getSupportLogicVersion().stream().filter(version -> !VERSION_DEFAULT.equals(version)).collect(Collectors.joining(VERSION_SPLIT));
    }

    public void setOemTypes(String oemTypes) {
        this.oemTypes = oemTypes;
    }
}

