/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.ComputeStorageUtils;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.tool.oem.utils.OemConstants;
import java.io.File;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOemCallable
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateOemCallable.class);
    private static final String WORK_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String TEMP_PATH = WORK_PATH + File.separator + "temp" + File.separator + "oem";
    private String path;

    public CreateOemCallable(String path) {
        this.path = path;
    }

    @Override
    public Boolean call() {
        try {
            OemServiceImpl oemserviceImpl = new OemServiceImpl();
            OemInfo oemInfo = OemDataContext.getInstance().getCurOem();
            if (!oemserviceImpl.createOem(oemInfo, TEMP_PATH)) {
                return Boolean.FALSE;
            }
            this.copyFile();
            File sourFile = new File(TEMP_PATH);
            File[] allFiles = sourFile.listFiles();
            if (null == allFiles) {
                return Boolean.FALSE;
            }
            String[] fileNames = new String[allFiles.length];
            for (int i = 0; i < allFiles.length; ++i) {
                fileNames[i] = allFiles[i].getCanonicalPath();
            }
            if (!FileAssistant.compressTgzFile(this.path, fileNames)) {
                FileUtils.deleteFile((File)sourFile);
                return Boolean.FALSE;
            }
            FileUtils.deleteFile((File)sourFile);
            FileUtils.setFilePermissions((String)this.path);
            if (OemConstants.isOemComputeStorageScene(oemInfo)) {
                ComputeStorageUtils.decompressComputeStorageOemPackage(this.path);
            }
        }
        catch (Exception e) {
            LOGGER.error("create oem.zip failed!", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void copyFile() {
        if (!OemConstants.isOemComputeStorageScene(OemDataContext.getInstance().getCurOem())) {
            return;
        }
        FileAssistant.clearDir(OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP);
        FileUtils.copyDir((String)TEMP_PATH, (String)OemConstants.COMPUTE_STORAGE_NODE_TGZ_TEMP);
    }
}

