/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;

public class OemNineProductCallable
implements Callable<List<Object>> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(OemNineProductCallable.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> call() {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.getCurOem();
        OemMassCompress compress = oemInfo.getOemNineCompress();
        File scriptFile = new File(compress.getScriptPath());
        JythonExecuter executor = null;
        try {
            StringBuilder commonPath = new StringBuilder().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("packages").append(File.separator).append("products").append(File.separator).append("common");
            executor = new JythonExecuter(Arrays.asList(new File(commonPath.toString()), scriptFile.getParentFile()));
            executor.compileScript(scriptFile);
            List list = executor.invokeFunction(compress.getMethod(), this.handleParams());
            return list;
        }
        catch (SignException e) {
            LOGGER.error("scriptPath sign error", (Throwable)e);
            List<Object> list = null;
            return list;
        }
        catch (ToolException e) {
            LOGGER.error("invoke function error", (Throwable)e);
            List<Object> list = null;
            return list;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("scriptPath is not exists");
            List<Object> list = null;
            return list;
        }
        catch (Exception e) {
            LOGGER.error("other unknown error", (Throwable)e);
            List<Object> list = null;
            return list;
        }
        finally {
            if (null != executor) {
                executor.cleanup();
            }
        }
    }

    private Map<String, Object> handleParams() {
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        String currentLanguage = null == loc ? ApplicationContext.getInstance().getCurrentLanguage().getLanguage() : loc.getLanguage();
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.getCurOem();
        OemMassCompress compress = oemInfo.getOemNineCompress();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("oemPath", compress.getOemPath());
        params.put("verPath", compress.getProductVerPath());
        params.put("createPath", compress.getFinalPath());
        params.put("originalPkgPath", compress.getOriginalPkgPath());
        params.put("lan", currentLanguage);
        params.put("logger", LOGGER);
        return params;
    }
}

