/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.ComputeStorageUtils;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.service.VersionHanler;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.tool.oem.ui.layout.CreateOemInfoLayout;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseOemCallable
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseOemCallable.class);
    private static final String WORK_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String UN_ZIP_TEMP = WORK_PATH + File.separator + "temp" + File.separator + "importOem";
    private static final String OEM_MARK_FILE_NAME = "tool.ini";
    private static final long FILE_MAX_SIZE = 0x1400000L;
    private File zipFilePath;
    private CreateOemInfoLayout layout;
    private VersionHanler verService;
    private boolean isconfigOemUI;

    public ParseOemCallable(File zipFilePath, CreateOemInfoLayout layout, VersionHanler verService, boolean isconfigOemUI) {
        this.zipFilePath = zipFilePath;
        this.layout = layout;
        this.verService = verService;
        this.isconfigOemUI = isconfigOemUI;
    }

    @Override
    public Integer call() {
        try {
            OemServiceImpl service;
            OemUIContext uiContext = OemUIContext.getInstance();
            uiContext.setCreateInfoDialog(this.layout.getTipDialog());
            uiContext.setVerService(this.verService);
            File oemFile = new File(UN_ZIP_TEMP);
            if (!this.checkImport(oemFile, this.zipFilePath)) {
                return OemServiceImpl.DE_COMPRESS_ERROR;
            }
            OemDataContext dataContext = OemDataContext.getInstance();
            String result = this.getFileMessage(OEM_MARK_FILE_NAME, "");
            if (StringUtils.isNULLStr(result)) {
                result = this.getFileMessage(OEM_MARK_FILE_NAME, "Storage_OEM");
            }
            if (!this.isconfigOemUI) {
                String version = result.substring(result.indexOf("=") + 1).trim();
                if (StringUtils.isNULLStr(version)) {
                    LOGGER.info("oem's tool.ini lack version message");
                    return OemServiceImpl.VERSION_ERROR;
                }
                OemInfo oemInfo = dataContext.getOemInfoByVerClone(version);
                if (null == oemInfo) {
                    LOGGER.info("can't find oem info");
                    return OemServiceImpl.VERSION_ERROR;
                }
                if (oemInfo.getOemNineCompress() != null) {
                    OemMassCompress curMassOemConfig = dataContext.getCurOem().getOemNineCompress();
                    String productPath = curMassOemConfig.getProductVerPath();
                    String oemPath = curMassOemConfig.getOemPath();
                    String originalPath = curMassOemConfig.getOriginalPkgPath();
                    String finalPath = curMassOemConfig.getFinalPath();
                    oemInfo.getOemNineCompress().setProductVerPath(productPath);
                    oemInfo.getOemNineCompress().setOemPath(oemPath);
                    oemInfo.getOemNineCompress().setOriginalPkgPath(originalPath);
                    oemInfo.getOemNineCompress().setFinalPath(finalPath);
                }
                dataContext.setCurOem(oemInfo);
            }
            if ((service = new OemServiceImpl()).importOemPack(this.zipFilePath)) {
                this.layout.importAndRefresh();
            }
        }
        catch (Exception e) {
            LOGGER.error("import oem package failed", (Throwable)e);
            return OemServiceImpl.PARSE_OEM_FAILED;
        }
        return OemServiceImpl.PARSE_OEM_SUCCESS;
    }

    private boolean checkImport(File oemFile, File sourcePath) {
        if (!FileUtils.fileSizeInvalid((File)sourcePath, (long)0x1400000L)) {
            LOGGER.info("the file size is over 20MB.{}", (Object)sourcePath);
            return false;
        }
        if (oemFile.exists()) {
            FileUtils.deleteFile((File)oemFile);
        }
        FileUtils.createDir((File)oemFile);
        if (!oemFile.exists()) {
            LOGGER.info("create {} failed!", (Object)oemFile);
            return false;
        }
        try {
            if (!FileAssistant.deCompressTgz(UN_ZIP_TEMP, sourcePath.getCanonicalPath())) {
                LOGGER.info("deCompress tgz file failed!");
                return false;
            }
            if (!ComputeStorageUtils.checkDirAndCompressOemPackage()) {
                LOGGER.info("Failed to decompress the OEM package on computing storage nodes.");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getFileMessage(String pathAndName, String packageName) {
        String fileMessage = null;
        File readFile = StringUtils.isNULLStr(packageName) ? new File(UN_ZIP_TEMP + File.separator + pathAndName) : new File(UN_ZIP_TEMP + File.separator + packageName + File.separator + pathAndName);
        try {
            fileMessage = StreamUtils.readStringFormFile((File)readFile);
        }
        catch (Exception e) {
            LOGGER.error("readTextFile read error!", (Throwable)e);
        }
        return fileMessage;
    }
}

