/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.checker;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.service.CheckerService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JDialog;

public class ImageChecker
implements CheckerService {
    private static final String QUOTATION_MARKS = "\"";
    private FileItem fileItem;
    private JDialog parent;

    public ImageChecker(FileItem fileItem, JDialog parent) {
        this.fileItem = fileItem;
        this.parent = parent;
    }

    @Override
    public boolean checkData() {
        String validaty = this.fileItem.getValidaty();
        String labelName = this.fileItem.getDesc();
        String required = this.fileItem.getRequired();
        if (StringUtils.isNULLStr((String)validaty)) {
            return true;
        }
        String path = this.fileItem.getFilePath();
        String fileName = this.fileItem.getFileName();
        if (!(StringUtils.isNULLStr((String)path) || this.checkType(fileName, path, labelName) && this.checkSize(path, labelName))) {
            return false;
        }
        if (StringUtils.isNULLStr((String)path) && (StringUtils.isNULLStr((String)required) || Boolean.parseBoolean(required))) {
            String tip = MessageFormat.format(ResourceUtil.getString((String)"oem.tool.info.image.empty.remind"), QUOTATION_MARKS + labelName + QUOTATION_MARKS);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)tip);
            return false;
        }
        return true;
    }

    private boolean checkType(String fileName, String path, String labelName) {
        String imageType = fileName.substring(fileName.lastIndexOf("."));
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(imageType.toLowerCase(Locale.ENGLISH))) {
            String tip = MessageFormat.format(ResourceUtil.getString((String)"oem.tool.info.image.type.remind"), QUOTATION_MARKS + labelName + QUOTATION_MARKS);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)tip);
            return false;
        }
        return true;
    }

    private boolean checkSize(String path, String labelName) {
        ImageIcon image = new ImageIcon(path);
        image.getImage().flush();
        image = new ImageIcon(path);
        OemImageSize checkSize = this.getCheckSize();
        if (image.getIconWidth() > checkSize.getWidth() || image.getIconHeight() > checkSize.getHeight()) {
            String tip = MessageFormat.format(ResourceUtil.getString((String)"oem.tool.info.image.size.remind"), QUOTATION_MARKS + labelName + QUOTATION_MARKS, checkSize.toString());
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)tip);
            return false;
        }
        return true;
    }

    private OemImageSize getCheckSize() {
        OemImageSize configSize = new OemImageSize();
        try {
            String validaty = this.fileItem.getValidaty().toLowerCase(Locale.ENGLISH);
            String sizeStr = validaty.replace("(", "").replace(")", "").replace("size", "");
            String[] sizeArray = sizeStr.split(",");
            int checkWidth = Integer.parseInt(sizeArray[0]);
            int checkHeight = Integer.parseInt(sizeArray[1]);
            configSize.setWidth(checkWidth);
            configSize.setHeight(checkHeight);
            return configSize;
        }
        catch (Exception e) {
            configSize.setWidth(0);
            configSize.setHeight(0);
            return configSize;
        }
    }

    static class OemImageSize {
        private int width;
        private int height;

        OemImageSize() {
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String toString() {
            return this.width + " * " + this.height;
        }
    }
}

