/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.checker;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.interf.IRecheck;
import com.huawei.ism.tool.oem.service.CheckerService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextChecker
implements CheckerService {
    private static final Logger log = LoggerFactory.getLogger(TextChecker.class);
    private static final Pattern CHINESE_RULE = Pattern.compile("[\\u4e00-\\u9fa5\\u3002\\uff1f\\uff01\\uff0c\\u3001\\uff1b\\uff1a\\u201c\\u201d\\u2018\\u2019\\uff08\\uff09\\u300a\\u300b\\u3008\\u3009\\u3010\\u3011\\u300e\\u300f\\u300c\\u300d\\ufe43\\ufe44\\u3014\\u3015\\u2026\\u2014\\uff5e\\ufe4f\\uffe5]");
    private static final Pattern FC_NODE_RULE = Pattern.compile("[\\u4e00-\\u9fa5A-Z]");
    private InfoItem infoItem;
    private JDialog parent;
    private IRecheck recheck;
    private String VENDOR = "ism.OEM.vendor";
    private String BRAND = "ism.OEM.brand";
    private String PRODUCT = "ism.OEM.product";
    private String PRODUCTMODEL = "ism.OEM.productModel";
    private Boolean isUnifiedVer = new OemDataContext().isUnifiedVer();
    private Map<String, List<String>> modelVersion = OemDataContext.getInstance().getModelVersion();

    public TextChecker(InfoItem infoItem, JDialog parent) {
        this.infoItem = infoItem;
        this.parent = parent;
        if (null != infoItem.getRecheck()) {
            try {
                Class<?> clazz = Class.forName(infoItem.getRecheck());
                Object obj = clazz.newInstance();
                if (obj instanceof IRecheck) {
                    this.recheck = (IRecheck)obj;
                } else {
                    log.error("Load recheck class error, object is not the right type, object: {} ", (Object)obj.getClass().getName());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error("Load recheck class error, recheck class: {} ", (Object)infoItem.getRecheck());
            }
        }
    }

    @Override
    public boolean checkData() {
        String defaultText;
        String textValidaty = this.infoItem.getValidaty();
        String text = this.infoItem.getDefValue();
        String remind = this.infoItem.getRemind();
        String key = this.infoItem.getKey();
        if (StringUtils.isNULLStr((String)textValidaty)) {
            return true;
        }
        if (this.infoItem.isChecktext()) {
            text = this.searchChineseCharacters(text);
        }
        if (this.infoItem.isFcNode()) {
            text = this.checkChineseAndUppercaseLetter(text);
        }
        if (this.judgmentKey(key) && ResourceUtil.getString((String)(defaultText = key + ".default")).equalsIgnoreCase(text)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)this.getRemind());
            return false;
        }
        if (this.PRODUCTMODEL.equals(key) && this.isUnifiedVer.booleanValue() && this.judgmentDevice(text)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)this.getRemind());
            return false;
        }
        Pattern pattern = Pattern.compile(textValidaty);
        Matcher matcher = pattern.matcher(text);
        if (!matcher.matches()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)remind);
            return false;
        }
        if (null != this.recheck && !this.recheck.check(text)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)remind);
            return false;
        }
        return true;
    }

    private boolean isTooLongStr(String text) {
        return text.length() > 128;
    }

    private String checkChineseAndUppercaseLetter(String text) {
        StringBuilder sb = new StringBuilder(text);
        Arrays.stream(text.split("")).filter(character -> FC_NODE_RULE.matcher((CharSequence)character).matches()).forEach(sb::append);
        return sb.toString();
    }

    private String searchChineseCharacters(String text) {
        StringBuilder sb = new StringBuilder(text);
        Arrays.stream(text.split("")).filter(character -> CHINESE_RULE.matcher((CharSequence)character).matches()).forEach(chineseChar -> sb.append((String)chineseChar).append((String)chineseChar));
        return sb.toString();
    }

    private boolean judgmentKey(String key) {
        return (this.VENDOR.equals(key) || this.BRAND.equals(key) || this.PRODUCT.equals(key)) && this.isUnifiedVer != false;
    }

    private String getRemind() {
        return ResourceUtil.getString((String)this.infoItem.getKey()) + ResourceUtil.getString((String)"error.msg.text") + this.infoItem.getDefValue();
    }

    private boolean judgmentDevice(String text) {
        Object[] modelArray = this.modelVersion.keySet().toArray(new String[0]);
        Arrays.sort(modelArray);
        for (Object productModel : modelArray) {
            if (!((String)productModel).equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }
}

