/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import com.huawei.ism.tool.oem.utils.OemConstants;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleConFile
extends HandleAbstracter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleConFile.class);

    @Override
    public boolean createFile() {
        String conFileName = this.getFileItem().getFileName();
        String folder = this.getFileItem().getFolder();
        String createUrl = this.getPath() + (StringUtils.isNULLStr(folder) ? "" : File.separator + folder);
        String targetPath = createUrl + File.separator + conFileName;
        String proContext = this.getconContext();
        File file = new File(targetPath);
        String parentPath = file.getParent();
        if (!new File(parentPath).exists()) {
            FileUtils.createDir((String)parentPath);
        }
        try {
            StreamUtils.writeInfo2File((byte[])proContext.getBytes("utf-8"), (String)targetPath);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("create conf file exeception", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("create conf file exeception", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getconContext() {
        StringBuilder conContext = new StringBuilder();
        List<InfoItem> infos = this.getFileItem().getTxtInfos();
        for (InfoItem info : infos) {
            String key = info.getKey();
            String text = info.getDefValue();
            if (!StringUtils.isNULLStr(key)) {
                conContext.append(key);
                conContext.append("=");
            }
            conContext.append(text).append(OemConstants.LINE_SEPARATOR);
        }
        return conContext.toString();
    }

    @Override
    public void readFile() {
        String folder = this.getFileItem().getFolder();
        String fileName = this.getFileItem().getFileName();
        String pathAndName = StringUtils.isNULLStr(folder) ? fileName : folder + File.separator + fileName;
        String fileMessage = this.getFileMessage(pathAndName);
        List<InfoItem> infoItems = this.getFileItem().getTxtInfos();
        int beginIndex = -1;
        for (InfoItem infoItem : infoItems) {
            String key = infoItem.getKey();
            int endIndex = fileMessage.indexOf(OemConstants.LINE_SEPARATOR, beginIndex);
            String rowVal = fileMessage.substring(beginIndex + 1, endIndex).trim();
            String val = this.handleKeyVal(rowVal, key);
            beginIndex = endIndex + 1;
            infoItem.setDefValue(val);
        }
    }

    private String handleKeyVal(String val, String key) {
        if (StringUtils.isNULLStr(key)) {
            return val;
        }
        int keyIndex = val.indexOf(key);
        if (keyIndex == -1) {
            return val;
        }
        int equaMarkIndex = val.indexOf("=");
        if (equaMarkIndex == -1) {
            return val;
        }
        return val.substring(equaMarkIndex + 1).trim();
    }
}

