/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleImageFIle
extends HandleAbstracter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleImageFIle.class);

    @Override
    public boolean createFile() {
        String fileName = this.getFileItem().getFileName();
        String folder = this.getFileItem().getFolder();
        String sourcePath = this.getFileItem().getFilePath();
        String targetPath = this.getPath() + (StringUtils.isNULLStr(folder) ? "" : File.separator + folder);
        String targetFilePath = targetPath + File.separator + fileName;
        if (StringUtils.isNULLStr(sourcePath) || StringUtils.isNULLStr(targetFilePath)) {
            LOGGER.info("ceate image {} failed, because lack filepath", (Object)fileName);
            return true;
        }
        if (!new File(targetPath).exists()) {
            FileUtils.createDir((String)targetPath);
        }
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetFilePath);
        StreamUtils.copyFile((File)sourceFile, (File)targetFile);
        return true;
    }

    @Override
    public void readFile() {
        String packageName;
        String folder = this.getFileItem().getFolder();
        String fileName = this.getFileItem().getFileName();
        String pathAndName = StringUtils.isNULLStr(folder) ? fileName : folder + File.separator + fileName;
        String imagePath = this.getImagePath(pathAndName, packageName = this.getFileItem().getPackageName());
        if (new File(imagePath).exists()) {
            this.getFileItem().setFilePath(imagePath);
        }
    }

    @NotNull
    private String getImagePath(String pathAndName, String packageName) {
        return StringUtils.isNULLStr(packageName) ? String.join((CharSequence)File.separator, this.getUnZipTemp(), pathAndName) : String.join((CharSequence)File.separator, this.getUnZipTemp(), packageName, pathAndName);
    }
}

