/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import com.huawei.ism.tool.oem.utils.OemConstants;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleIniFile
extends HandleAbstracter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleIniFile.class);

    @Override
    public boolean createFile() {
        String iniFileName = this.getFileItem().getFileName();
        String folder = this.getFileItem().getFolder();
        String createUrl = this.getPath() + (StringUtils.isNULLStr(folder) ? "" : File.separator + folder);
        String targetPath = createUrl + File.separator + iniFileName;
        String iniContext = this.getFileContext();
        File file = new File(targetPath);
        String parentPath = file.getParent();
        if (!new File(parentPath).exists()) {
            FileUtils.createDir((String)parentPath);
        }
        try {
            StreamUtils.writeInfo2File((byte[])iniContext.getBytes("utf-8"), (String)targetPath);
        }
        catch (Exception e) {
            LOGGER.error("create js file failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getFileContext() {
        StringBuilder iniContext = new StringBuilder();
        List<InfoItem> infos = this.getFileItem().getTxtInfos();
        for (InfoItem info : infos) {
            String text = info.getDefValue();
            String key = info.getKey();
            iniContext.append(key).append("=").append(text).append(OemConstants.LINE_SEPARATOR);
        }
        return iniContext.toString();
    }

    @Override
    public void readFile() {
        String folder = this.getFileItem().getFolder();
        String fileName = this.getFileItem().getFileName();
        String pathAndName = StringUtils.isNULLStr(folder) ? fileName : folder + File.separator + fileName;
        String packageName = this.getFileItem().getPackageName();
        String fileMessage = StringUtils.isNULLStr(packageName) ? this.getFileMessage(pathAndName) : this.getFileMessage(pathAndName, packageName);
        List<InfoItem> infoItems = this.getFileItem().getTxtInfos();
        for (InfoItem infoItem : infoItems) {
            String key = infoItem.getKey();
            int index = fileMessage.indexOf(key);
            if (index == -1) continue;
            int beginIndex = fileMessage.indexOf("=", index);
            int endIndex = fileMessage.indexOf(OemConstants.LINE_SEPARATOR, beginIndex);
            String val = fileMessage.substring(beginIndex + 1, endIndex).trim();
            infoItem.setDefValue(val);
        }
    }
}

