/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import com.huawei.ism.tool.oem.utils.FileType;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.ui.module.notification.GFString;
import com.huawei.json.JSONUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleJsFile
extends HandleAbstracter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleJsFile.class);
    private static final String QUOTATION_MARK = "'";
    private static final String BLANK = "";
    private static final String END_TAG = ";";
    private static final int SPLIT_INDEX = 2;
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5|\\\\\uff0c\u3002\u00a9]");
    private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u[a-f0-9A-F]{4}");
    private static final Pattern UNICODE_TO_CHINESE_PATTERN = Pattern.compile("(\\\\u(\\w{4}))");
    private static final String UNICODE_PREFIX = "\\u";

    @Override
    public boolean createFile() {
        String jsFileName = this.getFileItem().getFileName();
        String folder = this.getFileItem().getFolder();
        String createUrl = this.getPath() + (StringUtils.isNULLStr(folder) ? BLANK : File.separator + folder);
        String targetPath = createUrl + File.separator + jsFileName;
        String context = this.getFileContext();
        File file = new File(targetPath);
        String parentPath = file.getParent();
        if (!new File(parentPath).exists()) {
            FileUtils.createDir((String)parentPath);
        }
        try {
            StreamUtils.writeInfo2File((byte[])context.getBytes("utf-8"), (String)targetPath);
        }
        catch (Exception e) {
            LOGGER.error("create js file failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getFileContext() {
        StringBuilder context = new StringBuilder();
        List<InfoItem> infos = this.getFileItem().getTxtInfos();
        for (InfoItem info : infos) {
            boolean needConverted;
            String text = info.getDefValue();
            String key = info.getKey();
            String desc = info.getDesc();
            for (String name : OemDataContext.getInstance().getOptionName()) {
                if (!desc.equals(name)) continue;
                text = "true;";
            }
            if ("%NOT_SHOW%".equalsIgnoreCase(text)) {
                LOGGER.info(String.format(Locale.ENGLISH, "get a \"not show\" item, key: %s, value: %s, continue.", key, text));
                continue;
            }
            boolean bl = needConverted = info.isFcNode() && this.isContainChinese(text);
            if (info.isVisible()) {
                if (info.getFileType().equals((Object)FileType.JSONTEXT)) {
                    LOGGER.info("create oxm item json .");
                    this.constructOxmContext(context, info, key);
                    continue;
                }
                this.appendOeminfoText(context, text, key, needConverted);
                continue;
            }
            if (needConverted) {
                String tempText = text;
                text = this.convertChineseToUnicode(tempText);
            }
            context.append(key).append("=").append(text).append(OemConstants.LINE_SEPARATOR);
        }
        return context.toString();
    }

    private String convertChineseToUnicode(String text) {
        List<String> arr = Arrays.stream(text.split(BLANK)).map(this::getString).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        arr.forEach(sb::append);
        return sb.toString();
    }

    private String getString(String character) {
        if (this.isContainChinese(character)) {
            return UNICODE_PREFIX + GFString.gb2uni((String)character);
        }
        return character;
    }

    private boolean isContainChinese(String text) {
        return CHINESE_PATTERN.matcher(text).find();
    }

    private void appendOeminfoText(StringBuilder context, String text, String key, boolean needConverted) {
        String tempText = text.replace("\\", "\\\\").replace(QUOTATION_MARK, "\\'").replace("\"", "\\\"").replaceAll("\n", "<br>");
        if (needConverted) {
            tempText = this.convertChineseToUnicode(tempText);
        }
        context.append(key).append("=").append(QUOTATION_MARK).append(tempText).append(QUOTATION_MARK).append(END_TAG).append(OemConstants.LINE_SEPARATOR);
    }

    private void constructOxmContext(StringBuilder context, InfoItem info, String key) {
        List<InfoItem> oxmItems = info.getOxmItems();
        Map<String, String> itemMap = oxmItems.stream().filter(oxmItem -> !StringUtils.isNULLStr(oxmItem.getDefValue())).collect(Collectors.toMap(InfoItem::getKey, InfoItem::getDefValue));
        String oxmJson = JSONUtils.toJson(itemMap);
        LOGGER.info("oxm json:{}", (Object)oxmJson);
        context.append(key).append("=").append(oxmJson).append(END_TAG).append(OemConstants.LINE_SEPARATOR);
    }

    @Override
    public void readFile() {
        String folder = this.getFileItem().getFolder();
        String fileName = this.getFileItem().getFileName();
        String pathAndName = StringUtils.isNULLStr(folder) ? fileName : folder + File.separator + fileName;
        String packageName = this.getFileItem().getPackageName();
        String fileMessage = StringUtils.isNULLStr(packageName) ? this.getFileMessage(pathAndName) : this.getFileMessage(pathAndName, packageName);
        List<InfoItem> infoItems = this.getFileItem().getTxtInfos();
        for (InfoItem infoItem : infoItems) {
            String infoKey = infoItem.getKey();
            if (infoItem.getFileType().equals((Object)FileType.JSONTEXT)) {
                Map<String, String> oxmMap = this.getOxmJson(fileMessage, infoKey);
                if (oxmMap == null) continue;
                List<InfoItem> oxmItems = infoItem.getOxmItems();
                oxmItems.forEach(oxmItem -> oxmItem.setDefValue(this.getOxmValue(oxmMap, (InfoItem)oxmItem)));
                continue;
            }
            String val = this.getOemInfoValue(fileMessage, infoItem, infoKey);
            if (val == null) continue;
            infoItem.setDefValue(val);
        }
    }

    private String getOxmValue(Map<String, String> oxmMap, InfoItem oxmItem) {
        return oxmMap.get(oxmItem.getKey()) == null ? BLANK : oxmMap.get(oxmItem.getKey());
    }

    private Map<String, String> getOxmJson(String fileMessage, String infoKey) {
        int index = fileMessage.indexOf(infoKey);
        if (index == -1) {
            return null;
        }
        int beginIndex = fileMessage.indexOf("=", index);
        int endIndex = fileMessage.indexOf(OemConstants.LINE_SEPARATOR, beginIndex);
        String val = fileMessage.substring(beginIndex + 1, endIndex).replace(END_TAG, BLANK).trim();
        return JSONUtils.jsonToMaps((String)val);
    }

    private String getOemInfoValue(String fileMessage, InfoItem infoItem, String infoKey) {
        int index = fileMessage.indexOf(infoKey);
        if (index == -1) {
            return null;
        }
        int beginIndex = fileMessage.indexOf("=", index);
        int endIndex = fileMessage.indexOf(OemConstants.LINE_SEPARATOR, beginIndex);
        String val = fileMessage.substring(beginIndex + 1, endIndex).trim();
        if (infoItem.isVisible()) {
            val = val.substring(1, val.length() - 2).replace("\\'", QUOTATION_MARK).replace("\\\"", "\"");
            val = val.replaceAll("\\\\\\\\", "\\\\");
            val = val.replaceAll("<br>", "\n");
        }
        if (infoItem.isFcNode() && this.hasUnicode(val)) {
            val = this.convertUnicodeToChinese(val);
        }
        return val;
    }

    private String convertUnicodeToChinese(String val) {
        Matcher matcher = UNICODE_TO_CHINESE_PATTERN.matcher(val);
        String tempVal = val;
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            tempVal = tempVal.replace(matcher.group(1), String.valueOf(ch));
        }
        return tempVal;
    }

    private boolean hasUnicode(String val) {
        return UNICODE_PATTERN.matcher(val).find();
    }
}

