/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleProFile
extends HandleAbstracter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleProFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createFile() {
        String filePath = this.getFilePath();
        InputStream in = null;
        OutputStream out = null;
        try {
            Properties pps = new Properties();
            File proFile = new File(filePath);
            if (!proFile.exists() && !proFile.createNewFile()) {
                LOGGER.info("create file {} falied!", (Object)filePath);
                boolean bl = false;
                this.closeStream(out);
                this.closeInputStream(in);
                return bl;
            }
            in = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            pps.load(in);
            out = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
            List<InfoItem> infos = this.getFileItem().getTxtInfos();
            for (InfoItem info : infos) {
                String text = this.replaceQuoteVal(info.getDefValue(), info.getQuote());
                String key = info.getKey();
                pps.setProperty(key, text);
            }
            pps.store(out, "");
            this.closeStream(out);
        }
        catch (Exception e) {
            LOGGER.error("create properties failed!", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeStream(out);
            this.closeInputStream(in);
        }
        this.closeInputStream(in);
        return true;
    }

    private String getFilePath() {
        String proFileName = this.getFileItem().getFileName();
        String folder = this.getFileItem().getFolder();
        String createUrl = this.getPath() + (StringUtils.isNULLStr(folder) ? "" : File.separator + folder);
        return createUrl + File.separator + proFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile() {
        String filePath = this.getTmpPath();
        BufferedInputStream input = null;
        try {
            input = new BufferedInputStream(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
            PropertyResourceBundle bundle = new PropertyResourceBundle(input);
            List<InfoItem> infoItems = this.getFileItem().getTxtInfos();
            for (InfoItem infoItem : infoItems) {
                String key = infoItem.getKey();
                infoItem.setDefValue(this.getKeyValue(bundle, key));
            }
            this.closeInputStream(input);
        }
        catch (Exception e) {
            try {
                LOGGER.error("read file failed,the file:" + filePath, (Throwable)e);
                this.closeInputStream(input);
            }
            catch (Throwable throwable) {
                this.closeInputStream(input);
                throw throwable;
            }
        }
    }

    private String getTmpPath() {
        String folder = this.getFileItem().getFolder();
        String prfileName = this.getFileItem().getFileName();
        String pathAndName = StringUtils.isNULLStr(folder) ? prfileName : folder + File.separator + prfileName;
        return this.getUnZipTemp() + File.separator + pathAndName;
    }

    private String getKeyValue(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (Exception e) {
            LOGGER.info("can't find {} value", (Object)key);
            return "";
        }
    }

    private void closeStream(OutputStream out) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("close out stream failed", (Throwable)e);
        }
    }

    private void closeInputStream(InputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("close input stream failed!", (Throwable)e);
        }
    }
}

