/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.handler;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.FileList;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.entity.OemInfo;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class HandleReplaceVal {
    private OemInfo oemInfo;

    public HandleReplaceVal(OemInfo oemInfo) {
        this.oemInfo = oemInfo;
    }

    public String getReplaceVal(String text, String quote) {
        if (StringUtils.isNULLStr(quote)) {
            return text;
        }
        if (!quote.contains(",")) {
            return MessageFormat.format(text, this.findQuoteVal(quote));
        }
        String[] quotes = quote.split(",");
        return MessageFormat.format(text, this.findQuoteVals(quotes));
    }

    private String findQuoteVal(String id) {
        List<FileItem> allFileItem = this.oemInfo.getInfoList();
        String findVal = this.findQuoteValInFileItem(allFileItem, id);
        if (StringUtils.isNULLStr(findVal)) {
            List<FileList> allFileList = this.oemInfo.getAllFileList();
            findVal = this.findQuoteValInFileList(allFileList, id);
        }
        return findVal;
    }

    private String findQuoteValInFileList(List<FileList> allFileList, String id) {
        Iterator<FileList> iterator = allFileList.iterator();
        if (iterator.hasNext()) {
            FileList fileList = iterator.next();
            List<FileItem> allFileItem = fileList.getChildItem();
            return this.findQuoteValInFileItem(allFileItem, id);
        }
        return "";
    }

    private String findQuoteValInFileItem(List<FileItem> allFileItem, String id) {
        for (FileItem fileItem : allFileItem) {
            if (id.equals(fileItem.getItemId())) {
                return fileItem.getFilePath();
            }
            List<InfoItem> infos = fileItem.getTxtInfos();
            for (InfoItem info : infos) {
                if (!id.equals(info.getItemId())) continue;
                return info.getDefValue();
            }
        }
        return "";
    }

    private Object[] findQuoteVals(String[] quotes) {
        Object[] returnArr = new String[quotes.length];
        for (int i = 0; i < quotes.length; ++i) {
            returnArr[i] = this.findQuoteVal(quotes[i]);
        }
        return returnArr;
    }
}

