/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.task;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.CliItem;
import com.huawei.ism.tool.oem.entity.ComputeStorageUtils;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.logic.task.OemTask;
import com.huawei.ism.tool.oem.service.impl.ComputeNodeSettingService;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.tool.oem.utils.RunType;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTask
extends OemTask {
    private static final Logger log = LoggerFactory.getLogger(ImportTask.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportTask.class);
    private static final CmdType TASK_CMD_TYPE = CmdType.IMPORTOEM;
    private static final String FC = "fc";
    private static final String FCV = "fcv";

    @Override
    public void run() {
        if (OemConstants.isComputeStorageOemInfo(this.getOemInfo())) {
            this.importComputeStorageOemPackage();
        } else {
            this.importOemPackage();
        }
    }

    private void importComputeStorageOemPackage() {
        List<MultiRouteNode> storageFcNodes;
        List<MultiRouteNode> storageOsmNodes = ComputeNodeSettingService.getInstance().getOsmNodesByIp(this.getNode().getIp());
        if (!this.checkOemPath(storageOsmNodes, storageFcNodes = ComputeNodeSettingService.getInstance().getFcNodesByIp(this.getNode().getIp()))) {
            this.saveErrMsg(OemDataContext.getInstance(), OemUIContext.getInstance(), ResourceUtil.getString((String)"oem.tool.execute.verifying.error"));
            return;
        }
        if (!storageOsmNodes.isEmpty() && storageFcNodes.isEmpty()) {
            if (this.importOemPackageToNode(FCV, storageOsmNodes)) {
                this.saveSuccessMsg(OemDataContext.getInstance(), OemUIContext.getInstance());
            }
            return;
        }
        if (this.isUploadOemFileFailed(storageOsmNodes, storageFcNodes)) {
            return;
        }
        this.importOemPackage();
    }

    private boolean isUploadOemFileFailed(List<MultiRouteNode> storageOsmNodes, List<MultiRouteNode> storageFcNodes) {
        if (storageOsmNodes.isEmpty() && storageFcNodes.isEmpty()) {
            log.info("Independent OEM storage nodes.");
            return false;
        }
        return !this.importOemPackageToNode(FCV, storageOsmNodes) || !this.importOemPackageToNode(FC, storageFcNodes);
    }

    private boolean checkOemPath(List<MultiRouteNode> storageOsmNodes, List<MultiRouteNode> storageFcNodes) {
        File tempPath = new File(ComputeStorageUtils.UN_ZIP_TEMP);
        File[] listFiles = tempPath.listFiles();
        if (listFiles == null) {
            LOGGER.warn("oem unzip path is null");
            return false;
        }
        if (storageOsmNodes.isEmpty() && storageFcNodes.isEmpty()) {
            log.info("No fcv or fc nodes, oem storage node mode.");
            return true;
        }
        if (!storageOsmNodes.isEmpty() && storageFcNodes.isEmpty()) {
            return Arrays.stream(listFiles).map(File::getName).anyMatch("FCV_OEM.tgz"::equals) && Arrays.stream(listFiles).map(File::getName).noneMatch("FC_OEM.zip"::equals);
        }
        return Arrays.stream(listFiles).map(File::getName).anyMatch("FCV_OEM.tgz"::equals) && Arrays.stream(listFiles).map(File::getName).anyMatch("FC_OEM.zip"::equals);
    }

    private boolean importOemPackageToNode(String nodeName, List<MultiRouteNode> storageFcNodes) {
        ComputeStorageUtils csUtils = new ComputeStorageUtils(this.getNode(), this.getOemInfo());
        return storageFcNodes.stream().allMatch(nodeInfo -> csUtils.doUpLoadOemPackToNode(nodeName, (MultiRouteNode)nodeInfo));
    }

    private void importOemPackage() {
        OemDataContext dataContext = OemDataContext.getInstance();
        OemUIContext uiContext = OemUIContext.getInstance();
        this.setCmdType(TASK_CMD_TYPE);
        try {
            dataContext.addNewResult(this.getNode(), ResourceUtil.getString((String)"oem.tool.execute.import.upload"));
            uiContext.uiCallBack(this.getNode());
            if (!this.createConnection()) {
                this.saveErrMsg(dataContext, uiContext, ResourceUtil.getString((String)"oem.tool.execute.import.error"));
                return;
            }
            if (!this.doUpLoadOemPack(this.getSftp(), this.getOemInfo())) {
                LOGGER.error("upload oem pack failed");
                this.saveErrMsg(dataContext, uiContext, ResourceUtil.getString((String)"oem.tool.execute.import.error"));
                return;
            }
            dataContext.setLastResult(this.getNode(), true, "");
            uiContext.uiCallBack(this.getNode());
            dataContext.addNewResult(this.getNode(), this.combinDesc());
            uiContext.uiCallBack(this.getNode());
            LOGGER.info("resutlt size :{}", (Object)dataContext.getDevExeResults(this.getNode()).size());
            if (!this.execute()) {
                LOGGER.error("execute cmd command failed");
            } else {
                dataContext.setLastResult(this.getNode(), true, "");
                dataContext.setDevRunState(this.getNode(), RunType.SUCESSED);
                LOGGER.info("{} import task execute succeed", (Object)this.getNode().getIp());
            }
            uiContext.uiCallBack(this.getNode());
        }
        finally {
            this.closeConnection();
        }
    }

    private void saveErrMsg(OemDataContext dataContext, OemUIContext uiContext, String errMessage) {
        dataContext.setLastResult(this.getNode(), false, errMessage);
        dataContext.setDevRunState(this.getNode(), RunType.FAILED);
        uiContext.uiCallBack(this.getNode());
    }

    private void saveSuccessMsg(OemDataContext dataContext, OemUIContext uiContext) {
        dataContext.setLastResult(this.getNode(), true, "");
        dataContext.setDevRunState(this.getNode(), RunType.SUCESSED);
        uiContext.uiCallBack(this.getNode());
    }

    private String combinDesc() {
        StringBuilder conbinStr = new StringBuilder();
        conbinStr.append(ResourceUtil.getString((String)"oem.tool.execute.import.process"));
        List<CliItem> items = this.getOemInfo().getCliMap().get((Object)TASK_CMD_TYPE);
        String importTip = "";
        for (CliItem item : items) {
            String curImportTip = item.getAfterTip();
            if (StringUtils.isNULLStr(curImportTip)) continue;
            importTip = curImportTip;
            break;
        }
        if (!StringUtils.isNULLStr(importTip)) {
            conbinStr.append("(");
            conbinStr.append(importTip);
            conbinStr.append(")");
        }
        return conbinStr.toString();
    }

    private boolean doUpLoadOemPack(SftpTransporter sftp, OemInfo oemInfo) {
        String localPath = oemInfo.getLocPath();
        String serverPath = oemInfo.getDevPath();
        if (StringUtils.isNULLStr(serverPath)) {
            LOGGER.error("oemConfig lack path node!");
            return false;
        }
        if (StringUtils.isNULLStr(localPath)) {
            LOGGER.error("lack of localPath");
            return false;
        }
        try {
            sftp.putFullPathFile(new File(localPath), serverPath, null);
        }
        catch (ToolException e) {
            LOGGER.error("upload oem package failed", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("upload oem package failed", (Throwable)e);
            return false;
        }
        return true;
    }
}

