/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.task;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.SftpTransporter;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.CliItem;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.utils.BooleanVar;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.ModeType;
import com.huawei.ism.tool.oem.utils.RunType;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OemTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OemTask.class);
    private static final int DEFAULT_TIMEOUT = 15;
    private static final String DARK_PASWD = "**********";
    private static final String JUDGE_NONE = "none";
    private static final String JUDGE_FAILE = "error";
    private static final String V3R6 = "V300R006";
    private static final String V5R7 = "V500R007";
    private static final String CLI_CMD_SUCCESS_FLAG = "Command executed successfully";
    private static final String[] DEVELOPER_MODLE_CMD = new String[]{"change user_mode current_mode user_mode=developer", "developer"};
    private static final String MINI_SYSTEM = "minisystem";
    private DevNode node;
    private SftpTransporter sftp;
    private SshConnection ssh;
    private OemInfo oemInfo;
    private CmdType cmdType;

    public void init() {
        OemDataContext context = OemDataContext.getInstance();
        context.setLastResult(this.node, true, "");
    }

    public boolean createConnection() {
        try {
            this.ssh = (SshConnection)SshConnectionManager.getSshConnection(this.node, null, true, false);
            this.sftp = new SftpTransporter(this.ssh);
        }
        catch (ToolException e) {
            LOGGER.error("connect device failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public void closeConnection() {
        try {
            if (this.sftp != null) {
                this.sftp.close();
                this.sftp = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("close sftp failed", (Throwable)e);
        }
        try {
            if (null != this.ssh) {
                this.ssh.close();
                this.ssh = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("close ssh failed", (Throwable)e);
        }
    }

    @Override
    public void run() {
    }

    public boolean decisionCliModel(ModeType modeType) {
        if (ModeType.DEVELOPER.equals((Object)modeType)) {
            return this.checkDeveloperPwd();
        }
        if (ModeType.MINISYSTEM.equals((Object)modeType)) {
            return this.goMinisystemModel();
        }
        return true;
    }

    private boolean goMinisystemModel() {
        if (!this.checkDeveloperPwd()) {
            return false;
        }
        return this.checkMiniSystem();
    }

    private boolean checkMiniSystem() {
        try {
            String sshResult = this.ssh.execCmdWithTimout(MINI_SYSTEM, 15);
            if (sshResult.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n):")) {
                sshResult = this.ssh.execCmdWithTimout("y", 15);
            }
            if (!sshResult.trim().toLowerCase(Locale.ENGLISH).endsWith("minisystem>")) {
                return false;
            }
        }
        catch (ToolException e) {
            LoggerFactory.getLogger(OemTask.class).error("check minisystem error. devnode : " + this.node.getIp(), (Throwable)e);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(OemTask.class).error("check minisystem error. devnode : " + this.node.getIp(), (Throwable)e);
        }
        return true;
    }

    private boolean getDeveloperModeIsVaild(BooleanVar isDeveloperVaild) {
        try {
            String res = this.ssh.execCmdWithTimout("show user_mode enabled\n", 15);
            if (StringUtils.isNULLStr(res)) {
                return false;
            }
            String[] resArray = res.split("\n");
            for (int i = 0; i < resArray.length; ++i) {
                if (!resArray[i].trim().startsWith("Developer View")) continue;
                String[] temp = resArray[i].split(":");
                if (temp.length != 2) {
                    LOGGER.error("format is not correct." + res);
                    isDeveloperVaild.setBooleanValue(false);
                    return true;
                }
                if (!temp[1].trim().equals("Enabled")) break;
                isDeveloperVaild.setBooleanValue(true);
                return true;
            }
            isDeveloperVaild.setBooleanValue(false);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("get developer mode is vaild error " + e);
            return false;
        }
    }

    private boolean makeSomethingBeforeDecisionDeveloperMode(ModeType modeType, BooleanVar changeSystemStatus) {
        if (ModeType.NORMAL.equals((Object)modeType)) {
            return true;
        }
        if (!this.node.getProductVersion().contains(V3R6) && !this.node.getProductVersion().contains(V5R7)) {
            return true;
        }
        try {
            BooleanVar developerModelIsVaild = new BooleanVar(false);
            if (!this.getDeveloperModeIsVaild(developerModelIsVaild)) {
                return false;
            }
            if (developerModelIsVaild.isBooleanValue()) {
                return true;
            }
            String res = this.ssh.execCmdWithTimout("change user_mode enabled user_mode=developer enabled=yes\n", 15);
            if (!res.contains(CLI_CMD_SUCCESS_FLAG)) {
                LOGGER.error("make developer mode vaild failed.");
                return false;
            }
            changeSystemStatus.setBooleanValue(true);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return true;
        }
    }

    private boolean makeSomethingAfterDecisionCLIMode() {
        try {
            String res = this.ssh.execCmdWithTimout("change user_mode enabled user_mode=developer enabled=no\n", 15);
            if (!res.contains(CLI_CMD_SUCCESS_FLAG)) {
                LOGGER.error("make developer mode availd failed.");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return false;
        }
        return true;
    }

    public boolean checkDeveloperPwd() {
        try {
            for (String cmd : DEVELOPER_MODLE_CMD) {
                String sshResult = this.ssh.execCmdWithTimout(cmd, 15);
                LOGGER.info("go to developer: {}", (Object)sshResult);
                if (!OemTask.judgeNoModel(sshResult) && !this.judgeModelPass(sshResult)) continue;
                LOGGER.info("go to developer: success");
                return true;
            }
        }
        catch (ToolException e) {
            LoggerFactory.getLogger(OemTask.class).error("check developer error. devnode : " + this.node.getIp(), (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LoggerFactory.getLogger(OemTask.class).error("check developer error. devnode : " + this.node.getIp(), (Throwable)e);
            return false;
        }
        return false;
    }

    private static boolean judgeNoModel(String result) {
        return result.trim().toLowerCase(Locale.ENGLISH).endsWith("developer:/>");
    }

    private boolean judgeModelPass(String result) throws ToolException {
        String finalResult = result;
        if (finalResult.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n)")) {
            finalResult = this.ssh.execCmdWithTimout("y", 15);
        }
        return finalResult.trim().toLowerCase(Locale.ENGLISH).contains("developer:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(OemDataContext dataContext, OemUIContext uiContext) {
        uiContext.uiCallBack(this.getNode());
        try {
            if (!this.createConnection()) {
                String errorMesage = ResourceUtil.getString((String)"oem.error.execute.cli.cmd");
                dataContext.setLastResult(this.getNode(), false, errorMesage);
                dataContext.setDevRunState(this.getNode(), RunType.FAILED);
                uiContext.uiCallBack(this.getNode());
                return;
            }
            if (!this.execute()) {
                LOGGER.error("execute cmd command failed");
            } else {
                dataContext.setLastResult(this.node, true, "");
                dataContext.setDevRunState(this.getNode(), RunType.SUCESSED);
                LOGGER.info("{} import task execute succeed", (Object)this.getNode().getIp());
            }
            uiContext.uiCallBack(this.getNode());
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean execute() {
        OemDataContext dataContext = OemDataContext.getInstance();
        Map<CmdType, List<CliItem>> cliMap = this.getOemInfo().getCliMap();
        List<CliItem> cliItems = cliMap.get((Object)this.cmdType);
        if (null == cliItems) {
            dataContext.setLastResult(this.node, false, "");
            dataContext.setDevRunState(this.node, RunType.FAILED);
            return false;
        }
        for (CliItem cliItem : cliItems) {
            String script = cliItem.getScript();
            boolean exeResult = false;
            exeResult = !StringUtils.isNULLStr(script) ? this.executeScript(script) : this.exeCliCmd(cliItem);
            if (exeResult) continue;
            return false;
        }
        return true;
    }

    private boolean executeScript(String script) {
        OemDataContext context = OemDataContext.getInstance();
        File scriptPy = new File(script);
        if (!scriptPy.exists()) {
            LOGGER.info("execute script don't exists!");
            return false;
        }
        try {
            JythonExecuter jythonExecuter = new JythonExecuter(scriptPy.getParentFile());
            jythonExecuter.compileScript(scriptPy);
            List returnInof = jythonExecuter.invokeFunction("execute", this.handleParams());
            if (null == returnInof || returnInof.isEmpty() || returnInof.size() < 2) {
                context.setLastResult(this.node, false, "");
                context.setDevRunState(this.node, RunType.FAILED);
                LOGGER.info("return info error!");
                return false;
            }
            Boolean isScuess = Boolean.valueOf(returnInof.get(0).toString());
            String exeInfo = returnInof.get(1).toString();
            LOGGER.info("isScuess:" + isScuess);
            if (Boolean.FALSE.equals(isScuess)) {
                context.setLastResult(this.node, false, exeInfo);
                context.setDevRunState(this.node, RunType.FAILED);
                return false;
            }
            context.setLastResult(this.node, true, exeInfo);
            context.setDevRunState(this.node, RunType.SUCESSED);
        }
        catch (SignException e) {
            context.setLastResult(this.node, false, e.getErrorMsg());
            context.setDevRunState(this.node, RunType.FAILED);
            LOGGER.error("Sign file failed", (Throwable)e);
            return false;
        }
        catch (FileNotFoundException e) {
            context.setLastResult(this.node, false, ResourceUtil.getString((String)"oem.error.execute.script"));
            context.setDevRunState(this.node, RunType.FAILED);
            LOGGER.error("execute script failed! ecript file not found.");
            return false;
        }
        catch (ToolException e) {
            context.setLastResult(this.node, false, ResourceUtil.getString((String)"oem.error.execute.script"));
            context.setDevRunState(this.node, RunType.FAILED);
            LOGGER.error("execute script failed!", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            context.setLastResult(this.node, false, ResourceUtil.getString((String)"oem.error.execute.script"));
            context.setDevRunState(this.node, RunType.FAILED);
            LOGGER.error("execute script failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    private Map<String, Object> handleParams() {
        HashMap<String, Object> scriptParam = new HashMap<String, Object>();
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        String currentLanguage = null == loc ? ApplicationContext.getInstance().getCurrentLanguage().getLanguage() : loc.getLanguage();
        scriptParam.put("pkgpath", this.oemInfo.getLocPath());
        scriptParam.put("devPath", this.oemInfo.getDevPath());
        scriptParam.put("devSSH", this.ssh);
        scriptParam.put("devIp", this.node.getIp());
        scriptParam.put("logger", LOGGER);
        scriptParam.put("devUser", this.node.getLoginUser().getUserName());
        scriptParam.put("lan", currentLanguage);
        scriptParam.put("dev", this.node);
        scriptParam.put("sftp", this.getSftp());
        return scriptParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exeCliCmd(CliItem cliItem) {
        OemDataContext dataContext = OemDataContext.getInstance();
        String cmdStr = cliItem.getCmd();
        if (CmdType.IMPORTOEM.equals((Object)this.cmdType)) {
            cmdStr = this.handleCmd(cliItem.getCmd());
        }
        if (StringUtils.isNULLStr(cmdStr)) {
            dataContext.setLastResult(this.node, false, "");
            dataContext.setDevRunState(this.node, RunType.FAILED);
            LOGGER.info("{} lack of cmd command, or handle cmd failed!", (Object)this.node.getIp());
            return false;
        }
        boolean readyOk = true;
        BooleanVar changeSystemStatus = new BooleanVar(false);
        try {
            ModeType modeType = cliItem.getModeType();
            readyOk = this.makeSomethingBeforeDecisionDeveloperMode(modeType, changeSystemStatus);
            if (!readyOk || !this.decisionCliModel(modeType)) {
                String errorMess = MessageFormat.format(ResourceUtil.getString((String)"oem.error.enter.model.mess"), modeType.toString());
                dataContext.setLastResult(this.node, false, errorMess);
                dataContext.setDevRunState(this.node, RunType.FAILED);
                LOGGER.info("{} go to developer or normal model failed!", (Object)this.node.getIp());
                boolean bl = false;
                return bl;
            }
            if (!this.exeOneCmd(cliItem, cmdStr)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (changeSystemStatus.isBooleanValue()) {
                this.makeSomethingAfterDecisionCLIMode();
            }
        }
    }

    private boolean exeOneCmd(CliItem cliItem, String cmdStr) {
        OemDataContext dataContext = OemDataContext.getInstance();
        int timout = cliItem.getTimeout();
        String succJudage = cliItem.getSuccJudge().toLowerCase(Locale.ENGLISH);
        String retStr = this.executeCmd(cmdStr, timout);
        retStr = retStr.replace(this.getNode().getLoginUser().getPassword(), DARK_PASWD);
        LOGGER.info("cli return message:{}", (Object)retStr);
        String errorMessage = StringUtils.isNULLStr(cliItem.getFailedMsg()) ? ResourceUtil.getString((String)"oem.error.execute.cli.mess") : cliItem.getFailedMsg();
        retStr = this.sendPassword(retStr, timout);
        if (retStr.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n)")) {
            retStr = this.executeCmd("y", timout);
            LOGGER.info("cli return message:{}", (Object)retStr);
            if (retStr.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n)")) {
                if (CmdType.POWEROFF.equals((Object)cliItem.getCmdType())) {
                    try {
                        retStr = this.specialExecuteCmd("y", timout);
                        LOGGER.info("cli return message:{}", (Object)retStr);
                    }
                    catch (ToolException e) {
                        LOGGER.info("catch toolexception ,the connection seems to be closed ");
                        return true;
                    }
                } else {
                    retStr = this.executeCmd("y", timout);
                    LOGGER.info("cli return message:{}", (Object)retStr);
                }
            }
        }
        if (!this.judgeReturn(retStr = this.sendPassword(retStr, timout), succJudage, cliItem.getCmdType())) {
            dataContext.setLastResult(this.node, false, errorMessage);
            dataContext.setDevRunState(this.node, RunType.FAILED);
            LOGGER.info("{} execute cmd command failed", (Object)this.node.getIp());
            return false;
        }
        return true;
    }

    private String sendPassword(String retStr, int timout) {
        if (retStr.trim().toLowerCase(Locale.ENGLISH).endsWith("password:")) {
            String actualRetStr = this.executeCmd(this.getNode().getLoginUser().getPassword(), timout).replace(this.getNode().getLoginUser().getPassword(), DARK_PASWD);
            LOGGER.info("cli return message:{}", (Object)actualRetStr);
            return actualRetStr;
        }
        return retStr;
    }

    private boolean judgeReturn(String retStr, String succJudage, CmdType cmdtype) {
        if (JUDGE_NONE.equals(succJudage)) {
            return this.judgePowerOff(retStr, cmdtype);
        }
        if (!retStr.toLowerCase(Locale.ENGLISH).contains(succJudage)) {
            LOGGER.info("{} execute cmd command failed retStr : {}", (Object)this.getNode().getIp(), (Object)retStr);
            return false;
        }
        return true;
    }

    private boolean judgePowerOff(String retStr, CmdType cmdtype) {
        if (CmdType.POWEROFF.equals((Object)cmdtype) && retStr.toLowerCase(Locale.ENGLISH).contains(JUDGE_FAILE)) {
            LOGGER.info("{} execute cmd command failed retStr : {}", (Object)this.getNode().getIp(), (Object)retStr);
            return false;
        }
        return true;
    }

    private String handleCmd(String cmdStr) {
        if (StringUtils.isNULLStr(cmdStr)) {
            return null;
        }
        return MessageFormat.format(cmdStr, this.getNode().getIp(), this.getNode().getLoginUser().getUserName(), this.getNode().getLoginUser().getPassword(), this.getOemInfo().getDevPath());
    }

    public String executeCmd(String cmdStr, int timout) {
        try {
            return this.ssh.execCmdNoLogTimout(cmdStr, timout);
        }
        catch (ToolException e) {
            OemDataContext context = OemDataContext.getInstance();
            String errorMes = ResourceUtil.getString((String)"oem.error.execute.cli.cmd");
            context.setLastResult(this.node, false, errorMes);
            context.setDevRunState(this.node, RunType.FAILED);
            LOGGER.error("executeCmd: " + this.getNode().getIp() + " execute exception", (Throwable)e);
            return "";
        }
    }

    public String specialExecuteCmd(String cmdStr, int timout) throws ToolException {
        return this.ssh.execCmdNoLogTimout(cmdStr, timout);
    }

    public void setNode(DevNode node) {
        this.node = node;
    }

    public DevNode getNode() {
        return this.node;
    }

    public SftpTransporter getSftp() {
        return this.sftp;
    }

    public void setOemInfo(OemInfo oemInfo) {
        this.oemInfo = oemInfo;
    }

    public OemInfo getOemInfo() {
        return this.oemInfo;
    }

    public void detialCallBack(DevNode devNode) {
        OemUIContext.getInstance().uiCallBack(devNode);
    }

    public void setCmdType(CmdType cmdType) {
        this.cmdType = cmdType;
    }

    public CmdType getCmdType() {
        return this.cmdType;
    }
}

