/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.logic.task;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.logic.task.OemTask;
import com.huawei.ism.tool.oem.utils.CmdType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutor.class);
    private static final TaskExecutor INSTANCE = new TaskExecutor();
    private ExecutorService executor = Executors.newFixedThreadPool(10);

    private TaskExecutor() {
    }

    public static TaskExecutor getInstance() {
        return INSTANCE;
    }

    public void addTask(DevNode node, CmdType type, OemInfo oemInfo) {
        OemTask task = type.getTask();
        task.setNode(node);
        task.setOemInfo(oemInfo);
        task.init();
        LOGGER.info("task init success");
        this.executor.execute(task);
    }
}

