/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.oem.OemToolProvider;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OemNineMainWizard {
    private static final Logger log = LoggerFactory.getLogger(OemNineMainWizard.class);
    private static final String OEM_NINE_HANDLER_PATH = "config/oem/wizard/OemNineHandler.xml";
    private static final String OEM_NINE_FLOW_PATH = "config/oem/wizard/OemNineFlow.xml";
    private Window parent;

    public OemNineMainWizard(Window parent) {
        this.parent = parent;
        this.init();
    }

    private void init() {
        Locale locale = LanguageManager.getInstance().getCurrentLanguage();
        try (InputStream handlerStream = FileUtils.getStreamWithObj(OemToolProvider.class, (String)OEM_NINE_HANDLER_PATH);
             InputStream flowStream = FileUtils.getStreamWithObj(OemToolProvider.class, (String)OEM_NINE_FLOW_PATH);){
            FlowWizardDialog wizard = new FlowWizardDialog(this.parent, locale, OemToolProvider.class.getClassLoader(), handlerStream, flowStream, this.getHelpPath());
            UiMethod.putScreenCenter((Window)wizard);
            wizard.setIconImage(ResourceUtil.getImage((String)"oem.png").getImage());
            wizard.setVisible(true);
        }
        catch (IOException e) {
            log.error("load stream for :{},{} error", new Object[]{OEM_NINE_HANDLER_PATH, OEM_NINE_FLOW_PATH, e});
        }
    }

    private String getHelpPath() {
        StringBuffer sb = new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("help").append(File.separator).append("Oem");
        return sb.toString();
    }
}

