/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.flow.ui.IFlowUIState;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardState;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.logic.ParseOemCallable;
import com.huawei.ism.tool.oem.mass.wizard.GenerateImportAction;
import com.huawei.ism.tool.oem.mass.wizard.GenerateOemCardCreatePkgAction;
import com.huawei.ism.tool.oem.mass.wizard.GenerateOemLayout;
import com.huawei.ism.tool.oem.mass.wizard.GenerateSelectOemAction;
import com.huawei.ism.tool.oem.mass.wizard.ShowSupoortAction;
import com.huawei.ism.tool.oem.service.VersionHanler;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateOemCard
extends FlowWizardCard
implements VersionHanler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateOemCard.class);
    private static final Locale CURRENT_LOCAL = LanguageManager.getInstance().getCurrentLanguage();
    private static final String SELECT_OEMPACK_ID = "oem_select_import_id";
    private GenerateOemLayout layout;

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        OemDataContext context = OemDataContext.getInstance();
        OemMassCompress compress = context.getCurOem().getOemNineCompress();
        String productPath = compress.getFinalPath();
        String oemPath = compress.getOemPath();
        String originalPath = compress.getOriginalPkgPath();
        if (null == this.layout) {
            this.layout = new GenerateOemLayout(this.getParentWindow());
            this.initListener();
        }
        compress = context.getCurOem().getOemNineCompress();
        compress.setFinalPath(productPath);
        compress.setOemPath(oemPath);
        compress.setOriginalPkgPath(originalPath);
        for (OemInfo temp : context.getOemInfos()) {
            if (!temp.getPackName().equals(context.getCurOem().getPackName())) continue;
            temp.getOemNineCompress().setFinalPath(productPath);
            temp.getOemNineCompress().setOemPath(oemPath);
            temp.getOemNineCompress().setOriginalPkgPath(originalPath);
            break;
        }
        return true;
    }

    private void initListener() {
        this.layout.getInfoImportLink().addMouseListener((MouseListener)new GenerateImportAction(this));
        this.layout.getOemVersions().addItemListener(new GenerateSelectOemAction(this.layout));
        this.layout.getSuportDevLink().addMouseListener((MouseListener)new ShowSupoortAction());
        this.layout.getCreateBtn().addActionListener(new GenerateOemCardCreatePkgAction(super.getParentWindow(), this.layout));
    }

    public void selectImport() {
        try {
            String[] ext = new String[]{"tgz"};
            File selectFile = ToolFileChooser.selectFile((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"oem.tool.info.import.title"), (String[])ext, (String)SELECT_OEMPACK_ID, (String)"tgz", (int)0, (boolean)true, (Locale)CURRENT_LOCAL);
            if (null == selectFile || !selectFile.exists() || !OemDataContext.getInstance().checkFilepath(this.getParentWindow(), selectFile.getCanonicalPath())) {
                return;
            }
            List ret = AsyncExcutor.execute((Window)this.getParentWindow(), (Callable[])new Callable[]{new ParseOemCallable(selectFile, this.layout.getCreateInfo(), this, false)});
            OemUIContext oemUiContext = OemUIContext.getInstance();
            if (OemServiceImpl.DE_COMPRESS_ERROR.equals(ret.get(0))) {
                LOGGER.info("Import OEM package][Failed");
                DialogUtils.showInfoDialog((JDialog)oemUiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.deCompress.failed"));
            } else if (OemServiceImpl.VERSION_ERROR.equals(ret.get(0))) {
                LOGGER.info("Import OEM package][Failed");
                DialogUtils.showInfoDialog((JDialog)oemUiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.improt.failed"));
            } else if (OemServiceImpl.PARSE_OEM_FAILED.equals(ret.get(0))) {
                DialogUtils.showInfoDialog((JDialog)oemUiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.import.failed"));
                LOGGER.info("Import OEM package][Failed");
            } else if (OemServiceImpl.PARSE_OEM_SUCCESS.equals(ret.get(0))) {
                LOGGER.info("Import OEM package >> {}][Success", (Object)selectFile.getCanonicalPath());
                this.getParentWindow().pack();
            }
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
        }
    }

    public boolean ending() {
        return true;
    }

    public boolean flowExiting() {
        return OemDataContext.getInstance().isExitTool(this.getParentWindow());
    }

    protected IFlowUIState getInitUIState() {
        return FlowWizardState.LAST_STEP_FAILED;
    }

    @Override
    public void refreshSelectOem() {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo selectOemInfo = context.getCurOem();
        this.layout.getOemVersions().setSelectedItem(selectOemInfo.toString());
        OemDataContext.getInstance().getOptionName().clear();
    }
}

