/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.wizard;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.entity.SupportVersion;
import com.huawei.ism.tool.oem.logic.CreateOemCallable;
import com.huawei.ism.tool.oem.logic.OemNineProductCallable;
import com.huawei.ism.tool.oem.ui.layout.CreateOemInfoLayout;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;

public class GenerateOemLayout
extends FlowWizardCardLayout {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GenerateOemLayout.class);
    private static final Dimension SIZE = new Dimension(630, 530);
    private static final Dimension FIELD_SIZE = new Dimension(600, 25);
    private static final Dimension AREA_SIZE = new Dimension(600, 80);
    private static final Dimension CREATE_BTN_SIZE = new Dimension(80, 25);
    private ToolHyperLinkLabel infoImportLink = null;
    private ToolHyperLinkLabel suportDevLink = null;
    private JButton createBtn = null;
    private JComboBox<?> oemVersions = null;
    private CreateOemInfoLayout createInfo;
    private JPanel content;
    private Window parent;

    public GenerateOemLayout(Window parent) {
        this.parent = parent;
        this.initGenerateButton();
        this.initGenerateComponent();
    }

    private void initGenerateButton() {
        OemDataContext dataContext = OemDataContext.getInstance();
        List<OemInfo> allOemInfos = dataContext.getOemInfos();
        String[] supportArray = new String[allOemInfos.size()];
        for (int i = 0; i < allOemInfos.size(); ++i) {
            supportArray[i] = allOemInfos.get(i).toString();
        }
        this.infoImportLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"oem.tool.info.button.import"));
        this.oemVersions = new JComboBox<String>(supportArray);
        this.oemVersions.setSelectedItem(dataContext.getCurOem().toString());
        this.suportDevLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"oem.tool.info.button.suport"));
        this.createBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.generate"), (char)'G');
        UiMethod.setComponentSize((Dimension)CREATE_BTN_SIZE, (Component[])new Component[]{this.createBtn});
    }

    private void initGenerateComponent() {
        if (!(this.parent instanceof JDialog)) {
            LOGGER.info("layout of all components");
            return;
        }
        this.createInfo = new CreateOemInfoLayout((JDialog)this.parent);
        this.createInfo.setFieldSize(FIELD_SIZE);
        this.createInfo.setAreaSize(AREA_SIZE);
        this.createInfo.loadUI();
        JScrollPane layoutPane = new JScrollPane(this.createInfo);
        layoutPane.setVerticalScrollBarPolicy(22);
        layoutPane.setHorizontalScrollBarPolicy(31);
        JPanel generatePanel = new JPanel();
        generatePanel.setLayout(new BorderLayout());
        generatePanel.add(Box.createVerticalStrut(12));
        generatePanel.add((Component)this.layoutImportAndVerson(), "North");
        generatePanel.add((Component)layoutPane, "Center");
        generatePanel.add((Component)UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(1), UiMethod.buildCompsRight((int)12, (Component[])new Component[]{Box.createHorizontalGlue(), this.createBtn})}), "South");
        this.content = new JPanel();
        this.content.setLayout(new BorderLayout());
        this.content.add((Component)generatePanel, "Center");
        UiMethod.setComponentSize((Dimension)SIZE, (Component[])new Component[]{this.content});
        this.add(this.content);
    }

    private JComponent layoutImportAndVerson() {
        Box box = Box.createVerticalBox();
        Box importBox = Box.createHorizontalBox();
        JLabel descLabelA = new JLabel(ResourceUtil.getString((String)"oem.tool.info.suggestions.desc1"));
        JLabel descLabelB = new JLabel(ResourceUtil.getString((String)"oem.tool.info.suggestions.desc2"));
        importBox.add(descLabelA);
        importBox.add((Component)this.infoImportLink);
        importBox.add(descLabelB);
        importBox.setAlignmentX(0.0f);
        box.add(importBox);
        box.add(Box.createVerticalStrut(12));
        Map<String, SupportVersion> allVersion = OemDataContext.getInstance().getAllSupportVer();
        Box boxVersion = Box.createHorizontalBox();
        JLabel descLabelC = new JLabel(ResourceUtil.getString((String)"oem.tool.info.button.desc1"));
        boxVersion.add(descLabelC);
        boxVersion.add(this.oemVersions);
        if (!allVersion.isEmpty()) {
            boxVersion.add(Box.createHorizontalStrut(12));
            boxVersion.add((Component)this.suportDevLink);
            boxVersion.add(Box.createHorizontalStrut(120));
            boxVersion.setAlignmentX(0.0f);
        } else {
            boxVersion.add(Box.createHorizontalStrut(320));
            boxVersion.setAlignmentX(0.0f);
        }
        box.add(boxVersion);
        box.add(Box.createVerticalStrut(8));
        return box;
    }

    public boolean createOem() {
        if (!this.createInfo.checkData()) {
            return false;
        }
        OemInfo oemInfo = OemDataContext.getInstance().getCurOem();
        OemMassCompress compress = oemInfo.getOemNineCompress();
        OemNineProductCallable productCallable = new OemNineProductCallable();
        String oemPath = compress.getOemPath();
        List ret = AsyncExcutor.execute((Window)this.parent, (Callable[])new Callable[]{new CreateOemCallable(oemPath), productCallable});
        if (!this.handleResult(ret)) {
            File oemFile = new File(oemPath);
            if (oemFile.exists()) {
                FileUtils.deleteFile((File)oemFile);
            }
            return false;
        }
        return true;
    }

    public void refreshSelectOem() {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo selectOemInfo = context.getCurOem();
        this.oemVersions.setSelectedItem(selectOemInfo.toString());
    }

    private boolean handleResult(List<Object> result) {
        if (result == null || result.size() < 1) {
            LOGGER.info("create oem.tgz failed");
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"oem.tool.info.create.failed"));
            return false;
        }
        boolean isCreateOem = (Boolean)result.get(0);
        if (!isCreateOem) {
            LOGGER.info("create oem.tgz failed");
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"oem.tool.info.create.failed"));
            return false;
        }
        List createVerResult = (List)result.get(1);
        if (null == createVerResult) {
            LOGGER.info("execute result is null");
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"oem.tool.info.create.failed"));
            return false;
        }
        boolean isCreateVer = Boolean.valueOf(createVerResult.get(0).toString());
        String createVerRet = createVerResult.get(1).toString();
        if (!isCreateVer) {
            LOGGER.info("create product version pakcage failed");
            DialogUtils.showInfoDialog((Window)this.parent, (String)createVerRet);
            return false;
        }
        DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"oem.tool.info.create.success"));
        return true;
    }

    public ToolHyperLinkLabel getInfoImportLink() {
        return this.infoImportLink;
    }

    public ToolHyperLinkLabel getSuportDevLink() {
        return this.suportDevLink;
    }

    public JComboBox<?> getOemVersions() {
        return this.oemVersions;
    }

    public JButton getCreateBtn() {
        return this.createBtn;
    }

    public CreateOemInfoLayout getCreateInfo() {
        return this.createInfo;
    }
}

