/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.wizard;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.mass.wizard.GenerateOemLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class GenerateSelectOemAction
implements ItemListener {
    private GenerateOemLayout layout;

    public GenerateSelectOemAction(GenerateOemLayout layout) {
        this.layout = layout;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        String version = (String)event.getItem();
        OemDataContext context = OemDataContext.getInstance();
        OemMassCompress compress = context.getCurOem().getOemNineCompress();
        String productPath = compress.getProductVerPath();
        String oemPath = compress.getOemPath();
        String originalPath = compress.getOriginalPkgPath();
        String finalPath = compress.getFinalPath();
        OemInfo oemInfo = context.getOemInfoByOemVer(version);
        if (null == oemInfo) {
            ToolLoggerFactory.getLogger(this.getClass()).error("oemInfo is null.");
            throw new NullPointerException();
        }
        context.setCurOem(oemInfo);
        this.layout.getCreateInfo().refresh();
        context.getCurOem().getOemNineCompress().setProductVerPath(productPath);
        context.getCurOem().getOemNineCompress().setOemPath(oemPath);
        context.getCurOem().getOemNineCompress().setOriginalPkgPath(originalPath);
        context.getCurOem().getOemNineCompress().setFinalPath(finalPath);
    }
}

