/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.wizard;

import com.huawei.ism.tool.base.ui.wizard.FlowWizardCard;
import com.huawei.ism.tool.base.ui.wizard.FlowWizardCardLayout;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.mass.wizard.SelectCeneratePathLayout;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectCeneratePathCard
extends FlowWizardCard {
    private static final Logger log = LoggerFactory.getLogger(SelectCeneratePathCard.class);
    private static final long ONE_G_SIZE = 0x40000000L;
    private SelectCeneratePathLayout layout;

    protected FlowWizardCardLayout getLayout() {
        return this.layout;
    }

    protected boolean init() {
        if (null == this.layout) {
            this.layout = new SelectCeneratePathLayout(this.getParentWindow());
        }
        return true;
    }

    public boolean ending() {
        return this.checkSelectedFile();
    }

    public boolean flowExiting() {
        return OemDataContext.getInstance().isExitTool(this.getParentWindow());
    }

    private boolean checkSelectedFile() {
        if (StringUtils.isNULLStr((String)this.layout.getOemPath().getText())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.oem.remind"));
            return false;
        }
        if (StringUtils.isNULLStr((String)this.layout.getProductField().getText())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.version.remind"));
            return false;
        }
        if (StringUtils.isNULLStr((String)this.layout.getSelectOriPath().getText())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.original.remind"));
            return false;
        }
        if (!this.isCreateOemPackageDiskFreeSpaceEnough(this.layout.getProductField().getText(), this.layout.getSelectOriPath().getText())) {
            DialogUtils.showInfoDialog((Window)this.getParentWindow(), (String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.diskfreespace.notenough"));
            return false;
        }
        return true;
    }

    private boolean isCreateOemPackageDiskFreeSpaceEnough(String createDirPath, String originFilePath) {
        long sourcePackageSize = new File(FilePathUtils.checkFile((String)originFilePath)).length();
        long createOemPackageNeedSpace = 0x40000000L + sourcePackageSize;
        long createOemPackageDiskFreeSpace = new File(FilePathUtils.checkFile((String)createDirPath)).getFreeSpace();
        log.info("NeedSpace:{}, DiskFreeSpace: {}", (Object)createOemPackageNeedSpace, (Object)createOemPackageDiskFreeSpace);
        return createOemPackageNeedSpace <= createOemPackageDiskFreeSpace;
    }
}

