/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.mass.wizard;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.OemMassCompress;
import com.huawei.ism.tool.oem.mass.wizard.SelectCeneratePathLayout;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTextField;
import org.slf4j.LoggerFactory;

public class SelectOriListener
implements ActionListener {
    private static final String TAR_GZ = ".tar.gz";
    private static final String ZIP = ".zip";
    private static final String TGZ = ".tgz";
    private static String[] suffixs = new String[]{".tar.gz", ".zip", ".tgz"};
    private static final String SELECTFILE_ORI_DEFAULT_ID = "oem_mass_select_original_packages_path";
    private JTextField selectOriPath;
    private Window parent;
    private List<String> currOriPkgType = new LinkedList<String>();

    public SelectOriListener(Window parent, JTextField selectOriPath) {
        this.selectOriPath = selectOriPath;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File originalfile = this.createChoosenFile();
        if (originalfile == null) {
            return;
        }
        String oripath = "";
        try {
            oripath = originalfile.getCanonicalPath();
        }
        catch (IOException e1) {
            LoggerFactory.getLogger(SelectCeneratePathLayout.class).error("get oripath fialed.");
        }
        if (this.checkInputFileType(oripath)) {
            this.selectOriPath.setText(oripath);
        } else {
            DialogUtils.showInfoDialog((Window)this.parent, (String)ResourceUtil.getString((String)"oem.mass.wizard.selectpath.oripath.filetypefail"));
        }
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.getCurOem();
        OemMassCompress compress = oemInfo.getOemNineCompress();
        compress.setOriginalPkgPath(oripath);
        LoggerFactory.getLogger(SelectCeneratePathLayout.class).info("Save originalPkgPath path >> " + oripath + "][Success");
    }

    private boolean checkInputFileType(String oripath) {
        for (String target : this.currOriPkgType) {
            if (!oripath.endsWith(target)) continue;
            return true;
        }
        return false;
    }

    private File createChoosenFile() {
        StringBuilder suffixDes = new StringBuilder();
        for (String suffix : suffixs) {
            this.currOriPkgType.add(suffix);
            suffixDes.append("*").append(suffix).append(";");
        }
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("title", ResourceUtil.getString((String)"oem.mass.wizard.selectpath.oripath.title"));
        extParams.put("PathId", SELECTFILE_ORI_DEFAULT_ID);
        extParams.put("description", suffixDes.toString());
        return ToolFileChooser.selectFile(this.parent, suffixs, 0, true, extParams);
    }
}

