/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.service.impl;

import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.utils.NetUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeNodeSettingService {
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeSettingService.class);
    private static final ComputeNodeSettingService INSTANCE = new ComputeNodeSettingService();
    private static final int PORT = 22;
    private Map<String, List<MultiRouteNode>> storageOsmNodesMap = new HashMap<String, List<MultiRouteNode>>();
    private Map<String, List<MultiRouteNode>> storageFcNodesMap = new HashMap<String, List<MultiRouteNode>>();

    public static ComputeNodeSettingService getInstance() {
        return INSTANCE;
    }

    public List<MultiRouteNode> getOsmNodesByIp(String ip) {
        if (this.storageOsmNodesMap.containsKey(ip)) {
            return this.storageOsmNodesMap.get(ip);
        }
        return Collections.emptyList();
    }

    public List<MultiRouteNode> getFcNodesByIp(String ip) {
        if (this.storageFcNodesMap.containsKey(ip)) {
            return this.storageFcNodesMap.get(ip);
        }
        return Collections.emptyList();
    }

    public void saveOsmNodes(String ip, List<MultiRouteNode> osmNodes) {
        this.storageOsmNodesMap.put(ip, osmNodes);
    }

    public void saveFcNodes(String ip, List<MultiRouteNode> fcNodes) {
        this.storageFcNodesMap.put(ip, fcNodes);
    }

    public boolean isSftpCanConnected(String ip, int port, int timeout) {
        if (ip == null || "".equals(ip)) {
            log.error("the param is empty");
            return false;
        }
        return NetUtil.isPortCanReach(ip, port > 0 ? port : 22, timeout);
    }
}

