/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.service.impl;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.FileList;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.logic.handler.HandleReplaceVal;
import com.huawei.ism.tool.oem.service.HandleFileService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HandleAbstracter
implements HandleFileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandleAbstracter.class);
    private static final String WORK_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String UN_ZIP_TEMP = WORK_PATH + File.separator + "temp" + File.separator + "importOem";
    private OemInfo oemInfo;
    private FileItem fileItem;
    private FileList fileList;
    private String path;

    public String replaceQuoteVal(String text, String quote) {
        HandleReplaceVal hrv = new HandleReplaceVal(this.oemInfo);
        return hrv.getReplaceVal(text, quote);
    }

    public String getFileMessage(String pathAndName) {
        String fileMessage = null;
        File readFile = new File(UN_ZIP_TEMP + File.separator + pathAndName);
        try {
            fileMessage = StreamUtils.readStringFormFile((File)readFile);
        }
        catch (Exception e) {
            LOGGER.error("readTextFile read error!", (Throwable)e);
        }
        return fileMessage;
    }

    public String getUnZipTemp() {
        return UN_ZIP_TEMP;
    }

    public OemInfo getOemInfo() {
        return this.oemInfo;
    }

    public void setOemInfo(OemInfo oemInfo) {
        this.oemInfo = oemInfo;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public void setFileItem(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setFileList(FileList fileList) {
        this.fileList = fileList;
    }

    public FileList getFileList() {
        return this.fileList;
    }

    public String getFileMessage(String pathAndName, String packageName) {
        File readFile = new File(String.join((CharSequence)File.separator, UN_ZIP_TEMP, packageName, pathAndName));
        return StreamUtils.readStringFormFile((File)readFile);
    }
}

