/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.service.impl;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.conf.ComputeStorageOemInfoParser;
import com.huawei.ism.tool.oem.conf.OemInfoParser;
import com.huawei.ism.tool.oem.conf.ResourceParser;
import com.huawei.ism.tool.oem.conf.SupportParser;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.FileList;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.service.OemService;
import com.huawei.ism.tool.oem.service.impl.HandleAbstracter;
import com.huawei.ism.tool.oem.service.impl.RunAddTask;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.FileType;
import com.huawei.ism.tool.oem.utils.HandleType;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.tool.oem.utils.RunType;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.FileChannelImpl;

public class OemServiceImpl
implements OemService {
    private static final Logger log = LoggerFactory.getLogger(OemServiceImpl.class);
    public static final Integer PARSE_OEM_FAILED = -1;
    public static final Integer PARSE_OEM_SUCCESS = 0;
    public static final Integer DE_COMPRESS_ERROR = 1;
    public static final Integer VERSION_ERROR = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(OemServiceImpl.class);
    private static final String WORK_PATH = ApplicationContext.getInstance().getWorkPath();
    private static final String PRODUCT = "products.xml";
    private static final String OEM_MARK_FILE_NAME = "tool.ini";
    private static final String OEM_MARK_NAME = "oem.version";
    private String localPath;

    @Override
    public void loadPkgs() {
        List<File> allPackage = this.analyAllPackages();
        List<OemInfo> oemInfos = OemDataContext.getInstance().getOemInfos();
        allPackage.forEach(curPackage -> {
            OemInfo oemInfo = new OemInfo();
            if (!this.parseOneProduct((File)curPackage, oemInfo)) {
                LOGGER.info("{} not satisfied product storage.", (Object)curPackage.getName());
                return;
            }
            oemInfo.setPackName(curPackage.getName());
            ResourceParser resourcePar = new ResourceParser((File)curPackage);
            oemInfo.setResourceParser(resourcePar);
            if (!this.parseOneOemConfig((File)curPackage, oemInfo)) {
                return;
            }
            oemInfos.add(oemInfo);
        });
    }

    private List<File> analyAllPackages() {
        File packages = new File(this.getPackagePath());
        File[] files = packages.listFiles();
        if (!packages.exists() || !packages.isDirectory() || null == files) {
            return new ArrayList<File>();
        }
        return Arrays.asList(files);
    }

    private String getPackagePath() {
        StringBuilder pathSb = new StringBuilder().append(WORK_PATH).append(File.separator).append("packages").append(File.separator).append("products");
        if (OemDataContext.getInstance().isUnifiedVer()) {
            pathSb.append(File.separator).append("unified");
        } else if (OemDataContext.getInstance().isMassVer()) {
            pathSb.append(File.separator).append("mass");
        }
        return pathSb.toString();
    }

    private boolean parseOneOemConfig(File pack, OemInfo oemInfo) {
        if (!pack.exists() || !pack.isDirectory()) {
            return false;
        }
        try {
            if (OemConstants.isComputeStorageOemInfo(oemInfo)) {
                ComputeStorageOemInfoParser cliParser = new ComputeStorageOemInfoParser(pack.getCanonicalPath(), oemInfo);
                return cliParser.parse();
            }
            OemInfoParser cliParser = new OemInfoParser(pack.getCanonicalPath(), oemInfo);
            return cliParser.parse();
        }
        catch (IOException e) {
            LOGGER.info("get path error.");
            return false;
        }
    }

    private boolean parseOneProduct(File pack, OemInfo oemInfo) {
        if (!pack.exists() || !pack.isDirectory()) {
            return false;
        }
        try {
            String productPath = pack.getCanonicalPath() + File.separator + PRODUCT;
            SupportParser parser = new SupportParser(productPath, oemInfo);
            return parser.parseProduct();
        }
        catch (IOException e) {
            log.error("parse product :{} error", (Object)PRODUCT, (Object)e);
            return false;
        }
    }

    @Override
    public void startTask(List<DevNode> nodes, CmdType cmdType) {
        for (DevNode node : nodes) {
            CmdType type = cmdType;
            OemInfo curOem = OemDataContext.getInstance().getOemInfoByDev(node.getProductVersion(), node.getDeviceType());
            if (null == curOem) {
                LOGGER.error("curOem is null.");
                throw new NullPointerException();
            }
            curOem.setLocPath(this.localPath);
            OemDataContext context = OemDataContext.getInstance();
            context.setDevRunState(node, RunType.RUNING);
            context.setCmdType(cmdType);
            context.clearDevExeResult(node);
            this.setStart(context, cmdType, node);
            OemUIContext.getInstance().uiCallBack(node);
            SwingUtilities.invokeLater(new RunAddTask(node, type, curOem));
        }
    }

    private void setStart(OemDataContext context, CmdType cmdType, DevNode node) {
        if (CmdType.ROLLBACK.equals((Object)cmdType)) {
            context.addNewResult(node, ResourceUtil.getString((String)"oem.tool.execute.rollback.prepare"));
        } else if (CmdType.IMPORTOEM.equals((Object)cmdType)) {
            context.addNewResult(node, ResourceUtil.getString((String)"oem.tool.execute.import.prepare"));
        } else if (CmdType.POWEROFF.equals((Object)cmdType)) {
            context.addNewResult(node, ResourceUtil.getString((String)"oem.tool.execute.poweroff.prepare"));
        } else {
            LOGGER.info("cmdType is not support!");
        }
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    @Override
    public OemInfo loadPkg(File pkg) {
        OemInfo oemInfo = new OemInfo();
        if (!this.parseOneProduct(pkg, oemInfo)) {
            LOGGER.info("{} not satisfied product storage.", (Object)pkg.getName());
            return null;
        }
        oemInfo.setPackName(pkg.getName());
        ResourceParser resourcePar = new ResourceParser(pkg);
        oemInfo.setResourceParser(resourcePar);
        if (!this.parseOneOemConfig(pkg, oemInfo)) {
            LOGGER.info("parse one oem config failed");
        }
        return oemInfo;
    }

    @Override
    public boolean createOem(OemInfo oemInfo, String path) {
        File oemFile = new File(path);
        if (oemFile.exists()) {
            FileUtils.deleteFile((File)oemFile);
        }
        FileUtils.createDir((File)oemFile);
        if (!oemFile.exists()) {
            LOGGER.info("create {} failed!", (Object)oemFile);
            return false;
        }
        if (OemConstants.isComputeStorageOemInfo(oemInfo)) {
            return this.createComputeStorsgeOem(oemInfo, path);
        }
        if (OemConstants.isComputeStorageOemFcvInfo(oemInfo)) {
            return this.createComputeStorageOemFcvOem(oemInfo, path);
        }
        if (OemConstants.isComputeStorageOemStorageInfo(oemInfo)) {
            return this.createStorageOem(oemInfo, path);
        }
        if (!(this.createFileAboutFileItem(oemInfo, path) && this.createFileAboutFileList(oemInfo, path) && this.createCheckFile(oemInfo, path))) {
            return false;
        }
        this.createMarkFile(path);
        return true;
    }

    private boolean creatOemFile(OemInfo oemInfo, String path, String packageName) {
        if (!this.createFileAboutFileItem(oemInfo, path) || !this.createCheckFile(oemInfo, path)) {
            return false;
        }
        this.createMarkFile(path);
        String suffix = packageName.equals("FC_OEM") ? ".zip" : ".tgz";
        return this.creatOemCompressPackage(path, suffix);
    }

    private boolean creatOemCompressPackage(String path, String suffix) {
        File sourFile = new File(path);
        File[] allFiles = sourFile.listFiles();
        if (allFiles == null) {
            return false;
        }
        String[] fileNames = new String[allFiles.length];
        try {
            boolean isSuc;
            for (int i = 0; i < allFiles.length; ++i) {
                fileNames[i] = allFiles[i].getCanonicalPath();
            }
            String tgzFile = path + suffix;
            boolean bl = isSuc = suffix.equals(".tgz") ? FileAssistant.compressTgzFile(tgzFile, fileNames) : FileAssistant.compressFileZip(tgzFile, fileNames);
            if (!isSuc) {
                FileUtils.deleteFile((File)sourFile);
                return false;
            }
            FileUtils.deleteFile((File)sourFile);
            FileUtils.setFilePermissions((String)tgzFile);
        }
        catch (IOException e) {
            log.error("get file name failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean createComputeStorsgeOem(OemInfo oemInfo, String path) {
        return this.createFcvOem(oemInfo, path) && this.createStorageOem(oemInfo, path) && this.createFcOem(oemInfo, path);
    }

    private boolean createStorageOem(OemInfo oemInfo, String path) {
        return this.creatOemFile(oemInfo, this.getOemFilePath(path, "Storage_OEM"), "Storage_OEM");
    }

    private String getOemFilePath(String path, String name) {
        return path + File.separator + name;
    }

    private boolean createFcOem(OemInfo oemInfo, String path) {
        return this.creatOemFile(oemInfo.getFcOemInfo(), this.getOemFilePath(path, "FC_OEM"), "FC_OEM");
    }

    private boolean createFcvOem(OemInfo oemInfo, String path) {
        return this.creatOemFile(oemInfo.getFcvOemInfo(), this.getOemFilePath(path, "FCV_OEM"), "FCV_OEM");
    }

    private boolean createComputeStorageOemFcvOem(OemInfo oemInfo, String path) {
        return this.creatOemFile(oemInfo, this.getOemFilePath(path, "FCV_OEM"), "FCV_OEM");
    }

    private boolean createFileAboutFileItem(OemInfo oemInfo, String path) {
        List<FileItem> infoLists = oemInfo.getInfoList();
        return this.createFileItem(oemInfo, infoLists, path);
    }

    private boolean createFileAboutFileList(OemInfo oemInfo, String path) {
        List<FileList> fileLists = oemInfo.getAllFileList();
        for (FileList fileList : fileLists) {
            List<FileItem> fileItems = fileList.getChildItem();
            this.createFileItem(oemInfo, fileItems, path);
            String fileListName = fileList.getFileName();
            String fileListType = fileListName.substring(fileListName.lastIndexOf(".") + 1).toUpperCase(Locale.ENGLISH);
            HandleAbstracter server = HandleType.valueOf(fileListType).getHandler();
            server.setFileList(fileList);
            server.setPath(path);
            if (server.createFile()) continue;
            return false;
        }
        return true;
    }

    private boolean createFileItem(OemInfo oemInfo, List<FileItem> infoLists, String path) {
        HandleAbstracter service = null;
        String type = "";
        for (FileItem fileItem : infoLists) {
            FileType fileType = fileItem.getFileType();
            if (FileType.IMAGE.equals((Object)fileType)) {
                type = "IMAGE";
            } else if (FileType.TEXT.equals((Object)fileType)) {
                String fileName = fileItem.getFileName();
                type = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase(Locale.ENGLISH);
            } else {
                LOGGER.info("unSupport's file type");
                continue;
            }
            service = HandleType.valueOf(type).getHandler();
            service.setFileItem(fileItem);
            service.setOemInfo(oemInfo);
            service.setPath(path);
            if (service.createFile()) continue;
            return false;
        }
        return true;
    }

    private boolean createCheckFile(OemInfo oemInfo, String path) {
        String checkFileName = oemInfo.getCheckfilename();
        String algorithm = oemInfo.getAlgorithm();
        if (StringUtils.isNULLStr(checkFileName) || StringUtils.isNULLStr(algorithm)) {
            LOGGER.info("lack of attribute checkfileName or algorithm!");
            return true;
        }
        File oemFile = new File(path);
        if (!oemFile.exists()) {
            LOGGER.info("oem files can't fined!");
            return false;
        }
        String handleStr = path.replace("\\", "/");
        String context = this.getCheckContext(oemFile, algorithm, handleStr);
        String checkFilePath = path + File.separator + checkFileName;
        File checkFile = new File(checkFilePath);
        String parentPath = checkFile.getParent();
        if (!new File(parentPath).exists()) {
            FileUtils.createDir((String)parentPath);
        }
        try {
            StreamUtils.writeInfo2File((byte[])context.getBytes("utf-8"), (String)checkFilePath);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("create check file failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private String getCheckContext(File oemFile, String algorithm, String path) {
        StringBuilder context = new StringBuilder();
        if (oemFile.isDirectory()) {
            File[] childFiles = oemFile.listFiles();
            if (null == childFiles || childFiles.length == 0) {
                return "";
            }
            for (File childFile : childFiles) {
                String checkVal = this.getCheckContext(childFile, algorithm, path);
                context.append(checkVal);
            }
        } else {
            try {
                String curPath = oemFile.getCanonicalPath().replace("\\", "/");
                String relativePath = curPath.replace(path, "");
                context.append(this.createCheckNum(oemFile, algorithm));
                context.append(" .");
                context.append(relativePath);
                context.append(OemConstants.LINE_SEPARATOR);
            }
            catch (IOException e) {
                log.error("get path of oemFile :{} error occurred", (Object)oemFile.getName(), (Object)e);
            }
        }
        return context.toString();
    }

    /*
     * Exception decompiling
     */
    private String createCheckNum(File oemFile, String algorithm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void createMarkFile(String path) {
        String selectOem = OemDataContext.getInstance().getCurOem().getPackName();
        String markMes = "oem.version = " + selectOem;
        String filePath = path + File.separator + OEM_MARK_FILE_NAME;
        StreamUtils.writeInfo2File((byte[])markMes.getBytes(StandardCharsets.UTF_8), (String)filePath);
    }

    @Override
    public boolean importOemPack(File zipFilePath) {
        OemUIContext uiContext = OemUIContext.getInstance();
        OemDataContext dataContext = OemDataContext.getInstance();
        OemInfo oemInfo = dataContext.getCurOem();
        uiContext.reSelectOem();
        this.readFileToOemInfo(oemInfo);
        dataContext.setCurOem(oemInfo);
        return true;
    }

    private void readFileToOemInfo(OemInfo oemInfo) {
        if (OemConstants.isComputeStorageOemInfo(oemInfo)) {
            this.readFileToOemInfoByComputeStorage(oemInfo);
            return;
        }
        if (OemConstants.isComputeStorageOemFcvInfo(oemInfo)) {
            this.readFileToOemNodeInfo(oemInfo, "FCV_OEM");
            return;
        }
        if (OemConstants.isComputeStorageOemStorageInfo(oemInfo)) {
            this.readFileToOemNodeInfo(oemInfo, "Storage_OEM");
            return;
        }
        List<FileItem> allFileItem = oemInfo.getInfoList();
        List<FileList> allFileList = oemInfo.getAllFileList();
        this.readFileItem(allFileItem, "");
        this.readFileList(allFileList);
    }

    private void readFileToOemInfoByComputeStorage(OemInfo oemInfo) {
        this.readFileToOemNodeInfo(oemInfo.getFcvOemInfo(), "FCV_OEM");
        this.readFileToOemNodeInfo(oemInfo.getFcOemInfo(), "FC_OEM");
        this.readFileToOemNodeInfo(oemInfo, "Storage_OEM");
    }

    private void readFileToOemNodeInfo(OemInfo oemInfo, String packageName) {
        List<FileItem> allFileItem = oemInfo.getInfoList();
        this.readFileItem(allFileItem, packageName);
    }

    private void readFileItem(List<FileItem> allFileItem, String packageName) {
        HandleAbstracter service = null;
        String type = "";
        for (FileItem fileItem : allFileItem) {
            FileType fileType = fileItem.getFileType();
            if (FileType.TEXT.equals((Object)fileType)) {
                String fileName = fileItem.getFileName();
                type = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase(Locale.ENGLISH);
            } else if (FileType.IMAGE.equals((Object)fileType)) {
                type = "IMAGE";
            }
            fileItem.setPackageName(packageName);
            service = HandleType.valueOf(type).getHandler();
            service.setFileItem(fileItem);
            service.readFile();
        }
    }

    private void readFileList(List<FileList> allFileList) {
        HandleAbstracter service = null;
        String type = "";
        for (FileList fileList : allFileList) {
            String fileName = fileList.getFileName();
            type = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase(Locale.ENGLISH);
            service = HandleType.valueOf(type).getHandler();
            service.setFileList(fileList);
            service.readFile();
            List<FileItem> allFileItem = fileList.getChildItem();
            this.readFileItem(allFileItem, "");
        }
    }

    private void cleanMappedByteBuffer(MappedByteBuffer byteBuffer) {
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("unmap", MappedByteBuffer.class);
            method.setAccessible(true);
            method.invoke(FileChannelImpl.class, byteBuffer);
            method.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error("close file chanel failed!", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("close file chanel failed!", (Throwable)e);
        }
    }
}

