/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.oem.service.impl.ComputeNodeSettingService;
import com.huawei.ism.tool.oem.ui.layout.ComputeNodeSettingLayout;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeNodeSettiingDialog
extends PublicDialog {
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeSettiingDialog.class);
    private ComputeNodeSettingLayout layout;
    private DevNode devNode;

    public ComputeNodeSettiingDialog(JFrame parent, DevNode devNode) {
        super(parent);
        this.devNode = devNode;
        this.initUI();
    }

    private void initUI() {
        this.initComponent();
        this.okButtonListener();
        this.setSize(550, 600);
        this.setTitle(ResourceUtil.getString((String)"oem.tool.compute.node.setting.title"));
        this.setModal(true);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initComponent() {
        this.layout = new ComputeNodeSettingLayout(this, this.devNode);
        JScrollPane osmLayoutPane = new JScrollPane(this.layout);
        osmLayoutPane.setVerticalScrollBarPolicy(22);
        osmLayoutPane.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(Box.createVerticalStrut(12));
        panel.add(osmLayoutPane);
        JPanel content = this.getContentPanel();
        content.setLayout(new BorderLayout());
        content.add(Box.createHorizontalStrut(12), "West");
        content.add(Box.createHorizontalStrut(12), "East");
        content.add(Box.createVerticalStrut(12), "North");
        content.add(Box.createVerticalStrut(12), "South");
        content.add((Component)panel, "Center");
    }

    private void okButtonListener() {
        JButton okBtn = this.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                log.info("The customer clicks to confirm the node information.");
                ComputeNodeSettiingDialog.this.layout.clearosmTableEdit();
                ComputeNodeSettiingDialog.this.layout.clearFcTableEdit();
                if (ComputeNodeSettiingDialog.this.layout.saveCurRouteNodes()) {
                    ComputeNodeSettingService.getInstance().saveFcNodes(ComputeNodeSettiingDialog.this.devNode.getIp(), ComputeNodeSettiingDialog.this.layout.getFcNodes());
                    ComputeNodeSettingService.getInstance().saveOsmNodes(ComputeNodeSettiingDialog.this.devNode.getIp(), ComputeNodeSettiingDialog.this.layout.getOsmNodes());
                    ComputeNodeSettiingDialog.this.dispose();
                }
            }
        });
    }
}

