/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.entity.SupportVersion;
import com.huawei.ism.tool.oem.logic.CreateOemCallable;
import com.huawei.ism.tool.oem.logic.ParseOemCallable;
import com.huawei.ism.tool.oem.service.VersionHanler;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.tool.oem.ui.CreateOemAction;
import com.huawei.ism.tool.oem.ui.ImportAction;
import com.huawei.ism.tool.oem.ui.layout.CreateOemInfoLayout;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class CreateOemInfoDialog
extends PublicDialog
implements VersionHanler {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateOemInfoDialog.class);
    private static final String SELECTFILE_DEFAULT_ID = "oem_select_create_id";
    private static final String SELECT_OEMPACK_ID = "oem_select_import_id";
    private static final Dimension FIELD_ROW_SIZE = new Dimension(733, 25);
    private static final Dimension AREA_ROW_SIZE = new Dimension(733, 100);
    private static final Dimension SIZE = new Dimension(800, 550);
    private static final Locale CURRENT_LOCAL = LanguageManager.getInstance().getCurrentLanguage();
    private static final Dimension MV_DIMENSION = new Dimension(150, 23);
    private ToolHyperLinkLabel infoImportLink = null;
    private JComboBox<String> productModel = null;
    private JComboBox<String> productVersion = null;
    private JComboBox<String> typeSelector = null;
    private CreateOemInfoLayout layout;
    private Map<String, List<String>> modelVersion = OemDataContext.getInstance().getModelVersion();
    private Map<String, List<String>> modelOemTypes = OemDataContext.getInstance().getModelOemType();
    private Map<String, String> mvOem = new HashMap<String, String>();

    public CreateOemInfoDialog(JFrame parent) {
        super(parent);
        this.initUI();
        this.initListener();
        this.initOemPanel();
    }

    private void initOemPanel() {
        String model = this.productModel.getSelectedItem().toString();
        String version = this.productVersion.getSelectedItem().toString();
        this.layout.setProductVersion(version);
        OemDataContext context = OemDataContext.getInstance();
        List<OemInfo> oemInfos = context.getOemInfos();
        int initOemIndex = 0;
        block0: for (int index = 0; index < oemInfos.size(); ++index) {
            List<SupportVersion> supportVers = oemInfos.get(index).getSupportVers();
            for (SupportVersion supportVer : supportVers) {
                if (!supportVer.getModel().equals(model) || !supportVer.getShowVersion().contains(version)) continue;
                initOemIndex = index;
                continue block0;
            }
        }
        context.setCurOem(oemInfos.get(initOemIndex));
        this.layout.refresh();
    }

    private void initUI() {
        this.initButton();
        this.initComponent();
        this.setTitle(ResourceUtil.getString((String)"oem.tool.info.title"));
        this.setPreferredSize(SIZE);
        this.pack();
        this.setModal(true);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void initButton() {
        OemDataContext.getInstance().getOemInfos().forEach(this::initDataMap);
        this.infoImportLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"oem.tool.info.button.import"));
        Object[] modelArray = this.modelVersion.keySet().toArray(new String[0]);
        Arrays.sort(modelArray);
        this.productModel = new JComboBox<Object>(modelArray);
        this.productModel.setPreferredSize(MV_DIMENSION);
        this.productModel.setMaximumSize(MV_DIMENSION);
        this.productModel.setMinimumSize(MV_DIMENSION);
        String[] versionArray = this.modelVersion.get(this.productModel.getSelectedItem()).toArray(new String[0]);
        this.productVersion = new JComboBox<String>(CreateOemInfoDialog.dealArray(versionArray));
        this.productVersion.setPreferredSize(MV_DIMENSION);
        this.productVersion.setMaximumSize(MV_DIMENSION);
        this.productVersion.setMinimumSize(MV_DIMENSION);
        String[] typeArray = this.modelOemTypes.get(this.productModel.getSelectedItem()).toArray(new String[0]);
        this.typeSelector = new JComboBox<String>(typeArray);
        this.typeSelector.setPreferredSize(MV_DIMENSION);
        this.typeSelector.setMaximumSize(MV_DIMENSION);
        this.typeSelector.setMinimumSize(MV_DIMENSION);
    }

    private void initDataMap(OemInfo oemInfo) {
        String oemInfoIndexKey = oemInfo.getIndexKey();
        oemInfo.getSupportVers().forEach(supportVersion -> this.initModel2VerMap(oemInfoIndexKey, (SupportVersion)supportVersion));
    }

    private void initModel2VerMap(String oemInfoIndexKey, SupportVersion supportVersion) {
        supportVersion.getShowVersion().stream().map(supportVersion::getVerIndexKey).forEach(indexKey -> this.mvOem.put((String)indexKey, oemInfoIndexKey));
    }

    private void initComponent() {
        this.layout = new CreateOemInfoLayout((JDialog)((Object)this));
        this.layout.setFieldSize(FIELD_ROW_SIZE);
        this.layout.setAreaSize(AREA_ROW_SIZE);
        Object versionObj = this.productVersion.getSelectedItem();
        if (versionObj != null) {
            this.layout.setProductVersion(versionObj.toString());
        }
        this.layout.loadUI();
        JScrollPane layoutPane = new JScrollPane(this.layout);
        layoutPane.setVerticalScrollBarPolicy(22);
        layoutPane.setHorizontalScrollBarPolicy(31);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(Box.createVerticalStrut(12));
        panel.add((Component)this.layoutImportAndVerson(), "North");
        panel.add(layoutPane);
        JPanel content = this.getContentPanel();
        content.setLayout(new BorderLayout());
        content.add(Box.createHorizontalStrut(12), "West");
        content.add(Box.createHorizontalStrut(12), "East");
        content.add(Box.createVerticalStrut(12), "North");
        content.add(Box.createVerticalStrut(12), "South");
        content.add((Component)panel, "Center");
    }

    private JComponent layoutImportAndVerson() {
        Box box = Box.createVerticalBox();
        Box boxImport = Box.createHorizontalBox();
        JLabel descLabelA = new JLabel(ResourceUtil.getString((String)"oem.tool.info.suggestions.desc1"));
        JLabel descLabelB = new JLabel(ResourceUtil.getString((String)"oem.tool.info.suggestions.desc2"));
        boxImport.add(descLabelA);
        boxImport.add((Component)this.infoImportLink);
        boxImport.add(descLabelB);
        boxImport.setAlignmentX(0.0f);
        box.add(boxImport);
        box.add(Box.createVerticalStrut(12));
        Box boxVersion = Box.createHorizontalBox();
        JLabel descLabelC = new JLabel(ResourceUtil.getString((String)"oem.tool.info.button.desc1"));
        JLabel descLabelD = new JLabel(ResourceUtil.getString((String)"oem.tool.info.button.desc2"));
        JLabel descLabelE = new JLabel(ResourceUtil.getString((String)"oem.tool.info.button.desc3"));
        boxVersion.add(descLabelC);
        boxVersion.add(this.productModel);
        boxVersion.add(this.getBlankLabel(60, 20));
        boxVersion.add(descLabelD);
        boxVersion.add(this.productVersion);
        boxVersion.add(this.getBlankLabel(60, 20));
        boxVersion.add(descLabelE);
        boxVersion.add(this.typeSelector);
        boxVersion.add(Box.createHorizontalStrut(12));
        boxVersion.add(Box.createHorizontalStrut(120));
        boxVersion.setAlignmentX(0.0f);
        box.add(boxVersion);
        box.add(Box.createVerticalStrut(8));
        return box;
    }

    @NotNull
    private JLabel getBlankLabel(int width, int height) {
        JLabel jLabel = new JLabel();
        Dimension dimension = new Dimension(width, height);
        jLabel.setPreferredSize(dimension);
        jLabel.setMaximumSize(dimension);
        jLabel.setMinimumSize(dimension);
        return jLabel;
    }

    private void initListener() {
        this.infoImportLink.addMouseListener((MouseListener)new ImportAction(this));
        this.okBtn.addActionListener(new CreateOemAction(this));
        this.productModelItemListener();
        this.productVersionItemListener();
        this.typeSelectorItemListener();
    }

    private void productModelItemListener() {
        this.productModel.addItemListener(e -> {
            String model = this.productModel.getSelectedItem().toString();
            String[] versionsAll = this.modelVersion.get(model).toArray(new String[0]);
            String[] versions = CreateOemInfoDialog.dealArray(versionsAll);
            this.productVersion.removeAllItems();
            for (String version : versions) {
                this.productVersion.addItem(version);
            }
            this.typeSelector.removeAllItems();
            this.modelOemTypes.get(model).forEach(this.typeSelector::addItem);
        });
    }

    private void productVersionItemListener() {
        this.productVersion.addItemListener(e -> {
            String model = this.productModel.getSelectedItem().toString();
            LOGGER.info("the productVersion changed.");
            Object versionObj = this.productVersion.getSelectedItem();
            if (versionObj != null) {
                String oem = this.mvOem.get(model + "-" + versionObj.toString());
                OemDataContext context = OemDataContext.getInstance();
                OemInfo curOemInfo = context.getOemInfoByOemVer(oem);
                context.setCurOem(curOemInfo);
                this.layout.setProductVersion(versionObj.toString());
                Object type = this.typeSelector.getSelectedItem();
                if (this.computeStorageCanRefreshByType(model, curOemInfo, type)) {
                    this.layout.refreshByType(type.toString());
                } else {
                    this.layout.refresh();
                }
            } else {
                this.layout.setProductVersion(ResourceUtil.getString((String)"oem.tool.info.button.desc2.default"));
            }
        });
    }

    private boolean computeStorageCanRefreshByType(String model, OemInfo curOemInfo, Object type) {
        return Products.OCEAN_STOR_COMPUTING_DEVS.contains(model) && Objects.nonNull(curOemInfo) && Objects.nonNull(type);
    }

    private void typeSelectorItemListener() {
        this.typeSelector.addItemListener(e -> {
            Object versionObj = this.productVersion.getSelectedItem();
            if (versionObj == null) {
                return;
            }
            String model = this.productModel.getSelectedItem().toString();
            OemDataContext context = OemDataContext.getInstance();
            OemInfo curOemInfo = context.getOemInfoByOemVer(this.mvOem.get(model + "-" + versionObj.toString()));
            Object type = this.typeSelector.getSelectedItem();
            if (curOemInfo != null && type != null) {
                context.setCurOem(curOemInfo);
                this.layout.refreshByType(type.toString());
            }
        });
    }

    public void createOem() {
        if (!this.layout.checkData()) {
            return;
        }
        String oemPath = ToolFileChooser.getSaveFilePath((String)ResourceUtil.getString((String)"oem.tool.info.create.title"), (String)"tgz", (Window)((Object)this), (String)this.getPkgName(), (String)SELECTFILE_DEFAULT_ID, (boolean)true, (Locale)CURRENT_LOCAL);
        if (oemPath == null || !OemDataContext.getInstance().checkFilepath((Window)((Object)this), oemPath)) {
            LOGGER.info("Create  OEM package][Failed");
            return;
        }
        LOGGER.info("Create  OEM package >> Create package {} OK][Success", (Object)oemPath);
        List ret = AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new CreateOemCallable(oemPath)});
        if (((Boolean)ret.get(0)).booleanValue()) {
            OemUIContext uiComtext = OemUIContext.getInstance();
            uiComtext.callBackOemPath(oemPath);
            this.setVisible(false);
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.info.create.success"));
        } else {
            File oemFile = new File(oemPath);
            if (oemFile.exists()) {
                FileUtils.deleteFile((File)oemFile);
            }
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.info.create.failed"));
        }
    }

    private String getPkgName() {
        String name = "oem";
        OemInfo info = OemDataContext.getInstance().getCurOem();
        List<FileItem> lists = info.getInfoList();
        for (FileItem item : lists) {
            if (!"oem.js".equals(item.getFileName())) continue;
            List<InfoItem> infoItems = item.getTxtInfos();
            for (InfoItem infoItem : infoItems) {
                if (!"ism.OEM.productModel".equals(infoItem.getKey())) continue;
                name = String.join((CharSequence)"_", name, infoItem.getDefValue().replaceAll("\\s", "_"));
            }
        }
        return name;
    }

    public void selectImport() {
        String[] ext = new String[]{"tgz"};
        File selectFile = ToolFileChooser.selectFile((Window)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.info.import.title"), (String[])ext, (String)SELECT_OEMPACK_ID, (String)"tgz", (int)0, (boolean)true, (Locale)CURRENT_LOCAL);
        try {
            if (null == selectFile || !selectFile.exists() || !OemDataContext.getInstance().checkFilepath((Window)((Object)this), selectFile.getCanonicalPath())) {
                return;
            }
        }
        catch (IOException e) {
            LOGGER.error("select file :{}", (Object)selectFile.getName(), (Object)e);
        }
        List ret = AsyncExcutor.execute((Window)((Object)this), (Callable[])new Callable[]{new ParseOemCallable(selectFile, this.layout, this, true)});
        OemUIContext uiContext = OemUIContext.getInstance();
        if (OemServiceImpl.DE_COMPRESS_ERROR.equals(ret.get(0))) {
            LOGGER.info("Import OEM package][Failed");
            DialogUtils.showInfoDialog((JDialog)uiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.deCompress.failed"));
        } else if (OemServiceImpl.VERSION_ERROR.equals(ret.get(0))) {
            LOGGER.info("Import OEM package][Failed");
            DialogUtils.showInfoDialog((JDialog)uiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.improt.failed"));
        } else if (OemServiceImpl.PARSE_OEM_FAILED.equals(ret.get(0))) {
            LOGGER.info("Import OEM package][Failed");
            DialogUtils.showInfoDialog((JDialog)uiContext.getCreateInfoDialog(), (String)ResourceUtil.getString((String)"oem.tool.info.import.failed"));
        } else if (OemServiceImpl.PARSE_OEM_SUCCESS.equals(ret.get(0))) {
            LOGGER.info("Import OEM package >> {}][Success", (Object)selectFile.getName());
            this.pack();
        }
    }

    @Override
    public void refreshSelectOem() {
        OemDataContext.getInstance().getOptionName().clear();
    }

    private static String[] dealArray(String[] arr) {
        String target = ResourceUtil.getString((String)"oem.tool.info.button.desc2.default");
        List<String> list = Arrays.stream(arr).filter(str -> !target.equals(str)).sorted().distinct().collect(Collectors.toList());
        list.add(0, target);
        return list.toArray(new String[0]);
    }
}

