/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import com.huawei.ism.tool.oem.ui.layout.OemMainLayout;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.event.ActionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAction
extends ToolHyperLinkLabel.ClickAdapter {
    private static final Logger log = LoggerFactory.getLogger(DeleteAction.class);
    private static final long serialVersionUID = 1L;
    private DevNode node;
    private TableRow<DevNode, String> row;
    private OemMainFrame oemMainFrame;
    private OemMainLayout layout;

    public DeleteAction(DevNode node, TableRow<DevNode, String> row, OemMainFrame oemMainFrame, OemMainLayout layout) {
        this.node = node;
        this.row = row;
        this.oemMainFrame = oemMainFrame;
        this.layout = layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String remind = ResourceUtil.getString((String)"oem.tool.main.table.operation.del.remind");
        if (!this.oemMainFrame.checkOneDevRuning(this.node) || !this.oemMainFrame.checkConfirm(remind)) {
            return;
        }
        this.layout.getModel().removeRow(new TableRow[]{this.row});
        log.info("Delete device >> Delete device {} ][Success", (Object)this.node.getIp());
        this.oemMainFrame.refurbishDetailList();
        OemDataContext.getInstance().clearDevExeResult(this.node);
        OemDataContext.getInstance().removeDevRunState(this.node);
        try {
            DefaultNodeProviderImpl.getInstance().removeNode(this.node);
        }
        catch (ToolException e1) {
            log.error("delete devNode failed!", (Throwable)e1);
        }
    }
}

