/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.ui.OemMainFrame;
import com.huawei.ism.tool.oem.ui.layout.OemMainLayout;
import com.huawei.ism.tool.oem.utils.RunType;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;

public class ModifyAction
extends ToolHyperLinkLabel.ClickAdapter {
    private static final long serialVersionUID = 1L;
    private static final String APPLY_DEV_KEY = "applKey";
    private static final String RUNING_DEV_KEY = "runKey";
    private static final int STATE_COL = 4;
    private DevNode node;
    private Window parent;
    private OemMainFrame oemMainFrame;
    private OemMainLayout layout;

    public ModifyAction(DevNode node, Window parent, OemMainFrame oemMainFrame, OemMainLayout layout) {
        this.node = node;
        this.parent = parent;
        this.oemMainFrame = oemMainFrame;
        this.layout = layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.oemMainFrame.checkOneDevRuning(this.node)) {
            return;
        }
        IDeviceManageUI idm = (IDeviceManageUI)PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        Map<String, List<DevNode>> allFilterDevs = this.oemMainFrame.getDevManagerList();
        List<DevNode> devManagerdevs = allFilterDevs.get(APPLY_DEV_KEY);
        boolean modifyDev = idm.showModifyDeviceDialog(this.parent, true, this.node.getIp(), EntityUtils.toNewDevList(devManagerdevs));
        if (modifyDev) {
            this.layout.getModel().removeAll();
            this.addDevToTabel(devManagerdevs);
            this.addDevToTabel(allFilterDevs.get(RUNING_DEV_KEY));
            this.oemMainFrame.refurbishDetailList();
        }
    }

    private void addDevToTabel(List<DevNode> devs) {
        for (DevNode n : devs) {
            TableRow<DevNode, String> row = this.oemMainFrame.createTableRow(n);
            RunType runType = OemDataContext.getInstance().getDevRunState(n);
            String state = this.oemMainFrame.getStateStr(runType);
            row.setValueAt(4, (Object)state);
            this.layout.getModel().addRow(new TableRow[]{row});
        }
    }
}

