/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.tool.base.ui.dialogs.HelpTitleFrame;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.entity.CliItem;
import com.huawei.ism.tool.oem.entity.ComputeStorageUtils;
import com.huawei.ism.tool.oem.entity.ExecuteResult;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.service.impl.ComputeNodeSettingService;
import com.huawei.ism.tool.oem.service.impl.OemServiceImpl;
import com.huawei.ism.tool.oem.ui.ChangeDevRowListener;
import com.huawei.ism.tool.oem.ui.ChoiceOemPackActionListener;
import com.huawei.ism.tool.oem.ui.DeleteAction;
import com.huawei.ism.tool.oem.ui.ExecuteActionListener;
import com.huawei.ism.tool.oem.ui.GetDetailListScrolpaneThread;
import com.huawei.ism.tool.oem.ui.ModifyAction;
import com.huawei.ism.tool.oem.ui.SetListDataThread;
import com.huawei.ism.tool.oem.ui.SettingAction;
import com.huawei.ism.tool.oem.ui.ShowSupportListener;
import com.huawei.ism.tool.oem.ui.layout.OemMainLayout;
import com.huawei.ism.tool.oem.ui.listener.AddDeviceListener;
import com.huawei.ism.tool.oem.ui.listener.CreatOemPackListener;
import com.huawei.ism.tool.oem.ui.listener.OemMainWindowListener;
import com.huawei.ism.tool.oem.ui.listener.ShowDetailListener;
import com.huawei.ism.tool.oem.ui.support.CompCell;
import com.huawei.ism.tool.oem.ui.support.CompLabel;
import com.huawei.ism.tool.oem.utils.CmdType;
import com.huawei.ism.tool.oem.utils.NodesUtil;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.tool.oem.utils.RunType;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.Products;

public class OemMainFrame
extends HelpTitleFrame {
    private static final Logger log = LoggerFactory.getLogger(OemMainFrame.class);
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OemMainFrame.class);
    private static final String SELECTFILE_DEFAULT_ID = "oem_saveresult_path_id001";
    private static final String APPLY_DEV_KEY = "applKey";
    private static final String RUNING_DEV_KEY = "runKey";
    private static final int STATE_COL = 4;
    private static final long MAX_SIZE = 0xA00000L;
    private OemMainLayout layout = null;
    private File selectFile = null;

    public OemMainFrame() {
        this.initUI();
        this.initListener();
    }

    private void initUI() {
        this.layout = new OemMainLayout();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString((String)"oem.tool.title"));
        this.setIconImage(ResourceUtil.getImage((String)"oem.png").getImage());
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void initData() {
        this.layout.getTable().removeAll();
        List<DevNode> devNodes = this.getDevNodeList();
        for (DevNode node : devNodes) {
            if (OemDataContext.getInstance().isSupportDev(node)) {
                TableRow<DevNode, String> row = this.createTableRow(node);
                this.layout.getModel().addRow(new TableRow[]{row});
            }
            this.layout.getTable().updateUI();
        }
    }

    public void init() {
        OemServiceImpl oemserviceImpl = new OemServiceImpl();
        oemserviceImpl.loadPkgs();
        this.initData();
    }

    private List<DevNode> getDevNodeList() {
        return OemDataContext.getInstance().getAllDevNode();
    }

    private void initListener() {
        this.layout.getCreateButton().addActionListener(new CreatOemPackListener(this));
        this.layout.getAddDeviceLink().addMouseListener((MouseListener)new AddDeviceListener(this));
        this.layout.getSupportProductLink().addMouseListener((MouseListener)new ShowSupportListener(this));
        this.layout.getChoiceButton().addActionListener(new ChoiceOemPackActionListener(this));
        this.layout.getImportButton().addActionListener(new ExecuteActionListener(CmdType.IMPORTOEM, this));
        this.layout.getRollbackButton().addActionListener(new ExecuteActionListener(CmdType.ROLLBACK, this));
        this.layout.getPowerOffButton().addActionListener(new ExecuteActionListener(CmdType.POWEROFF, this));
        this.layout.getTable().addListSelectionListener((ListSelectionListener)new ChangeDevRowListener(this));
        this.layout.getDetail().addMouseListener(new ShowDetailListener(this, this.layout));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new OemMainWindowListener(this));
    }

    public void bindDeviceData() {
        this.layout.getTable().removeAll();
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        ArrayList<List<Object>> failRet = new ArrayList<List<Object>>();
        for (DevNode dev : devs) {
            if (dev.getLoginUser().getUserName().startsWith("domain/")) {
                log.error("{} is logged in as a domain user.", (Object)dev.getIp());
                failRet.add(this.getUnSupportDev(dev));
                continue;
            }
            this.layout.getModel().addRow(new TableRow[]{this.createTableRow(dev)});
        }
        if (!failRet.isEmpty()) {
            this.createUnSupportDomainDialog(failRet);
        }
        this.layout.getTable().updateUI();
    }

    private void createUnSupportDomainDialog(ArrayList<List<Object>> failRet) {
        SubDialogUtils.showMultiInfoDialogOnTop((String)ResourceUtil.getString((String)"scene.domain.user.not.support"), (String[])new String[]{ResourceUtil.getString((String)"devicemanager.layout.initdate.nosupportdevip"), ResourceUtil.getString((String)"devicemanager.layout.initdate.nosupportdevsn")}, failRet);
    }

    private List<Object> getUnSupportDev(DevNode dev) {
        ArrayList<Object> unSupportDev = new ArrayList<Object>();
        unSupportDev.add(dev.getIp());
        unSupportDev.add(dev.getDeviceSerialNumber());
        return unSupportDev;
    }

    public TableRow<DevNode, String> createTableRow(DevNode dev) {
        String key = dev.getDeviceSerialNumber() + dev.getDeviceType();
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeaders().length, (Object)dev, (Object)key);
        int index = 0;
        row.setValueAt(index++, (Object)dev.getIp());
        row.setValueAt(index++, (Object)dev.getDeviceType());
        row.setValueAt(index++, (Object)dev.getProductVersion());
        row.setValueAt(index++, (Object)dev.getDeviceName());
        row.setValueAt(index++, (Object)ResourceUtil.getString((String)"oem.tool.main.runstate.wait"));
        row.setValueAt(index++, (Object)this.createOppCell(dev, (TableRow<DevNode, String>)row));
        return row;
    }

    public void chiceAction() {
        String[] ext = new String[]{"tgz"};
        String dialogTitle = ResourceUtil.getString((String)"oem.tool.select.file.title");
        File curFile = ToolFileChooser.selectFile((Window)((Object)this), (String)dialogTitle, (String[])ext, (String)SELECTFILE_DEFAULT_ID, (String)"tgz", (int)0, (boolean)true, (boolean)true, (Locale)Locale.getDefault());
        try {
            if (null != curFile && curFile.exists() && OemDataContext.getInstance().checkFilepath((Window)((Object)this), curFile.getCanonicalPath())) {
                this.selectFile = curFile;
                this.layout.getImportField().setText(this.selectFile.getCanonicalPath());
                if (this.checkCurFileAndDecompress(curFile)) {
                    LOGGER.info("Choose OEM package path >> {}][Success", (Object)this.selectFile.getName());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("get path error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("get path error.", (Throwable)e);
        }
    }

    private boolean checkCurFileAndDecompress(File curFile) {
        if (!ComputeStorageUtils.isRightOemTgz((Frame)((Object)this), curFile)) {
            this.layout.getImportField().setText("");
            this.selectFile = null;
            LOGGER.error("Failed to verify the OEM package name.");
            return false;
        }
        try {
            FileAssistant.clearDir(ComputeStorageUtils.UN_ZIP_TEMP);
            if (!FileAssistant.deCompressTgz(ComputeStorageUtils.UN_ZIP_TEMP, curFile.getCanonicalPath())) {
                LOGGER.warn("deCompress tgz file failed!");
                return false;
            }
            if (!ComputeStorageUtils.checkDirAndCompressOemPackage()) {
                LOGGER.warn("Failed to decompress the OEM package on computing storage nodes.");
                return false;
            }
        }
        catch (IOException e) {
            LOGGER.error("deCompress tgz file failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    public void executeAction(CmdType cmdType) {
        List<DevNode> nodes = this.getSelectedDevNode();
        if (this.isAbnormalDevInfo(nodes, cmdType)) {
            return;
        }
        this.printBeginLog(cmdType);
        OemServiceImpl oemServer = new OemServiceImpl();
        if (null != this.selectFile) {
            try {
                oemServer.setLocalPath(this.selectFile.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get path error.", (Throwable)e);
                return;
            }
        }
        oemServer.startTask(nodes, cmdType);
    }

    private boolean isAbnormalDevInfo(List<DevNode> nodes, CmdType cmdType) {
        return !this.checkSelectDev() || !this.checkSelectDevOemVer(nodes) || !this.checkNodeCmd(cmdType) || !this.checkDevRuning(nodes) || !this.checkComputeStorageInfo(nodes, cmdType) || !this.checkAndConfirm(cmdType);
    }

    private boolean checkComputeStorageInfo(List<DevNode> nodes, CmdType cmdType) {
        if (!OemConstants.isComputeStorageOemInfo(OemDataContext.getInstance().getCurOem()) || !CmdType.IMPORTOEM.equals((Object)cmdType)) {
            return true;
        }
        return this.checkNodesNum(nodes) && this.checkPackageAndDevMatch(nodes);
    }

    private boolean checkPackageAndDevMatch(List<DevNode> nodes) {
        return ComputeStorageUtils.isOnlyOemStorageScene(nodes, (JFrame)((Object)this));
    }

    private boolean checkNodesNum(List<DevNode> nodes) {
        if (!this.checkNodesUser(nodes)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.check.compute.storage.nodes.info.error"));
            return false;
        }
        return true;
    }

    private boolean checkNodesUser(List<DevNode> nodes) {
        return nodes.stream().allMatch(this::checkNumberOfFcAndOem);
    }

    private boolean checkNumberOfFcAndOem(DevNode node) {
        List<MultiRouteNode> fcNodes;
        List<MultiRouteNode> osmNodes = ComputeNodeSettingService.getInstance().getOsmNodesByIp(node.getIp());
        return this.checkFcvAndOem(osmNodes, fcNodes = ComputeNodeSettingService.getInstance().getFcNodesByIp(node.getIp())) || this.checkOnlyFcv(osmNodes, fcNodes) || ComputeStorageUtils.isOnlyStorageNode(osmNodes, fcNodes);
    }

    private boolean checkFcvAndOem(List<MultiRouteNode> osmNodes, List<MultiRouteNode> fcNodes) {
        return osmNodes.size() == fcNodes.size() && NodesUtil.checkComputationalStorageNodesNumber(osmNodes) && NodesUtil.checkComputationalStorageNodesNumber(fcNodes);
    }

    private boolean checkOnlyFcv(List<MultiRouteNode> osmNodes, List<MultiRouteNode> fcNodes) {
        return osmNodes.size() != fcNodes.size() && fcNodes.isEmpty();
    }

    private boolean checkDevRuning(List<DevNode> nodes) {
        OemDataContext context = OemDataContext.getInstance();
        for (DevNode devNode : nodes) {
            RunType runType = context.getDevRunState(devNode);
            if (!RunType.RUNING.equals((Object)runType)) continue;
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.execute.remind"));
            return false;
        }
        return true;
    }

    public boolean checkDevRuning() {
        List<DevNode> nodes = this.getSelectedDevNode();
        OemDataContext context = OemDataContext.getInstance();
        for (DevNode devNode : nodes) {
            RunType runType = context.getDevRunState(devNode);
            if (!RunType.RUNING.equals((Object)runType)) continue;
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.execute.remind"));
            return false;
        }
        return true;
    }

    public boolean checkOneDevRuning(DevNode devNode) {
        RunType runType = OemDataContext.getInstance().getDevRunState(devNode);
        if (RunType.RUNING.equals((Object)runType)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.execute.remind"));
            return false;
        }
        return true;
    }

    private boolean checkSelectDevOemVer(List<DevNode> nodes) {
        OemDataContext context = OemDataContext.getInstance();
        StringBuilder oemVer = new StringBuilder();
        OemInfo curInfo = null;
        for (DevNode devNode : nodes) {
            DeviceType deviceType;
            String productVersion = devNode.getProductVersion();
            curInfo = context.getOemInfoByDev(productVersion, deviceType = devNode.getDeviceType());
            if (null == curInfo) {
                LOGGER.info("can't find oeminfo version!");
                return false;
            }
            String curVer = curInfo.toString();
            if (!StringUtils.isNULLStr(oemVer.toString()) && !oemVer.toString().contains(curVer)) {
                DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.version.remind"));
                return false;
            }
            oemVer.append(",");
            oemVer.append(curVer);
        }
        context.setCurOem(curInfo);
        return true;
    }

    private boolean checkAndConfirm(CmdType cmdType) {
        if (CmdType.IMPORTOEM.equals((Object)cmdType)) {
            return this.checkSelectOemPack();
        }
        if (CmdType.ROLLBACK.equals((Object)cmdType)) {
            return this.checkRollBackOem();
        }
        if (CmdType.POWEROFF.equals((Object)cmdType)) {
            return this.checkPowerOff();
        }
        return false;
    }

    public boolean checkConfirm(String message) {
        return DialogUtils.showYesNoDialog((Window)((Object)this), (String)message).getValue() == 0;
    }

    private boolean checkWarnConfirm(String message) {
        return DialogUtils.createWarningDialog((Frame)((Object)this), (String)message).getValue() == 0;
    }

    private List<DevNode> getSelectedDevNode() {
        int[] rowIndexs = this.layout.getTable().getSelectedRows();
        ArrayList<DevNode> results = new ArrayList<DevNode>();
        DevNode devNode = null;
        if (rowIndexs == null || rowIndexs.length == 0) {
            return results;
        }
        for (int index : rowIndexs) {
            index = this.layout.getTable().convertRowIndexToModel(index);
            TableRow row = this.layout.getModel().getRow(index);
            devNode = (DevNode)row.getUserObject();
            results.add(devNode);
        }
        return results;
    }

    public DevNode getCurrentChosenDevNode() {
        int[] rows = this.layout.getTable().getSelectedRows();
        if (rows == null || rows.length == 0) {
            return null;
        }
        int index = this.layout.getTable().convertRowIndexToModel(rows[0]);
        TableRow row = this.layout.getModel().getRow(index);
        return (DevNode)row.getUserObject();
    }

    public void executCallback(DevNode devNode) {
        this.refleshTable(devNode);
        this.refurbishDetailList();
        this.getBottomDetailList();
    }

    private void refleshTable(DevNode devNode) {
        List tableRows = this.layout.getTable().getAllRows();
        TableRow changeRow = null;
        for (TableRow row : tableRows) {
            if (!row.getUserObject().equals(devNode)) continue;
            changeRow = row;
            break;
        }
        if (changeRow == null) {
            LOGGER.error("oem call back error,no such devNode : {}", (Object)devNode.getIp());
            return;
        }
        String state = null;
        RunType runType = OemDataContext.getInstance().getDevRunState(devNode);
        state = this.getStateStr(runType);
        changeRow.setValueAt(4, (Object)state);
    }

    public String getStateStr(RunType runType) {
        CmdType cmdType = OemDataContext.getInstance().getCmdType();
        String stateStr = "";
        if (RunType.SUCESSED.equals((Object)runType)) {
            LOGGER.info("{}>> OEM package end][Success", (Object)cmdType.toString());
            stateStr = ResourceUtil.getString((String)"oem.tool.main.runstate.success");
        } else if (RunType.RUNING.equals((Object)runType)) {
            stateStr = ResourceUtil.getString((String)"oem.tool.main.runstate.runing");
        } else if (RunType.FAILED.equals((Object)runType)) {
            LOGGER.info("{}>> OEM package end][Failed", (Object)cmdType.toString());
            stateStr = ResourceUtil.getString((String)"oem.tool.main.runstate.failed");
        } else {
            stateStr = ResourceUtil.getString((String)"oem.tool.main.runstate.wait");
        }
        return stateStr;
    }

    public void refurbishDetailList() {
        this.layout.getDetail().setListData(new ExecuteResult[0]);
        DevNode devNode = this.getCurrentChosenDevNode();
        this.setListData(devNode);
    }

    private void setListData(DevNode devNode) {
        try {
            if (devNode == null) {
                return;
            }
            List<ExecuteResult> execResultList = OemDataContext.getInstance().getDevExeResults(devNode);
            LOGGER.info("execResultList:{}", execResultList);
            this.refurbishListData(execResultList);
        }
        catch (Exception e) {
            LOGGER.info("set list data failed", (Throwable)e);
        }
    }

    private void refurbishListData(List<ExecuteResult> execResultList) {
        if (null != execResultList && !execResultList.isEmpty()) {
            List<ExecuteResult> curExecResultList = execResultList;
            SwingUtilities.invokeLater(new SetListDataThread(this.layout, curExecResultList));
        } else {
            LOGGER.info("execute result is null or is empty!");
        }
    }

    private void getBottomDetailList() {
        SwingUtilities.invokeLater(new GetDetailListScrolpaneThread(this.layout));
    }

    public void refleshOemPath(String oemPath) {
        this.selectFile = new File(oemPath);
        this.layout.getImportField().setText(oemPath);
    }

    private boolean checkSelectOemPack() {
        if (null == this.selectFile) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.select.file.remind"));
            return false;
        }
        if (!this.selectFile.exists()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.select.file.not.exists"));
            return false;
        }
        if (this.countZipSize() > 0xA00000L) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.select.file.size.too.much"));
            return false;
        }
        List<DevNode> selectNodes = this.getSelectedDevNode();
        for (DevNode devNode : selectNodes) {
            if (devNode.getPriKey() == null) continue;
            return DialogUtils.showYesNoDialog((Window)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.execute.import.remind")).getValue() == 0;
        }
        String preTip = this.getOemPreTip(CmdType.IMPORTOEM);
        if (!StringUtils.isNULLStr(preTip)) {
            return this.checkConfirm(preTip);
        }
        return true;
    }

    private long countZipSize() {
        long size = 0L;
        try (FileInputStream is = new FileInputStream(FilePathUtils.checkFile((File)this.selectFile));){
            size = ((InputStream)is).available();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (IOException e) {
            LOGGER.error("count zipfile size failed.", (Throwable)e);
        }
        return size;
    }

    private boolean checkRollBackOem() {
        String showTip = ResourceUtil.getString((String)"oem.tool.execute.roolback.remind");
        String preTip = this.getOemPreTip(CmdType.ROLLBACK);
        if (!StringUtils.isNULLStr(preTip)) {
            showTip = preTip;
        }
        return this.checkConfirm(showTip);
    }

    private boolean checkPowerOff() {
        String showTip = ResourceUtil.getString((String)"oem.tool.execute.poweroff.remind");
        String preTip = this.getOemPreTip(CmdType.POWEROFF);
        if (!StringUtils.isNULLStr(preTip)) {
            showTip = preTip;
        }
        return this.checkWarnConfirm(showTip);
    }

    private String getOemPreTip(CmdType cmdType) {
        OemInfo oemInfo = OemDataContext.getInstance().getCurOem();
        if (null == oemInfo) {
            LOGGER.info("check rool back oem failed,oem info is null");
            return "";
        }
        List<CliItem> items = oemInfo.getCliMap().get((Object)cmdType);
        for (CliItem item : items) {
            String curProTip = item.getPreTip();
            if (StringUtils.isNULLStr(curProTip)) continue;
            return curProTip;
        }
        return "";
    }

    private boolean checkSelectDev() {
        if (this.layout.getTable().getSelectedRowCount() == 0) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.select.device.remind"));
            return false;
        }
        return true;
    }

    private boolean checkNodeCmd(CmdType cmdType) {
        OemInfo oemInfo = OemDataContext.getInstance().getCurOem();
        if (CmdType.ROLLBACK.equals((Object)cmdType) && OemConstants.isComputeStorageOemInfo(oemInfo)) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.exec.no.cmd"));
            return false;
        }
        if (!CmdType.IMPORTOEM.equals((Object)cmdType)) {
            return true;
        }
        Map<CmdType, List<CliItem>> typeCliItem = oemInfo.getCliMap();
        if (null == typeCliItem || typeCliItem.get((Object)cmdType).isEmpty()) {
            DialogUtils.showInfoDialog((Frame)((Object)this), (String)ResourceUtil.getString((String)"oem.tool.exec.no.cmd"));
            return false;
        }
        return true;
    }

    public Map<String, List<DevNode>> getDevManagerList() {
        HashMap<String, List<DevNode>> allFilterDevs = new HashMap<String, List<DevNode>>();
        OemDataContext context = OemDataContext.getInstance();
        List<DevNode> devs = this.getDevNodeList();
        ArrayList<DevNode> runDevs = new ArrayList<DevNode>();
        Iterator<DevNode> iter = devs.iterator();
        while (iter.hasNext()) {
            RunType runType;
            DevNode dev = iter.next();
            if (!context.isSupportDev(dev)) {
                iter.remove();
            }
            if (!RunType.RUNING.equals((Object)(runType = OemDataContext.getInstance().getDevRunState(dev)))) continue;
            iter.remove();
            runDevs.add(dev);
        }
        allFilterDevs.put(APPLY_DEV_KEY, devs);
        allFilterDevs.put(RUNING_DEV_KEY, runDevs);
        return allFilterDevs;
    }

    private CompCell createOppCell(DevNode dev, TableRow<DevNode, String> row) {
        CompLabel modifyLabel = new CompLabel(ResourceUtil.getString((String)"oem.tool.main.table.operation.modify"), new ModifyAction(dev, (Window)((Object)this), this, this.layout));
        CompLabel deleteLabel = new CompLabel(ResourceUtil.getString((String)"oem.tool.main.table.operation.delete"), new DeleteAction(dev, row, this, this.layout));
        if (Products.OCEAN_STOR_COMPUTING_DEVS.contains(dev.getDeviceType().toString())) {
            CompLabel settingLabel = new CompLabel(ResourceUtil.getString((String)"oem.tool.main.table.operation.setting"), new SettingAction(dev, this));
            return new CompCell(modifyLabel, deleteLabel, settingLabel);
        }
        return new CompCell(modifyLabel, deleteLabel);
    }

    public void doHelpActionWork() {
        FileUtils.openHelpFile("Oem\\OEM", (Window)((Object)this), ".chm");
    }

    public void printBeginLog(CmdType cmdType) {
        if (CmdType.IMPORTOEM.equals((Object)cmdType)) {
            LOGGER.info("Import>> OEM package begin][Success");
        } else if (CmdType.ROLLBACK.equals((Object)cmdType)) {
            LOGGER.info("Back-off >> OEM package begin][Success");
        } else if (CmdType.POWEROFF.equals((Object)cmdType)) {
            LOGGER.info("Reset >> OEM reset begin][Success");
        } else {
            LOGGER.error("Unknown cmd type {}.", (Object)cmdType);
        }
    }
}

