/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.ui.layout.ShowParseErrorLayout;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class ShowParseErrorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIALOG_SIZE = new Dimension(500, 345);
    private ShowParseErrorLayout layout;

    public ShowParseErrorDialog(JFrame parent) {
        super(parent);
        this.initUI();
        this.initListener();
    }

    private void initListener() {
        this.layout.getCloseBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowParseErrorDialog.this.dispose();
            }
        });
    }

    private void initUI() {
        this.layout = new ShowParseErrorLayout();
        this.setTitle(ResourceUtil.getString((String)"oem.tool.parse.dialog.title"));
        this.initTable();
        this.add(this.layout);
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        UiMethod.putScreenCenter((Window)this);
    }

    private void initTable() {
        OemDataContext dataContext = OemDataContext.getInstance();
        Map<String, String> failedPackage = dataContext.getFailePackage();
        for (Map.Entry<String, String> entry : failedPackage.entrySet()) {
            String packageName = entry.getKey();
            String errorMeg = entry.getValue();
            this.layout.getModel().addRow(new TableRow[]{this.createTableRow(packageName, errorMeg)});
        }
    }

    private TableRow<String, String> createTableRow(String packageName, String errorMeg) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getColumnNames().length, (Object)packageName);
        int index = 0;
        row.setValueAt(index++, (Object)packageName);
        row.setValueAt(index, (Object)errorMeg);
        return row;
    }
}

