/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.layout;

import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.TextEditCell;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.tool.oem.entity.ComputeStorageUtils;
import com.huawei.ism.tool.oem.service.impl.ComputeNodeSettingService;
import com.huawei.ism.tool.oem.utils.NodesUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableScrollPane;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeNodeSettingLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeSettingLayout.class);
    private static final long serialVersionUID = 6051057299633867153L;
    private static final String MANAGER_SFTP = "managersftp";
    private static final String GANDALF = "gandalf";
    private static final int TIMEOUT = 5000;
    private static final String OSM = "OSM";
    private static final String FC = "FC";
    private DefaultTableModel osmDefaultTableModel = new DefaultTableModel(new String[]{com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.ip"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.user"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.pwd"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.port")}, new int[0]);
    private DefaultTableModel fcdefaultTableModel = new DefaultTableModel(new String[]{com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.ip"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.user"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.pwd"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.root.pwd"), com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.compute.node.port")}, new int[0]);
    private IsmTable osmDetailTable = new IsmTable((TableModel)this.osmDefaultTableModel);
    private JButton osmAddNode = new JButton(ResourceUtil.getImage("add.png"));
    private JButton osmDelNode = new JButton(ResourceUtil.getImage("delete.png"));
    private IsmTable fcDetailTable = new IsmTable((TableModel)this.fcdefaultTableModel);
    private JButton fcAddNode = new JButton(ResourceUtil.getImage("add.png"));
    private JButton fcDelNode = new JButton(ResourceUtil.getImage("delete.png"));
    private JDialog parent;
    private JLabel osmDetailLabel = new JLabel(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.OSM.node.detail.info"));
    private JLabel fcDetailLabel = new JLabel(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.FC.node.detail.info"));
    private List<OperaLog> addOperaLogs = new ArrayList<OperaLog>();
    private List<MultiRouteNode> osmNodes = new ArrayList<MultiRouteNode>();
    private List<MultiRouteNode> fcNodes = new ArrayList<MultiRouteNode>();
    private DevNode devNode;

    public ComputeNodeSettingLayout(JDialog parent, DevNode devNode) {
        this.parent = parent;
        this.devNode = devNode;
        this.initUI();
        this.initNodeOperateListener();
        this.initData();
        this.setOperateCompentName();
    }

    private void initData() {
        List<MultiRouteNode> hisOsmNodes = ComputeNodeSettingService.getInstance().getOsmNodesByIp(this.devNode.getIp());
        this.osmNodes.addAll(hisOsmNodes);
        for (MultiRouteNode node : this.osmNodes) {
            this.osmDefaultTableModel.addRow(new TableRow[]{this.createRow(node, OSM)});
        }
        List<MultiRouteNode> hisfcNodes = ComputeNodeSettingService.getInstance().getFcNodesByIp(this.devNode.getIp());
        this.fcNodes.addAll(hisfcNodes);
        for (MultiRouteNode node : this.fcNodes) {
            this.fcdefaultTableModel.addRow(new TableRow[]{this.createRow(node, FC)});
        }
    }

    public boolean saveCurRouteNodes() {
        List<MultiRouteNode> fcCurrentNodes;
        List<MultiRouteNode> osmCurrentNodes = this.getTableRouteNodes(OSM);
        if (!(this.checkNumberOfFcAndOem(osmCurrentNodes, fcCurrentNodes = this.getTableRouteNodes(FC)) && this.checkNodeUser(osmCurrentNodes, MANAGER_SFTP) && this.checkNodeUser(fcCurrentNodes, GANDALF))) {
            return false;
        }
        if (this.checkTableDataInvalid(osmCurrentNodes, OSM) && this.checkTableDataInvalid(fcCurrentNodes, FC)) {
            this.osmNodes = osmCurrentNodes;
            this.fcNodes = fcCurrentNodes;
            return true;
        }
        return false;
    }

    private boolean checkNumberOfFcAndOem(List<MultiRouteNode> osmCurrentNodes, List<MultiRouteNode> fcCurrentNodes) {
        if (ComputeStorageUtils.isOnlyStorageNode(osmCurrentNodes, fcCurrentNodes)) {
            return ComputeStorageUtils.isClickOk(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.nodes.size.onlyStorage"), this.parent);
        }
        if (this.isOnlyOemFcvNode(osmCurrentNodes, fcCurrentNodes)) {
            return ComputeStorageUtils.isClickOk(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.nodes.size.onlyFcv"), this.parent);
        }
        if (this.isDefaultOemComputeStorage(osmCurrentNodes, fcCurrentNodes)) {
            String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.nodes.size.error");
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)msg);
            return false;
        }
        if (osmCurrentNodes.size() == 1) {
            return ComputeStorageUtils.isClickOk(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.nodes.size.confirm"), this.parent);
        }
        return true;
    }

    private boolean isOnlyOemFcvNode(List<MultiRouteNode> osmCurrentNodes, List<MultiRouteNode> fcCurrentNodes) {
        return osmCurrentNodes.size() != fcCurrentNodes.size() && fcCurrentNodes.isEmpty();
    }

    private boolean isDefaultOemComputeStorage(List<MultiRouteNode> osmCurrentNodes, List<MultiRouteNode> fcCurrentNodes) {
        return osmCurrentNodes.size() != fcCurrentNodes.size() || !NodesUtil.checkComputationalStorageNodesNumber(fcCurrentNodes) || !NodesUtil.checkComputationalStorageNodesNumber(osmCurrentNodes);
    }

    private boolean checkNodeUser(List<MultiRouteNode> nodes, String accountName) {
        for (MultiRouteNode node : nodes) {
            if (node.getUname().equals(accountName)) continue;
            String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.routenode.error");
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)MessageFormat.format(msg, node.getHost(), accountName));
            return false;
        }
        return true;
    }

    private boolean checkTableDataInvalid(List<MultiRouteNode> nodes, String nodeType) {
        for (MultiRouteNode node : nodes) {
            if (!StringUtils.isFullIpAddress(node.getHost())) {
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"device.adddialog.proxysetting.ip.error");
                this.promptErrorInfo(node, msg);
                return false;
            }
            if (StringUtils.isNULLStr(node.getPwd())) {
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"device.adddialog.proxysetting.pwd.error");
                this.promptErrorInfo(node, msg);
                return false;
            }
            if (FC.equals(nodeType) && StringUtils.isNULLStr(node.getRootPwd())) {
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"device.adddialog.proxysetting.rootpwd.error");
                this.promptErrorInfo(node, msg);
                return false;
            }
            if (node.getPort() < 0 || node.getPort() > 65535) {
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"device.adddialog.proxysetting.port.error");
                this.promptErrorInfo(node, msg);
                return false;
            }
            if (node.isValid() || !ComputeNodeSettingService.getInstance().isSftpCanConnected(node.getHost(), node.getPort(), 5000)) continue;
            String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"device.adddialog.proxysetting.routenodeerror");
            this.promptErrorInfo(node, msg);
            return false;
        }
        return true;
    }

    private void promptErrorInfo(MultiRouteNode node, String msg) {
        DialogUtils.showInfoDialog((JDialog)this.parent, (String)MessageFormat.format(msg, node.getHost()));
    }

    private List<MultiRouteNode> getTableRouteNodes(String nodeType) {
        ArrayList<MultiRouteNode> tableNodes = new ArrayList<MultiRouteNode>();
        List allRows = OSM.equals(nodeType) ? this.osmDefaultTableModel.getAllRows() : this.fcdefaultTableModel.getAllRows();
        for (TableRow row : allRows) {
            String host = row.getValueAt(0).toString();
            String username = row.getValueAt(1).toString();
            String password = row.getValueAt(2).toString();
            String rootPwd = OSM.equals(nodeType) ? "" : row.getValueAt(3).toString();
            MultiRouteNode multiRouteNode = new MultiRouteNode(host, this.getPort(row, nodeType), username, password, rootPwd);
            tableNodes.add(multiRouteNode);
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)password);
            com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)rootPwd);
        }
        return tableNodes;
    }

    private int getPort(TableRow row, String nodeType) {
        int portIndex = OSM.equals(nodeType) ? 3 : 4;
        int port = -1;
        if (!StringUtils.isNULLStr(row.getValueAt(portIndex).toString())) {
            port = StringUtils.str2Int(row.getValueAt(portIndex).toString());
        }
        return port;
    }

    private void initNodeOperateListener() {
        this.initOsmNodeListener();
        this.initFcNodeListener();
    }

    private void initOsmNodeListener() {
        this.osmAddNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                log.info("add osm node.");
                ComputeNodeSettingLayout.this.osmDefaultTableModel.addRow(new TableRow[]{ComputeNodeSettingLayout.this.createBlankRow(ComputeNodeSettingLayout.OSM, ComputeNodeSettingLayout.MANAGER_SFTP)});
            }
        });
        this.osmDefaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                log.info("change osm node.");
                ComputeNodeSettingLayout.this.clearosmTableEdit();
            }
        });
        this.osmDelNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                log.info("delete osm node info.");
                int selectIndex = ComputeNodeSettingLayout.this.osmDetailTable.getSelectedRow();
                selectIndex = ComputeNodeSettingLayout.this.osmDetailTable.convertRowIndexToModel(selectIndex);
                if (selectIndex == -1) {
                    return;
                }
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.delroutenode.tip");
                WarningDialog dialog = DialogUtils.showYesNoDialog((Window)ComputeNodeSettingLayout.this.parent, (String)msg);
                if (dialog.getValue() == 0) {
                    ComputeNodeSettingLayout.this.osmDefaultTableModel.removeRow(new TableRow[]{ComputeNodeSettingLayout.this.osmDefaultTableModel.getRow(selectIndex)});
                }
            }
        });
        this.osmDetailKeyListener();
    }

    private void initFcNodeListener() {
        this.fcAddNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                log.info("add fc node info.");
                ComputeNodeSettingLayout.this.fcdefaultTableModel.addRow(new TableRow[]{ComputeNodeSettingLayout.this.createBlankRow(ComputeNodeSettingLayout.FC, ComputeNodeSettingLayout.GANDALF)});
            }
        });
        this.fcdefaultTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                log.info("change fc node info.");
                ComputeNodeSettingLayout.this.clearFcTableEdit();
            }
        });
        this.fcDelNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                log.info("delete fc node info.");
                int selectIndex = ComputeNodeSettingLayout.this.fcDetailTable.getSelectedRow();
                selectIndex = ComputeNodeSettingLayout.this.fcDetailTable.convertRowIndexToModel(selectIndex);
                if (selectIndex == -1) {
                    return;
                }
                String msg = com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.delroutenode.tip");
                WarningDialog dialog = DialogUtils.showYesNoDialog((Window)ComputeNodeSettingLayout.this.parent, (String)msg);
                if (dialog.getValue() == 0) {
                    ComputeNodeSettingLayout.this.fcdefaultTableModel.removeRow(new TableRow[]{ComputeNodeSettingLayout.this.fcdefaultTableModel.getRow(selectIndex)});
                }
            }
        });
        this.fcdetailKeyListener();
    }

    private void osmDetailKeyListener() {
        this.osmDetailTable.addKeyListener((KeyListener)new MyCustKeyAdapter());
    }

    private void fcdetailKeyListener() {
        this.fcDetailTable.addKeyListener((KeyListener)new MyCustKeyAdapter());
    }

    public void clearosmTableEdit() {
        TableCellEditor editor = this.osmDetailTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public void clearFcTableEdit() {
        TableCellEditor editor = this.fcDetailTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private TableRow<?, ?> createBlankRow(String nodeType, String userName) {
        log.info("create blank row. node type:{}", (Object)nodeType);
        DefaultTableRow row = OSM.equals(nodeType) ? new DefaultTableRow(this.osmDefaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString()) : new DefaultTableRow(this.fcdefaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString());
        IsmTextField ipTextField = UiMethod.createIpv4v6TextField();
        TextEditCell tec = new TextEditCell(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"devicemanager.layout.device.add.sshfrd.detail"), (JTextField)ipTextField);
        row.setValueAt(0, (Object)tec);
        row.setValueAt(1, (Object)new TextEditCell(userName, (JTextField)UiMethod.getUsernameFiled()));
        row.setValueAt(2, (Object)new TextEditCell("", (JTextField)UiMethod.getPasswordFiled(), true));
        IsmTextField portFileField = IsmTextField.getRegexTextField((String)"\\d{1,5}", (int)5);
        if (OSM.equals(nodeType)) {
            row.setValueAt(3, (Object)new TextEditCell("22", (JTextField)portFileField));
        } else {
            row.setValueAt(3, (Object)new TextEditCell("", (JTextField)UiMethod.getPasswordFiled(), true));
            row.setValueAt(4, (Object)new TextEditCell("22", (JTextField)portFileField));
        }
        return row;
    }

    private TableRow<?, ?> createRow(MultiRouteNode multiRouteNode, String nodeType) {
        log.info("create row. node type:{}", (Object)nodeType);
        DefaultTableRow row = OSM.equals(nodeType) ? new DefaultTableRow(this.osmDefaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString()) : new DefaultTableRow(this.fcdefaultTableModel.getColumnCount(), (Object)UUID.randomUUID().toString());
        IsmTextField ip = UiMethod.createIpv4v6TextField();
        IsmTextField username = UiMethod.getUsernameFiled();
        IsmPasswordField password = UiMethod.getPasswordFiled();
        IsmTextField portFileField = IsmTextField.getRegexTextField((String)"\\d{1,5}", (int)5);
        row.setValueAt(0, (Object)new TextEditCell(multiRouteNode.getHost(), (JTextField)ip));
        row.setValueAt(1, (Object)new TextEditCell(multiRouteNode.getUname(), (JTextField)username));
        row.setValueAt(2, (Object)new TextEditCell(multiRouteNode.getPwd(), (JTextField)password, true));
        if (OSM.equals(nodeType)) {
            row.setValueAt(3, (Object)new TextEditCell(multiRouteNode.getPort() + "", (JTextField)portFileField));
        } else {
            row.setValueAt(3, (Object)new TextEditCell(multiRouteNode.getPwd(), (JTextField)UiMethod.getPasswordFiled(), true));
            row.setValueAt(4, (Object)new TextEditCell(multiRouteNode.getPort() + "", (JTextField)portFileField));
        }
        return row;
    }

    private void initUI() {
        UiMethod.setComponentSize(new Dimension(18, 18), this.osmAddNode, this.osmDelNode, this.fcAddNode, this.fcDelNode);
        this.setButtonTipText();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.inintGridBagConstraints(gbc);
        this.addPromptBox(gbc);
        this.addOsmTableOperateComp(gbc);
        this.addOsmTableScorll(gbc);
        this.addFcTableOperateComp(gbc);
        this.addFcTableScorll(gbc);
        this.setOpaque(false);
    }

    private void addFcTableScorll(GridBagConstraints gbc) {
        gbc.weighty = 5.0;
        ++gbc.gridy;
        gbc.insets.bottom = 12;
        this.fcDetailTable.setRowSorter(null);
        this.fcDetailTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        IsmTableScrollPane fcTableScorllPan = new IsmTableScrollPane(this.fcDetailTable, false);
        this.add((Component)fcTableScorllPan, gbc);
    }

    private void addFcTableOperateComp(GridBagConstraints gbc) {
        JComponent fcTableOprete = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.fcDetailLabel}), UCD.buildHBoxRight((Component[])new Component[]{this.fcAddNode, this.fcDelNode})});
        gbc.weighty = 1.0;
        ++gbc.gridy;
        this.add((Component)fcTableOprete, gbc);
    }

    private void addOsmTableScorll(GridBagConstraints gbc) {
        gbc.weighty = 5.0;
        ++gbc.gridy;
        gbc.insets.bottom = 12;
        this.osmDetailTable.setRowSorter(null);
        this.osmDetailTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        IsmTableScrollPane osmTableScorllPan = new IsmTableScrollPane(this.osmDetailTable, false);
        this.add((Component)osmTableScorllPan, gbc);
    }

    private void addOsmTableOperateComp(GridBagConstraints gbc) {
        JComponent osmTableOprete = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{this.osmDetailLabel}), UCD.buildHBoxRight((Component[])new Component[]{this.osmAddNode, this.osmDelNode})});
        gbc.weighty = 5.0;
        ++gbc.gridy;
        this.add((Component)osmTableOprete, gbc);
    }

    private void addPromptBox(GridBagConstraints gbc) {
        JLabel promptLabel = new JLabel(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.prompt.info"));
        Box promptBox = Box.createHorizontalBox();
        promptBox.add(promptLabel);
        JComponent promptComponent = UiMethod.buildFrameSpace(UCD.buildHBoxLeft((Component[])new Component[]{promptBox}), 5);
        promptComponent.setBorder(BorderFactory.createTitledBorder(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.mass.wizard.welcom.remind")));
        ++gbc.gridy;
        this.add((Component)promptComponent, gbc);
    }

    private void inintGridBagConstraints(GridBagConstraints gbc) {
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 12, 5, 12);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
    }

    private void setButtonTipText() {
        this.osmAddNode.setToolTipText(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.routenodeadd"));
        this.osmDelNode.setToolTipText(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.routenodedel"));
        this.fcAddNode.setToolTipText(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.routenodeadd"));
        this.fcDelNode.setToolTipText(com.huawei.ism.tool.base.utils.ResourceUtil.getString((String)"oem.tool.settingdialog.routenodedel"));
    }

    public void setOperateCompentName() {
        this.osmAddNode.setName("_Button_addRouteNode");
        this.osmDelNode.setName("_Button_delRouteNode");
        this.osmDetailTable.setName("_IsmTable_detailTable");
    }

    public List<OperaLog> getAddOperaLogs() {
        return this.addOperaLogs;
    }

    public void setAddOperaLogs(List<OperaLog> addOperaLogs) {
        this.addOperaLogs = addOperaLogs;
    }

    public List<MultiRouteNode> getOsmNodes() {
        return this.osmNodes;
    }

    public List<MultiRouteNode> getFcNodes() {
        return this.fcNodes;
    }

    private static final class MyCustKeyAdapter
    extends KeyAdapter {
        private MyCustKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.isControlDown() && event.getKeyCode() == 67) {
                event.consume();
            }
        }
    }
}

