/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.oem.ui.layout;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.oem.OemDataContext;
import com.huawei.ism.tool.oem.OemUIContext;
import com.huawei.ism.tool.oem.entity.FileItem;
import com.huawei.ism.tool.oem.entity.FileList;
import com.huawei.ism.tool.oem.entity.InfoItem;
import com.huawei.ism.tool.oem.entity.ItemPro;
import com.huawei.ism.tool.oem.entity.OemInfo;
import com.huawei.ism.tool.oem.logic.checker.ImageChecker;
import com.huawei.ism.tool.oem.logic.checker.TextChecker;
import com.huawei.ism.tool.oem.ui.layout.BrowseActionListener;
import com.huawei.ism.tool.oem.ui.listener.SelectBindOptionAction;
import com.huawei.ism.tool.oem.ui.listener.SelectOemInfoAction;
import com.huawei.ism.tool.oem.ui.support.OemImage;
import com.huawei.ism.tool.oem.ui.support.OemScrollPane;
import com.huawei.ism.tool.oem.ui.support.OemTextField;
import com.huawei.ism.tool.oem.utils.FileType;
import com.huawei.ism.tool.oem.utils.OemConstants;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateOemInfoLayout
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateOemInfoLayout.class);
    private String productVersion;
    private Dimension fieldSize;
    private Dimension areaSize;
    private JComponent activeComp;
    private JDialog parent;
    private Map<String, JComboBox> selectTypeComponent = new HashMap<String, JComboBox>();
    private Map<JComboBox, InfoItem> hasBindActionItem = new HashMap<JComboBox, InfoItem>();

    public CreateOemInfoLayout(JDialog parent) {
        this.parent = parent;
        this.activeComp = Box.createVerticalBox();
    }

    public JDialog getTipDialog() {
        return this.parent;
    }

    public void loadUI() {
        this.loadOemConfigControl();
        this.setLayout(new BorderLayout());
        this.add((Component)this.activeComp, "Center");
        this.add(Box.createHorizontalStrut(3), "West");
        this.add(Box.createHorizontalStrut(8), "North");
        this.add(Box.createHorizontalStrut(12), "East");
        this.add(Box.createHorizontalStrut(8), "South");
    }

    private void loadOemConfigControl() {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.loadOemInfo();
        if (null == oemInfo) {
            LOGGER.error("oemInfo is null.");
            throw new NullPointerException();
        }
        context.setCurOem(oemInfo);
        this.createOemUi(oemInfo);
    }

    private void loadOemConfigControlByType(String type) {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.loadOemInfo();
        if (oemInfo == null) {
            LOGGER.error("oemInfo is null.");
            return;
        }
        if ("MetaVision".equals(type)) {
            this.saveCurOemAndCreateUi(context, oemInfo.getFcvOemInfo(), "ComputStorageFCV");
            return;
        }
        if ("Storage".equals(type)) {
            this.saveCurOemAndCreateUi(context, oemInfo, "ComputeStorageStorage");
            return;
        }
        context.setCurOem(oemInfo);
        this.createOemUi(oemInfo);
    }

    private void saveCurOemAndCreateUi(OemDataContext context, OemInfo oemInfo, String packName) {
        oemInfo.setPackName(packName);
        context.setCurOem(oemInfo);
        this.createOemUi(oemInfo);
    }

    private void loadOemConfigByContext() {
        OemDataContext context = OemDataContext.getInstance();
        OemInfo oemInfo = context.getCurOem();
        this.createOemUi(oemInfo);
    }

    private void createOemUi(OemInfo oemInfo) {
        if (null == oemInfo) {
            throw new NullPointerException();
        }
        if (ResourceUtil.getString((String)"oem.tool.info.button.desc2.default").equals(this.productVersion)) {
            LOGGER.info("Please select the version first.");
            return;
        }
        if (OemConstants.isComputeStorageOemInfo(oemInfo)) {
            this.createComputeStorageOemUi(oemInfo);
        }
        List<FileItem> allFileItems = oemInfo.getInfoList();
        List<FileList> allFileLists = oemInfo.getAllFileList();
        this.createAllControl(allFileItems, allFileLists);
    }

    private void createComputeStorageOemUi(OemInfo oemInfo) {
        this.createFcvOemUi(oemInfo.getFcvOemInfo());
        this.createFcOemUi(oemInfo.getFcOemInfo());
        this.createOneTitleRow(ResourceUtil.getString((String)"oem.tool.creat.oem.info.title.storage"));
    }

    private void createFcOemUi(OemInfo fcOemInfo) {
        this.createOneTitleRow(ResourceUtil.getString((String)"oem.tool.creat.oem.info.title.fc"));
        List<FileItem> allFileItems = fcOemInfo.getInfoList();
        List<FileList> allFileLists = fcOemInfo.getAllFileList();
        this.createAllControl(allFileItems, allFileLists);
    }

    private void createFcvOemUi(OemInfo fcvOemInfo) {
        this.createOneTitleRow(ResourceUtil.getString((String)"oem.tool.creat.oem.info.title.fcv"));
        List<FileItem> allFileItems = fcvOemInfo.getInfoList();
        List<FileList> allFileLists = fcvOemInfo.getAllFileList();
        this.createAllControl(allFileItems, allFileLists);
    }

    private void createOneTitleRow(String title) {
        Box descBox = Box.createHorizontalBox();
        JLabel descLabel = new JLabel(title);
        descLabel.setFont(new Font("SimSun", 0, 20));
        descLabel.setToolTipText(title);
        descBox.add(descLabel);
        this.activeComp.add(Box.createVerticalStrut(10));
        this.activeComp.add(descBox);
        this.activeComp.add(Box.createVerticalStrut(10));
    }

    private void createAllControl(List<FileItem> allFileItems, List<FileList> allFileLists) {
        this.activeComp.add(Box.createVerticalStrut(12));
        this.createFileItemUi(allFileItems);
        this.createFileListUi(allFileLists);
        this.addBoxBindAction();
    }

    private void createFileItemUi(List<FileItem> allFileItems) {
        for (FileItem fileItem : allFileItems) {
            if (FileType.IMAGE.equals((Object)fileItem.getFileType())) {
                this.createImageSizeMessage(fileItem);
            }
            if (FileType.TEXT.equals((Object)fileItem.getFileType())) {
                this.createTextTipsMessage(fileItem);
            }
            this.createOneRow(this.activeComp, fileItem);
        }
    }

    private void createImageSizeMessage(FileItem fileItem) {
        String newTips;
        String sizeStr = fileItem.getValidaty().toLowerCase(Locale.ENGLISH).replaceAll("size\\((\\d+),(\\d+)\\)", "$1*$2");
        String tips = fileItem.getTips();
        if (tips.contains(newTips = ResourceUtil.getStringWithParams((String)"oem.tool.info.image.size.limit", (Object[])new Object[]{sizeStr}))) {
            LOGGER.info("The sizeLimit already exists.");
            return;
        }
        if (!StringUtils.isNULLStr((String)tips)) {
            newTips = !tips.contains("<html>") ? tips + "<br>" + newTips : tips.replace("</html>", "") + "<br>" + newTips + "</html>";
        }
        fileItem.setTips(newTips);
    }

    private void createTextTipsMessage(FileItem fileItem) {
        fileItem.getTxtInfos().stream().filter(info -> FileType.isTextFieldOrTextArea(info.getFileType())).filter(info -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)info.getRemind())).forEach(info -> info.setTips(info.getRemind()));
    }

    private void createFileListUi(List<FileList> allFileLists) {
        for (FileList fileList : allFileLists) {
            List<FileItem> allFileItems = fileList.getChildItem();
            this.createFileItemUi(allFileItems);
        }
    }

    private void addBoxBindAction() {
        for (Map.Entry<JComboBox, InfoItem> entry : this.hasBindActionItem.entrySet()) {
            JComboBox bindListBox = this.selectTypeComponent.get(entry.getValue().getBindKey());
            Map<String, List<String>> bindOptionsMap = entry.getValue().getBindMap();
            String defaultOption = (String)entry.getKey().getSelectedItem();
            entry.getKey().addItemListener(new SelectBindOptionAction(bindListBox, bindOptionsMap, defaultOption));
        }
    }

    private void createOneRow(JComponent box, FileItem fileItem) {
        FileType fileType = fileItem.getFileType();
        if (FileType.TEXT.equals((Object)fileType)) {
            List<InfoItem> curFileInfos = fileItem.getTxtInfos();
            for (InfoItem info : curFileInfos) {
                FileType curInfoType = info.getFileType();
                if (FileType.JSONTEXT.equals((Object)curInfoType)) {
                    LOGGER.info("Create OXM property lines.");
                    List<InfoItem> oxmItems = info.getOxmItems();
                    oxmItems.stream().forEach(oxmItem -> this.createOxmItemRow((InfoItem)oxmItem, box));
                    continue;
                }
                JComponent textRow = this.createTextRow(curInfoType, info);
                box.add(textRow);
                if (!textRow.isVisible()) continue;
                box.add(Box.createVerticalStrut(12));
            }
        } else if (FileType.IMAGE.equals((Object)fileType)) {
            JComponent imageRow = this.createImageRow(fileItem);
            box.add(imageRow);
            if (imageRow.isVisible()) {
                box.add(Box.createVerticalStrut(12));
            }
        } else {
            LOGGER.info("this file name is oemConfig.xml only contain node which's name is file");
        }
    }

    private JComboBox<?> handleSelect(InfoItem info) {
        String[] selectSet = new String[info.getSelectSet().size()];
        if (selectSet.length == 0) {
            return null;
        }
        Iterator<String> it = info.getSelectSet().keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String o = it.next();
            selectSet[i] = o.toString();
            ++i;
        }
        JComboBox<String> selectComp = new JComboBox<String>(selectSet);
        for (String key : info.getSelectSet().keySet()) {
            String tempKeyValue = info.getSelectSet().get(key);
            if (null == tempKeyValue) {
                LOGGER.error("key:" + info.getSelectSet().get(key) + " is not conf in res.");
                continue;
            }
            if (!tempKeyValue.equals(info.getDefValue())) continue;
            selectComp.setSelectedItem(key);
        }
        selectComp.addItemListener(new SelectOemInfoAction(info, info.getSelectSet()));
        return selectComp;
    }

    private void createOxmItemRow(InfoItem item, JComponent box) {
        Box textBox = Box.createVerticalBox();
        Box oxmRowBox = Box.createHorizontalBox();
        oxmRowBox.add(this.createDescLabel(item));
        oxmRowBox.add(Box.createHorizontalStrut(8));
        OemTextField field = new OemTextField(item);
        field.setText(item.getDefValue());
        field.setVisible(item.isVisible());
        oxmRowBox.add(field);
        oxmRowBox.add(Box.createHorizontalStrut(3));
        textBox.setVisible(item.isVisible());
        textBox.setMaximumSize(this.fieldSize);
        textBox.setMinimumSize(this.fieldSize);
        textBox.setPreferredSize(this.fieldSize);
        textBox.add(oxmRowBox);
        box.add(textBox);
        if (textBox.isVisible()) {
            box.add(Box.createVerticalStrut(12));
        }
    }

    private JComponent createTextRow(FileType type, InfoItem info) {
        Box textBox = Box.createVerticalBox();
        Box rowBox = Box.createHorizontalBox();
        rowBox.add(this.createDescLabel(info));
        rowBox.add(Box.createHorizontalStrut(8));
        if (FileType.TEXTFIELD.equals((Object)type)) {
            OemTextField field = new OemTextField(info);
            field.setText(info.getDefValue());
            field.setVisible(info.isVisible());
            rowBox.add(field);
            rowBox.add(Box.createHorizontalStrut(3));
            textBox.setVisible(info.isVisible());
            textBox.setMaximumSize(this.fieldSize);
            textBox.setMinimumSize(this.fieldSize);
            textBox.setPreferredSize(this.fieldSize);
        } else if (FileType.SELECT.equals((Object)type)) {
            JComboBox<?> selectComp = null;
            selectComp = this.handleSelect(info);
            if (null == selectComp) {
                textBox.add(rowBox);
                return textBox;
            }
            rowBox.add(Box.createHorizontalStrut(3));
            rowBox.add(selectComp);
            this.getSelectTypeBindInfo(selectComp, info);
            if (!ApplicationContext.getInstance().getCurrentLanguage().getLanguage().contains("zh")) {
                rowBox.add(Box.createHorizontalStrut(1));
            }
            textBox.setVisible(info.isVisible());
            textBox.setMaximumSize(this.fieldSize);
            textBox.setMinimumSize(this.fieldSize);
            textBox.setPreferredSize(this.fieldSize);
        } else {
            JTextArea area = new JTextArea();
            area.setLineWrap(true);
            OemScrollPane areaScroll = new OemScrollPane(area, info);
            areaScroll.setHorizontalScrollBarPolicy(31);
            areaScroll.setVerticalScrollBarPolicy(20);
            areaScroll.setVisible(info.isVisible());
            rowBox.add(areaScroll);
            rowBox.add(Box.createHorizontalStrut(2));
            textBox.setVisible(info.isVisible());
            textBox.setMaximumSize(this.areaSize);
            textBox.setMinimumSize(this.areaSize);
            textBox.setPreferredSize(this.areaSize);
        }
        textBox.add(rowBox);
        return textBox;
    }

    private void getSelectTypeBindInfo(JComboBox selectComp, InfoItem info) {
        this.selectTypeComponent.put(info.getKey(), selectComp);
        if (info.getBindKey() != null && !info.getBindMap().isEmpty()) {
            this.hasBindActionItem.put(selectComp, info);
        }
    }

    private JComponent createImageRow(FileItem fileItem) {
        Box imageBox = Box.createVerticalBox();
        Box rowBox = Box.createHorizontalBox();
        rowBox.add(this.createDescLabel(fileItem));
        rowBox.add(Box.createHorizontalStrut(8));
        String fileName = fileItem.getFileName();
        OemImage imageUrl = new OemImage(fileItem);
        if (new File(fileItem.getFilePath()).exists()) {
            imageUrl.setText(fileItem.getFilePath());
        }
        imageUrl.setVisible(fileItem.isVisible());
        rowBox.add(imageUrl);
        rowBox.add(Box.createHorizontalStrut(8));
        String imageType = fileName.substring(fileName.lastIndexOf("."));
        JButton imageButton = new JButton(ResourceUtil.getString((String)"oem.tool.info.browse.title"));
        imageButton.addActionListener(new BrowseActionListener(imageType, this.parent, fileItem));
        rowBox.add(imageButton);
        rowBox.add(Box.createHorizontalStrut(3));
        imageBox.add(rowBox);
        imageBox.setVisible(fileItem.isVisible());
        imageBox.setMaximumSize(this.fieldSize);
        imageBox.setMinimumSize(this.fieldSize);
        imageBox.setPreferredSize(this.fieldSize);
        return imageBox;
    }

    private JLabel createRequiredLabel() {
        JLabel requiredLabel = new JLabel("*");
        requiredLabel.setForeground(Color.RED);
        return requiredLabel;
    }

    private JComponent createDescLabel(ItemPro itemInfo) {
        String name = itemInfo.getDesc();
        String required = itemInfo.getRequired();
        Box descBox = Box.createHorizontalBox();
        JLabel descLabel = new JLabel(name);
        Dimension labelSize = new Dimension(195, 20);
        descLabel.setPreferredSize(labelSize);
        descLabel.setMaximumSize(labelSize);
        descLabel.setMinimumSize(labelSize);
        descLabel.setToolTipText(name);
        if (!StringUtils.isNULLStr((String)required) && Boolean.parseBoolean(required)) {
            descBox.add(this.createRequiredLabel());
            descBox.add(Box.createHorizontalStrut(2));
        } else {
            Dimension spaceSize = new Dimension(6, 20);
            JLabel spaceLabel = new JLabel();
            spaceLabel.setPreferredSize(spaceSize);
            spaceLabel.setMaximumSize(spaceSize);
            spaceLabel.setMinimumSize(spaceSize);
            descBox.add(spaceLabel);
        }
        descBox.add(descLabel);
        if (!StringUtils.isNULLStr((String)itemInfo.getTips())) {
            JLabel tipsImage = new JLabel(OemUIContext.TIPS_IMAGE);
            tipsImage.setToolTipText(itemInfo.getTips());
            descBox.add(tipsImage);
        }
        Dimension boxSize = new Dimension(218, 20);
        descBox.setPreferredSize(boxSize);
        descBox.setMaximumSize(boxSize);
        descBox.setMinimumSize(boxSize);
        return descBox;
    }

    public void importAndRefresh() {
        this.remove(this.activeComp);
        this.activeComp.removeAll();
        this.loadOemConfigByContext();
        this.activeComp.add(Box.createVerticalStrut(12));
        this.add((Component)this.activeComp, "Center");
        OemDataContext.getInstance().getOptionName().clear();
    }

    public void refresh() {
        this.remove(this.activeComp);
        this.activeComp.removeAll();
        this.loadOemConfigControl();
        this.add((Component)this.activeComp, "Center");
        this.updateUI();
        OemDataContext.getInstance().getOptionName().clear();
    }

    public void refreshByType(String type) {
        this.remove(this.activeComp);
        this.activeComp.removeAll();
        this.loadOemConfigControlByType(type);
        this.add((Component)this.activeComp, "Center");
        this.updateUI();
        OemDataContext.getInstance().getOptionName().clear();
    }

    public boolean checkData() {
        if (ResourceUtil.getString((String)"oem.tool.info.button.desc2.default").equals(this.productVersion)) {
            String tip = ResourceUtil.getString((String)"oem.tool.info.version.default.remind");
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)tip);
            return false;
        }
        OemInfo oemInfo = OemDataContext.getInstance().getCurOem();
        List<FileItem> fileItems = oemInfo.getInfoList();
        List<FileList> fileLists = oemInfo.getAllFileList();
        if (OemConstants.isComputeStorageOemInfo(oemInfo) && !this.checkComputeStorageNodesFileItemData(oemInfo)) {
            return false;
        }
        if (!this.checkFileItemData(fileItems)) {
            return false;
        }
        return this.checkFileListData(fileLists);
    }

    private boolean checkComputeStorageNodesFileItemData(OemInfo oemInfo) {
        return this.checkFileItemData(oemInfo.getFcvOemInfo().getInfoList()) && this.checkFileItemData(oemInfo.getFcOemInfo().getInfoList());
    }

    private boolean checkFileListData(List<FileList> fileLists) {
        for (FileList fileList : fileLists) {
            List<FileItem> fileItems = fileList.getChildItem();
            if (this.checkFileItemData(fileItems)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFileItemData(List<FileItem> fileItems) {
        ImageChecker service = null;
        for (FileItem fileItem : fileItems) {
            FileType fileType = fileItem.getFileType();
            if (!(FileType.IMAGE.equals((Object)fileType) ? !(service = new ImageChecker(fileItem, this.parent)).checkData() : !this.checkTextData(fileItem.getTxtInfos()))) continue;
            return false;
        }
        return true;
    }

    private boolean checkTextData(List<InfoItem> infos) {
        if (null == infos || infos.isEmpty()) {
            return true;
        }
        for (InfoItem info : infos) {
            if (!this.checkTextData4InfoItem(info)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTextData4InfoItem(InfoItem info) {
        if (FileType.JSONTEXT.equals((Object)info.getFileType())) {
            List<InfoItem> oxmItems = info.getOxmItems();
            for (InfoItem oxmItem : oxmItems) {
                oxmItem.setRemind(StringUtils.fillValues((String)oxmItem.getRemind(), (Object[])new Object[]{oxmItem.getKey()}));
                TextChecker service = new TextChecker(oxmItem, this.parent);
                if (service.checkData()) continue;
                return true;
            }
        } else {
            TextChecker service = new TextChecker(info, this.parent);
            if (!service.checkData()) {
                return true;
            }
        }
        return false;
    }

    public void setFieldSize(Dimension fieldSize) {
        this.fieldSize = fieldSize;
    }

    public Dimension getFieldSize() {
        return this.fieldSize;
    }

    public void setAreaSize(Dimension areaSize) {
        this.areaSize = areaSize;
    }

    public Dimension getAreaSize() {
        return this.areaSize;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }
}

